/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.util.Image;
import com.tom.cpm.client.GuiBase;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.VBuffer;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.Panel3d;
import com.tom.cpm.shared.model.render.RenderMode;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Panel3dImpl
extends Panel3d.Panel3dNative {
    private Minecraft mc = Minecraft.getInstance();

    public Panel3dImpl(Panel3d panel) {
        super(panel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(float partialTicks) {
        RenderSystem.backupProjectionMatrix();
        ViewportCamera cam = this.panel.getCamera();
        float pitch = (float)Math.asin(cam.look.y);
        float yaw = cam.look.getYaw();
        Box bounds = this.getBounds();
        Vec2i off = this.panel.getGui().getOffset();
        float size = cam.camDist;
        GuiBase gui = (GuiBase)this.panel.getGui().getNativeGui();
        GuiGraphics guiGraphics = gui.getMCGraphics();
        Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
        Quaternionf quaternion1 = Axis.XP.rotation(-pitch);
        quaternion.mul((Quaternionfc)quaternion1);
        try {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(off.x + bounds.w / 2), (float)(off.y + bounds.h / 2), 100.0f);
            guiGraphics.pose().mulPoseMatrix(new Matrix4f().scaling(size, size, -size / 10.0f));
            guiGraphics.pose().mulPose(quaternion);
            Lighting.setupForEntityInInventory();
            guiGraphics.pose().mulPose(Axis.YP.rotation((float)((double)yaw + Math.PI)));
            guiGraphics.pose().translate(-cam.position.x, -cam.position.y, -cam.position.z);
            MultiBufferSource.BufferSource bufs = guiGraphics.bufferSource();
            int light = LightTexture.pack((int)15, (int)15);
            this.panel.render(new MatrixStack(), new VBuffers(rt -> new VBuffer(bufs.getBuffer((RenderType)rt.getNativeType()), light, OverlayTexture.NO_OVERLAY, guiGraphics.pose())), partialTicks);
            bufs.endBatch();
        }
        finally {
            guiGraphics.pose().popPose();
            Lighting.setupFor3DItems();
        }
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes() {
        return this.getRenderTypes0(MinecraftObject.DynTexture.getBoundLoc());
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes(String texture) {
        return this.getRenderTypes0(new ResourceLocation("cpm", "textures/gui/" + texture + ".png"));
    }

    @Override
    public Image takeScreenshot(Vec2i size) {
        GuiBase gui = (GuiBase)this.panel.getGui().getNativeGui();
        int dw = this.mc.getWindow().getWidth();
        int dh = this.mc.getWindow().getHeight();
        float multiplierX = (float)dw / (float)gui.width;
        float multiplierY = (float)dh / (float)gui.height;
        int width = (int)(multiplierX * (float)size.x);
        int height = (int)(multiplierY * (float)size.y);
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(width * height * 3));
        GL11.glReadPixels((int)((int)(multiplierX * (float)this.renderPos.x)), (int)(this.mc.getWindow().getHeight() - height - (int)(multiplierY * (float)this.renderPos.y)), (int)width, (int)height, (int)6407, (int)5126, (FloatBuffer)buffer);
        Image img = new Image(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float r = buffer.get((x + y * width) * 3);
                float g = buffer.get((x + y * width) * 3 + 1);
                float b = buffer.get((x + y * width) * 3 + 2);
                int color = 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
                img.setRGB(x, height - y - 1, color);
            }
        }
        Image rImg = new Image(size.x, size.y);
        rImg.draw(img, 0, 0, size.x, size.y);
        return rImg;
    }

    @Override
    public Mat4f getView() {
        GuiBase gui = (GuiBase)this.panel.getGui().getNativeGui();
        return Mat4f.map(gui.getMCGraphics().pose().last().pose(), Matrix4f::get);
    }

    @Override
    public Mat4f getProjection() {
        return Mat4f.map(RenderSystem.getProjectionMatrix(), Matrix4f::get);
    }
}

