/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.BiomeHandler;
import com.tom.cpm.MinecraftServerObject;
import com.tom.cpm.common.PlatformCommon;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.shared.MinecraftServerAccess;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BiomeHandlerImpl
extends BiomeHandler<WorldImpl.BiomeInfo> {
    public static final BiomeHandlerImpl clientImpl = new BiomeHandlerImpl(() -> Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BIOME));
    public static final BiomeHandlerImpl serverImpl = new BiomeHandlerImpl(() -> ((MinecraftServerObject)MinecraftServerAccess.get()).getServer().registryAccess().registryOrThrow(Registries.BIOME));
    private static final BlockPos SEA_LEVEL = new BlockPos(0, 64, 0);
    private final Supplier<Registry<Biome>> registry;

    public static BiomeHandlerImpl getImpl(Level level) {
        return level.isClientSide ? clientImpl : serverImpl;
    }

    public BiomeHandlerImpl(Supplier<Registry<Biome>> registry) {
        this.registry = registry;
    }

    @Override
    public List<com.tom.cpl.block.Biome> listNativeEntries(String tag) {
        ResourceLocation rl = ResourceLocation.tryParse((String)tag);
        if (rl == null) {
            return Collections.emptyList();
        }
        Holder b = this.registry.get().getHolder(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rl)).orElse(null);
        if (b != null) {
            return Collections.singletonList(this.wrap(new WorldImpl.BiomeInfo((Holder<Biome>)b, SEA_LEVEL)));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> listNativeTags() {
        return this.registry.get().getTagNames().map(k -> k.location().toString()).toList();
    }

    @Override
    public com.tom.cpl.block.Biome emptyObject() {
        return this.wrap(null);
    }

    @Override
    public boolean isInTag(String tag, WorldImpl.BiomeInfo state) {
        if (tag.charAt(0) == '#') {
            ResourceLocation rl = ResourceLocation.tryParse((String)tag.substring(1));
            if (rl != null) {
                TagKey i = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rl);
                return state.biome().is(i);
            }
        } else {
            return this.getBiomeId(state).equals(tag);
        }
        return false;
    }

    @Override
    public List<String> listTags(WorldImpl.BiomeInfo state) {
        return state.biome().tags().map(k -> "#" + k.location()).toList();
    }

    @Override
    public List<com.tom.cpl.block.Biome> getAllElements() {
        return StreamSupport.stream(this.registry.get().asHolderIdMap().spliterator(), false).map(e -> this.wrap(new WorldImpl.BiomeInfo((Holder<Biome>)e, SEA_LEVEL))).collect(Collectors.toList());
    }

    @Override
    public boolean equals(WorldImpl.BiomeInfo a, WorldImpl.BiomeInfo b) {
        return a.value() == b.value();
    }

    @Override
    public String getBiomeId(WorldImpl.BiomeInfo state) {
        return this.registry.get().getKey((Object)state.value()).toString();
    }

    @Override
    public float getTemperature(WorldImpl.BiomeInfo state) {
        return state.value().getBaseTemperature();
    }

    @Override
    public float getHumidity(WorldImpl.BiomeInfo state) {
        return PlatformCommon.getClimateSettings(state.value()).downfall();
    }

    @Override
    public BiomeHandler.RainType getRainType(WorldImpl.BiomeInfo state) {
        return BiomeHandler.RainType.get(state.value().getPrecipitationAt(state.at()).name());
    }

    @Override
    public boolean isAvailable() {
        try {
            return this.registry.get() != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

