/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.io;

import com.tom.cpl.util.Image;
import java.io.InputStream;

public class SkinDataInputStream
extends InputStream {
    private Image img;
    private Image template;
    private int block;
    private int channel;
    private int x;
    private int y;
    private boolean finished;

    public SkinDataInputStream(Image img, Image template, int channel) {
        this.img = img;
        this.template = template;
        this.channel = channel;
        this.block = -1;
        this.x = -1;
    }

    @Override
    public int read() {
        if (this.finished) {
            return -1;
        }
        if (this.block == -1 || this.block > 3) {
            this.findNextBlock();
            if (this.finished) {
                return -1;
            }
            this.block = 0;
        }
        int dt = this.img.getRGB(this.x, this.y);
        int shift = this.block++ * 8;
        if ((this.template.getRGB(this.x, this.y) & 0xFF) == 255 && this.block > 2) {
            ++this.block;
        }
        return (dt & 255 << shift) >>> shift & 0xFF;
    }

    private void findNextBlock() {
        int shift = 8 * (2 - this.channel);
        for (int y = this.y; y < this.img.getHeight(); ++y) {
            for (int x = this.x + 1; x < this.img.getWidth(); ++x) {
                int t = this.template.getRGB(x, y);
                if (((t & 255 << shift) >>> shift & 0xFF) != 255) continue;
                this.x = x;
                this.y = y;
                return;
            }
            this.x = -1;
        }
        this.finished = true;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public int getChannel() {
        return this.channel;
    }

    @Override
    public void close() {
    }
}

