/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.bukkit;

import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.ScalingOptions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlotGroup;

public class AttributeScaler
implements NetHandler.ScalerInterface<Player, List<Attribute>> {
    private static final ScalerInt scaler;
    public static final Attribute MAX_HEALTH;

    @Override
    public void setScale(List<Attribute> key, Player player, float value) {
        key.forEach(a -> {
            AttributeInstance ai = player.getAttribute(a);
            if (ai != null) {
                scaler.apply(ai, value);
            }
        });
    }

    public static Attribute getAttributeSafely(String name) {
        try {
            return (Attribute)Attribute.class.getField(name).get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            try {
                return (Attribute)Attribute.class.getField(name.substring(name.indexOf(95) + 1, name.length())).get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e2) {
                Log.info("Attribute not found, skipping: " + name);
                throw new RuntimeException("Attribute not found: " + name);
            }
        }
    }

    @Override
    public List<Attribute> toKey(ScalingOptions opt) {
        try {
            switch (opt) {
                case HEALTH: {
                    return Collections.singletonList(MAX_HEALTH);
                }
                case ATTACK_DMG: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("GENERIC_ATTACK_DAMAGE"));
                }
                case ATTACK_KNOCKBACK: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("GENERIC_ATTACK_KNOCKBACK"));
                }
                case ATTACK_SPEED: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("GENERIC_ATTACK_SPEED"));
                }
                case DEFENSE: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("GENERIC_ARMOR"));
                }
                case FLIGHT_SPEED: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("GENERIC_FLYING_SPEED"));
                }
                case MOB_VISIBILITY: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("GENERIC_FOLLOW_RANGE"));
                }
                case MOTION: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("GENERIC_MOVEMENT_SPEED"));
                }
                case ENTITY: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("GENERIC_SCALE"));
                }
                case REACH: {
                    return Arrays.asList(AttributeScaler.getAttributeSafely("PLAYER_BLOCK_INTERACTION_RANGE"), AttributeScaler.getAttributeSafely("PLAYER_ENTITY_INTERACTION_RANGE"));
                }
                case MINING_SPEED: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("PLAYER_BLOCK_BREAK_SPEED"));
                }
                case SAFE_FALL_DISTANCE: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("GENERIC_SAFE_FALL_DISTANCE"));
                }
                case JUMP_HEIGHT: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("GENERIC_JUMP_STRENGTH"));
                }
                case KNOCKBACK_RESIST: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("GENERIC_KNOCKBACK_RESISTANCE"));
                }
                case STEP_HEIGHT: {
                    return Collections.singletonList(AttributeScaler.getAttributeSafely("GENERIC_STEP_HEIGHT"));
                }
                case THIRD_PERSON: {
                    return Collections.singletonList(Attribute.CAMERA_DISTANCE);
                }
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public String getMethodName() {
        return "attribute";
    }

    static {
        ScalerInt scaler0;
        try {
            AttributeModifier.class.getDeclaredMethod("getKey", new Class[0]);
            scaler0 = new KeyScaler();
            Log.info("Using NamespacedKey attributes");
        }
        catch (NoSuchMethodException | SecurityException e) {
            scaler0 = new UUIDScaler();
            Log.info("Using UUID attributes");
        }
        scaler = scaler0;
        MAX_HEALTH = AttributeScaler.getAttributeSafely("GENERIC_MAX_HEALTH");
    }

    private static interface ScalerInt {
        public void apply(AttributeInstance var1, float var2);
    }

    private static class KeyScaler
    implements ScalerInt {
        private static final NamespacedKey CPM_ATTR_KEY = new NamespacedKey("cpm", "scaling");

        private KeyScaler() {
        }

        @Override
        public void apply(AttributeInstance ai, float value) {
            ai.getModifiers().stream().filter(i -> i.getKey().equals((Object)CPM_ATTR_KEY)).collect(Collectors.toList()).forEach(arg_0 -> ((AttributeInstance)ai).removeModifier(arg_0));
            if (Math.abs(value - 1.0f) > 0.01f) {
                ai.addModifier(new AttributeModifier(CPM_ATTR_KEY, (double)(value - 1.0f), AttributeModifier.Operation.ADD_SCALAR, EquipmentSlotGroup.ANY));
            }
        }
    }

    private static class UUIDScaler
    implements ScalerInt {
        private static final UUID CPM_ATTR_UUID = UUID.fromString("24bba381-9615-4530-8fcf-4fc42393a4b5");
        private static final Method getUniqueIdMethod;
        private static final Constructor<?> modifierConstructor;

        private UUIDScaler() {
        }

        @Override
        public void apply(AttributeInstance ai, float value) {
            try {
                Collection modifiers = ai.getModifiers();
                ArrayList<AttributeModifier> toRemove = new ArrayList<AttributeModifier>();
                for (AttributeModifier mod : modifiers) {
                    UUID id = (UUID)getUniqueIdMethod.invoke((Object)mod, new Object[0]);
                    if (!CPM_ATTR_UUID.equals(id)) continue;
                    toRemove.add(mod);
                }
                for (AttributeModifier mod : toRemove) {
                    ai.removeModifier(mod);
                }
                if (Math.abs(value - 1.0f) > 0.01f) {
                    AttributeModifier newMod = (AttributeModifier)modifierConstructor.newInstance(CPM_ATTR_UUID, "cpm", Float.valueOf(value - 1.0f), AttributeModifier.Operation.ADD_SCALAR);
                    ai.addModifier(newMod);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static {
            try {
                Class<AttributeModifier> modifierClass = AttributeModifier.class;
                getUniqueIdMethod = modifierClass.getMethod("getUniqueId", new Class[0]);
                modifierConstructor = modifierClass.getConstructor(UUID.class, String.class, Double.TYPE, AttributeModifier.Operation.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to reflect legacy AttributeModifier methods", e);
            }
        }
    }
}

