/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Tree<T>
extends GuiElement {
    private Map<Integer, TreeHandler.TreeElement<T>> map = new HashMap<Integer, TreeHandler.TreeElement<T>>();
    private TreeHandler<T> handler;
    private Frame frame;
    private Consumer<Vec2i> sizeUpdate;

    public Tree(Frame gui, TreeModel<T> model) {
        super(gui.getGui());
        this.frame = gui;
        this.handler = new TreeHandler<T>(model);
    }

    public Tree(Frame gui, TreeHandler<T> handler) {
        super(gui.getGui());
        this.frame = gui;
        this.handler = handler;
    }

    @Override
    public void mouseClick(MouseEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        if (this.bounds.isInBounds(evt.x, evt.y)) {
            int yp = (evt.y - this.bounds.y) / 10;
            TreeHandler.TreeElement<T> elem = this.map.get(yp);
            if (elem != null) {
                if (evt.btn == 0 && evt.x < 5 + elem.depth * 5 && elem != this.handler.root && !elem.children.isEmpty()) {
                    boolean bl = elem.showChildren = !elem.showChildren;
                    if (this.sizeUpdate != null) {
                        this.sizeUpdate.accept(this.getSize());
                    }
                } else {
                    this.handler.model.onClick(this.gui, evt, elem.value);
                }
            } else {
                this.handler.model.onClick(this.gui, evt, null);
            }
            this.handler.model.treeUpdated();
            evt.consume();
        }
    }

    public Vec2i getSize() {
        int[] s = new int[2];
        this.walk_getSize(s, this.handler.root, 0);
        return new Vec2i(s[0], s[1] * 10);
    }

    private void walk_getSize(int[] s, TreeHandler.TreeElement<T> e, int layer) {
        s[1] = s[1] + 1;
        s[0] = Math.max(s[0], layer * 5 + this.gui.textWidth(e.display) + 5 + this.handler.model.getExtraWidth(e.value, this.gui));
        if (e.showChildren) {
            for (TreeHandler.TreeElement i : e.children) {
                this.walk_getSize(s, i, layer + 1);
            }
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.map.clear();
        this.drawTree(event, 0, new int[1], this.handler.root);
    }

    private void drawTree(MouseEvent event, int x, int[] y, TreeHandler.TreeElement<T> e) {
        int txtc;
        int bg;
        int n = y[0];
        y[0] = n + 1;
        int yp = n;
        int textColor = this.gui.getColors().button_text_color;
        int n2 = bg = e.value == null ? 0 : this.handler.model.bgColor(e.value, this.gui);
        if (bg != 0) {
            this.gui.drawBox(x * 5, yp * 10, this.bounds.w, 10, bg);
        }
        int n3 = txtc = e.value == null ? 0 : this.handler.model.textColor(e.value, this.gui);
        if (txtc != 0) {
            textColor = txtc;
        }
        int dropD = textColor;
        if (event.isHovered(new Box(this.bounds.x, yp * 10, this.bounds.w, 10))) {
            textColor = this.gui.getColors().button_text_hover;
            Tooltip tt = this.handler.model.getTooltip(e.value, this.gui);
            if (tt != null) {
                tt.set();
            }
            if (event.isHovered(new Box(this.bounds.x, yp * 10, 5 + e.depth * 5, 10))) {
                dropD = textColor;
            }
        }
        this.map.put(yp, e);
        int tw = this.gui.textWidth(e.display);
        this.gui.drawText(x * 5 + 3, yp * 10, e.display, textColor);
        this.handler.model.drawName(e.value, this.gui, x * 5 + 3 + tw + 1, yp * 10, textColor);
        e.depth = x;
        if (e.showChildren) {
            if (e != this.handler.root && !e.children.isEmpty()) {
                this.gui.drawTexture(x * 5 - 5, yp * 10, 8, 8, 0, 8, "editor", dropD);
            }
            for (TreeHandler.TreeElement i : e.children) {
                this.drawTree(event, x + 1, y, i);
            }
        } else if (e != this.handler.root && !e.children.isEmpty()) {
            this.gui.drawTexture(x * 5 - 5, yp * 10, 8, 8, 0, 0, "editor", dropD);
        }
    }

    public void updateTree() {
        this.walk_updateTree(this.handler.root);
        if (this.sizeUpdate != null) {
            this.sizeUpdate.accept(this.getSize());
        }
    }

    private boolean walk_updateTree(TreeHandler.TreeElement<T> e) {
        boolean r = this.handler.model.isSelected(e.value);
        for (TreeHandler.TreeElement i : e.children) {
            boolean w = this.walk_updateTree(i);
            e.showChildren |= w;
            r |= w;
        }
        return r;
    }

    public void setSizeUpdate(Consumer<Vec2i> sizeUpdate) {
        this.sizeUpdate = sizeUpdate;
    }

    private TreeHandler.TreeElement<T> find(T elem) {
        return this.handler.find(Collections.singletonList(this.handler.root), elem);
    }

    private TreeHandler.TreeElement<T> findParent(TreeHandler.TreeElement<T> elem) {
        if (elem == null) {
            return null;
        }
        return this.walk_findParent(this.handler.root, elem);
    }

    private TreeHandler.TreeElement<T> walk_findParent(TreeHandler.TreeElement<T> e, TreeHandler.TreeElement<T> toFind) {
        for (TreeHandler.TreeElement i : e.children) {
            if (i == toFind) {
                return e;
            }
            TreeHandler.TreeElement d = this.walk_findParent(i, toFind);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    public T findUp(T curr) {
        TreeHandler.TreeElement<T> p = this.findParent(this.find(curr));
        if (p != null) {
            return p.value;
        }
        return curr;
    }

    public T findDown(T curr) {
        TreeHandler.TreeElement<T> p = this.find(curr);
        if (p != null && !p.children.isEmpty()) {
            for (TreeHandler.TreeElement e : p.children) {
                if (!this.handler.model.canSelect(e.value)) continue;
                return e.value;
            }
        }
        return curr;
    }

    public T findNext(T curr) {
        int i;
        TreeHandler.TreeElement<T> c = this.find(curr);
        TreeHandler.TreeElement<T> p = this.findParent(c);
        if (c != null && p != null && (i = p.children.indexOf(c)) != -1) {
            ++i;
            while (i < p.children.size()) {
                TreeHandler.TreeElement e = p.children.get(i);
                if (this.handler.model.canSelect(e.value)) {
                    return e.value;
                }
                ++i;
            }
        }
        return curr;
    }

    public T findPrev(T curr) {
        TreeHandler.TreeElement<T> c = this.find(curr);
        TreeHandler.TreeElement<T> p = this.findParent(c);
        if (c != null && p != null) {
            int i = p.children.indexOf(c);
            --i;
            while (i >= 0) {
                TreeHandler.TreeElement e = p.children.get(i);
                if (this.handler.model.canSelect(e.value)) {
                    return e.value;
                }
                --i;
            }
        }
        return curr;
    }

    public int getElementY(T elem) {
        int[] c = new int[]{1, 0};
        this.walk_getElementY(this.handler.root, elem, c);
        return c[1] != 0 ? c[0] * 10 : -1;
    }

    private void walk_getElementY(TreeHandler.TreeElement<T> e, T elem, int[] c) {
        for (TreeHandler.TreeElement i : e.children) {
            if (c[1] != 0) {
                return;
            }
            if (i.value == elem) {
                c[1] = 1;
                return;
            }
            c[0] = c[0] + 1;
            if (!i.showChildren) continue;
            this.walk_getElementY(i, elem, c);
        }
    }

    public static class TreeHandler<T> {
        private TreeModel<T> model;
        private TreeElement<T> root = new TreeElement();

        public TreeHandler(TreeModel<T> model) {
            this.root.display = "Root";
            this.model = model;
        }

        public void update() {
            ArrayList old = new ArrayList(this.root.children);
            this.root.children.clear();
            this.root.showChildren = true;
            this.model.getElements(null, e -> {
                TreeElement t = new TreeElement();
                t.display = this.model.getName(e);
                t.value = e;
                TreeElement<Object> oldTree = this.find(old, e);
                if (oldTree != null) {
                    t.showChildren = oldTree.showChildren;
                }
                this.root.children.add(t);
                this.model.refresh(e);
                this.walkChildren(t, oldTree != null ? oldTree.children : null);
            });
        }

        private TreeElement<T> find(List<TreeElement<T>> list, T elem) {
            for (TreeElement<T> e : list) {
                if (e.value == elem) {
                    return e;
                }
                TreeElement d = this.find(e.children, elem);
                if (d == null) continue;
                return d;
            }
            return null;
        }

        private void walkChildren(TreeElement<T> p, List<TreeElement<T>> old) {
            this.model.getElements(p.value, e -> {
                TreeElement t = new TreeElement();
                t.display = this.model.getName(e);
                t.value = e;
                p.children.add(t);
                TreeElement<Object> oldTree = null;
                if (old != null) {
                    oldTree = this.find(old, e);
                }
                if (oldTree != null) {
                    t.showChildren = oldTree.showChildren;
                }
                this.walkChildren(t, oldTree != null ? oldTree.children : null);
            });
        }

        public TreeModel<T> getModel() {
            return this.model;
        }

        public List<T> getOpenElements() {
            ArrayList l = new ArrayList();
            this.walk_getOpenElements(this.root, l);
            return l;
        }

        private void walk_getOpenElements(TreeElement<T> e, List<T> l) {
            for (TreeElement i : e.children) {
                if (i.showChildren) {
                    l.add(i.value);
                }
                this.walk_getOpenElements(i, l);
            }
        }

        public void setOpenElements(List<T> list) {
            this.walk_setOpenElements(this.root, list);
        }

        private void walk_setOpenElements(TreeElement<T> e, List<T> l) {
            for (TreeElement i : e.children) {
                i.showChildren = l.contains(i.value);
                this.walk_setOpenElements(i, l);
            }
        }

        public static class TreeElement<T> {
            private String display;
            private T value;
            private List<TreeElement<T>> children = new ArrayList<TreeElement<T>>();
            private boolean showChildren;
            private int depth;
        }
    }

    public static abstract class TreeModel<T> {
        protected abstract int textColor(T var1, IGui var2);

        protected abstract void getElements(T var1, Consumer<T> var2);

        protected abstract int bgColor(T var1, IGui var2);

        protected abstract void treeUpdated();

        protected abstract void onClick(IGui var1, MouseEvent var2, T var3);

        protected abstract String getName(T var1);

        protected abstract Tooltip getTooltip(T var1, IGui var2);

        protected abstract void refresh(T var1);

        protected abstract boolean isSelected(T var1);

        protected abstract boolean canSelect(T var1);

        protected abstract void drawName(T var1, IGui var2, int var3, int var4, int var5);

        protected abstract int getExtraWidth(T var1, IGui var2);
    }
}

