/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project;

import com.tom.cpl.util.ThrowingConsumer;
import com.tom.cpl.util.ThrowingFunction;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.JsonMapImpl;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public interface IProject {
    public byte[] getEntry(String var1);

    public List<String> listEntires(String var1);

    default public InputStream getAsStream(String path) throws IOException {
        byte[] dt = this.getEntry(path);
        if (dt == null) {
            throw new FileNotFoundException();
        }
        return new ByteArrayInputStream(dt);
    }

    default public JsonMap toJson(InputStreamReader rd) {
        return new JsonMapImpl((Map)MinecraftObjectHolder.gson.fromJson((Reader)rd, Object.class));
    }

    default public JsonMap getJson(String path) throws IOException {
        try (InputStreamReader rd = new InputStreamReader(this.getAsStream(path));){
            JsonMap jsonMap = this.toJson(rd);
            return jsonMap;
        }
    }

    default public <E extends Throwable> void jsonIfExists(String path, ThrowingConsumer<JsonMap, E> e) throws IOException, E {
        byte[] ze = this.getEntry(path);
        if (ze != null) {
            try (InputStreamReader rd = new InputStreamReader(new ByteArrayInputStream(ze));){
                e.accept(this.toJson(rd));
            }
        }
    }

    default public <R, E extends Throwable> void ifExists(String path, ThrowingFunction<InputStream, R, E> loader, Consumer<R> e) throws E {
        byte[] ze = this.getEntry(path);
        if (ze != null) {
            e.accept(loader.apply(new ByteArrayInputStream(ze)));
        }
    }

    default public <R, E extends Throwable> R getIfExists(String path, ThrowingFunction<InputStream, R, E> e) throws E {
        byte[] ze = this.getEntry(path);
        if (ze != null) {
            return e.apply(new ByteArrayInputStream(ze));
        }
        return null;
    }
}

