/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.item.ItemStackHandler;
import com.tom.cpl.item.NbtMapper;
import com.tom.cpl.item.Stack;
import com.tom.cpl.nbt.NBTTagCompound;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.multiplayer.ClientRegistryLayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemStackHandlerImpl
extends ItemStackHandler<ItemStack> {
    public static final ItemStackHandlerImpl impl = new ItemStackHandlerImpl();
    public static final NBT nbt = new NBT();

    @Override
    public int getCount(ItemStack stack) {
        return stack.getCount();
    }

    @Override
    public int getMaxCount(ItemStack stack) {
        return stack.getMaxStackSize();
    }

    @Override
    public int getDamage(ItemStack stack) {
        return stack.getDamageValue();
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return stack.getMaxDamage();
    }

    @Override
    public boolean itemEquals(ItemStack a, ItemStack b) {
        return ItemStack.isSameItem((ItemStack)a, (ItemStack)b);
    }

    @Override
    public boolean itemEqualsFull(ItemStack a, ItemStack b) {
        return ItemStack.isSameItemSameTags((ItemStack)a, (ItemStack)b);
    }

    @Override
    public List<String> listNativeTags() {
        return BuiltInRegistries.ITEM.getTagNames().map(k -> k.location().toString()).toList();
    }

    @Override
    public List<Stack> getAllElements() {
        if (CreativeModeTabs.searchTab().getSearchTabDisplayItems().isEmpty()) {
            CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA), (boolean)false, (HolderLookup.Provider)ClientRegistryLayer.createRegistryAccess().compositeAccess());
        }
        return CreativeModeTabs.searchTab().getSearchTabDisplayItems().stream().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public NBTTagCompound getTag(ItemStack stack) {
        return stack.hasTag() ? nbt.wrap(stack.getTag()) : null;
    }

    @Override
    public List<Stack> listNativeEntries(String tag) {
        ArrayList<Stack> stacks = new ArrayList<Stack>();
        if (tag.charAt(0) == '#') {
            ResourceLocation rl = ResourceLocation.tryParse((String)tag.substring(1));
            if (rl != null) {
                TagKey i = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rl);
                BuiltInRegistries.ITEM.getTag(i).map(t -> t.stream().map(h -> h.unwrap().right()).filter(Optional::isPresent).map(o -> this.wrap(new ItemStack((ItemLike)o.get()))).toList()).ifPresent(stacks::addAll);
            }
        } else {
            ResourceLocation rl = ResourceLocation.tryParse((String)tag);
            Item item = (Item)BuiltInRegistries.ITEM.get(rl);
            if (item != null) {
                stacks.add(this.wrap(new ItemStack((ItemLike)item)));
            }
        }
        return stacks;
    }

    @Override
    public boolean isInTag(String tag, ItemStack stack) {
        if (tag.charAt(0) == '#') {
            ResourceLocation rl = ResourceLocation.tryParse((String)tag.substring(1));
            if (rl != null) {
                TagKey i = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rl);
                return stack.is(i);
            }
        } else {
            return this.getItemId(stack).equals(tag);
        }
        return false;
    }

    @Override
    public List<String> listTags(ItemStack stack) {
        return stack.getTags().map(k -> "#" + k.location()).toList();
    }

    @Override
    public String getItemId(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
    }

    @Override
    public Stack emptyObject() {
        return this.wrap(ItemStack.EMPTY);
    }

    @Override
    public String getItemDisplayName(ItemStack stack) {
        return stack.getDisplayName().getString();
    }

    public static class NBT
    extends NbtMapper<Tag, CompoundTag, ListTag, NumericTag> {
        @Override
        public long getLong(NumericTag t) {
            return t.getAsLong();
        }

        @Override
        public int getInt(NumericTag t) {
            return t.getAsInt();
        }

        @Override
        public short getShort(NumericTag t) {
            return t.getAsShort();
        }

        @Override
        public byte getByte(NumericTag t) {
            return t.getAsByte();
        }

        @Override
        public double getDouble(NumericTag t) {
            return t.getAsDouble();
        }

        @Override
        public float getFloat(NumericTag t) {
            return t.getAsFloat();
        }

        @Override
        public NumericTag asNumber(Tag t) {
            return t instanceof NumericTag ? (NumericTag)t : null;
        }

        @Override
        public String getString(Tag t) {
            return t.getAsString();
        }

        @Override
        public Tag getTag(CompoundTag t, String name) {
            return t.get(name);
        }

        @Override
        public ListTag asList(Tag t) {
            return t instanceof ListTag ? (ListTag)t : null;
        }

        @Override
        public CompoundTag asCompound(Tag t) {
            return t instanceof CompoundTag ? (CompoundTag)t : null;
        }

        @Override
        public int listSize(ListTag t) {
            return t.size();
        }

        @Override
        public Tag getAt(ListTag t, int i) {
            return t.get(i);
        }

        @Override
        public boolean contains(CompoundTag t, String name, int type) {
            return t.contains(name, type);
        }

        @Override
        public CompoundTag newCompound() {
            return new CompoundTag();
        }

        @Override
        public ListTag newList() {
            return new ListTag();
        }

        @Override
        public Iterable<String> keys(CompoundTag t) {
            return t.getAllKeys();
        }

        @Override
        public int getId(Tag t) {
            return t.getId();
        }

        @Override
        public byte[] getByteArray(Tag t) {
            return t instanceof ByteArrayTag ? ((ByteArrayTag)t).getAsByteArray() : new byte[]{};
        }

        @Override
        public int[] getIntArray(Tag t) {
            return t instanceof IntArrayTag ? ((IntArrayTag)t).getAsIntArray() : new int[]{};
        }

        @Override
        public long[] getLongArray(Tag t) {
            return t instanceof LongArrayTag ? ((LongArrayTag)t).getAsLongArray() : new long[]{};
        }
    }
}

