/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.util.Image;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.VBuffer;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.Panel3d;
import com.tom.cpm.shared.model.render.RenderMode;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Panel3dImpl
extends Panel3d.Panel3dNative {
    private Minecraft mc = Minecraft.getInstance();
    private Vec2i mouse;
    private Mat4f view;
    private Mat4f proj;

    public Panel3dImpl(Panel3d panel) {
        super(panel);
    }

    @Override
    public void render(float partialTicks) {
        GuiImpl gui = (GuiImpl)this.panel.getGui().getNativeGui();
        Vec2i mouse = super.getMouse();
        Vec2i off = this.panel.getGui().getOffset();
        this.mouse = new Vec2i(mouse.x - off.x, mouse.y - off.y);
        Box bounds = this.getBounds();
        gui.drawPip(this, bounds.w, bounds.h, State::new);
    }

    @Override
    public Vec2i get3dSize() {
        return new Vec2i(this.panel.getBounds().w, this.panel.getBounds().h);
    }

    @Override
    public Vec2i getMouse() {
        return this.mouse;
    }

    @Override
    public void draw3dOverlay() {
        Box bounds = this.getBounds();
        Vec2i ws = this.get3dSize();
        this.panel.getGui().drawTexture(bounds.x, bounds.y, bounds.w, bounds.h, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes() {
        return this.getRenderTypes0(MinecraftObject.DynTexture.getBoundLoc());
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes(String texture) {
        return this.getRenderTypes0(ResourceLocation.tryBuild((String)"cpm", (String)("textures/gui/" + texture + ".png")));
    }

    @Override
    public Image takeScreenshot(Vec2i size) {
        GuiImpl gui = (GuiImpl)this.panel.getGui().getNativeGui();
        int dw = this.mc.getWindow().getWidth();
        int dh = this.mc.getWindow().getHeight();
        float multiplierX = (float)dw / (float)gui.width;
        float multiplierY = (float)dh / (float)gui.height;
        int width = (int)(multiplierX * (float)size.x);
        int height = (int)(multiplierY * (float)size.y);
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(width * height * 3));
        GL11.glReadPixels((int)((int)(multiplierX * (float)this.renderPos.x)), (int)(this.mc.getWindow().getHeight() - height - (int)(multiplierY * (float)this.renderPos.y)), (int)width, (int)height, (int)6407, (int)5126, (FloatBuffer)buffer);
        Image img = new Image(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float r = buffer.get((x + y * width) * 3);
                float g = buffer.get((x + y * width) * 3 + 1);
                float b = buffer.get((x + y * width) * 3 + 2);
                int color = 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
                img.setRGB(x, height - y - 1, color);
            }
        }
        Image rImg = new Image(size.x, size.y);
        rImg.draw(img, 0, 0, size.x, size.y);
        return rImg;
    }

    @Override
    public Mat4f getView() {
        return this.view;
    }

    @Override
    public Mat4f getProjection() {
        return this.proj;
    }

    public static class Renderer
    extends PictureInPictureRenderer<State> {
        public Renderer(MultiBufferSource.BufferSource bufferSource) {
            super(bufferSource);
        }

        public Class<State> getRenderStateClass() {
            return State.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void renderToTexture(State pipState, PoseStack poseStack) {
            float partialTicks = 0.0f;
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
            Panel3d panel = pipState.impl().panel;
            GuiImpl gui = (GuiImpl)panel.getGui().getNativeGui();
            ViewportCamera cam = panel.getCamera();
            float pitch = (float)Math.asin(-cam.look.y);
            float yaw = cam.look.getYaw();
            float size = cam.camDist;
            Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
            Quaternionf quaternion1 = Axis.XP.rotation(pitch);
            quaternion.mul((Quaternionfc)quaternion1);
            int i = Minecraft.getInstance().getWindow().getGuiScale();
            int j = (pipState.x1() - pipState.x0()) * i;
            int k = (pipState.y1() - pipState.y0()) * i;
            Matrix4f proj = new Matrix4f().setOrtho(0.0f, (float)j, (float)k, 0.0f, -1000.0f, 1000.0f);
            pipState.impl().proj = Mat4f.map(proj, Matrix4f::get);
            try {
                poseStack.pushPose();
                poseStack.mulPose((Matrix4fc)new Matrix4f().scaling(size, size, size));
                poseStack.mulPose((Quaternionfc)quaternion);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)((double)yaw + Math.PI)));
                poseStack.translate(-cam.position.x, -cam.position.y, -cam.position.z);
                pipState.impl().view = Mat4f.map(poseStack.last().pose(), Matrix4f::get);
                int light = LightTexture.pack((int)15, (int)15);
                panel.render(new MatrixStack(), new VBuffers(rt -> new VBuffer(this.bufferSource.getBuffer((RenderType)rt.getNativeType()), light, OverlayTexture.NO_OVERLAY, poseStack)), partialTicks);
            }
            finally {
                poseStack.popPose();
            }
        }

        protected float getTranslateY(int i, int j) {
            return (float)i / 2.0f;
        }

        protected String getTextureLabel() {
            return "cpm:panel3d";
        }
    }

    public record State(Panel3dImpl impl, int x0, int y0, int x1, int y1, ScreenRectangle bounds, ScreenRectangle scissorArea) implements PictureInPictureRenderState
    {
        public State(Panel3dImpl impl, int x0, int y0, int x1, int y1, ScreenRectangle scissorArea) {
            this(impl, x0, y0, x1, y1, PictureInPictureRenderState.getBounds((int)x0, (int)y0, (int)x1, (int)y1, (ScreenRectangle)scissorArea), scissorArea);
        }

        public float scale() {
            return 1.0f;
        }
    }
}

