/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.item.NamedSlot;
import com.tom.cpl.item.Stack;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.shared.animation.AnimationState;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;

public class PlayerInventory
implements com.tom.cpl.item.Inventory {
    private Inventory inv;

    public static void setInv(AnimationState a, Inventory inv) {
        if (!(a.playerInventory instanceof PlayerInventory)) {
            a.playerInventory = new PlayerInventory();
        }
        ((PlayerInventory)a.playerInventory).inv = inv;
    }

    @Override
    public int size() {
        return this.inv == null ? 0 : this.inv.getContainerSize();
    }

    @Override
    public Stack getInSlot(int i) {
        return ItemStackHandlerImpl.impl.wrap(this.inv.getItem(i));
    }

    @Override
    public void reset() {
        this.inv = null;
    }

    @Override
    public int getNamedSlotId(NamedSlot slot) {
        return switch (slot) {
            case NamedSlot.MAIN_HAND -> this.inv.getSelectedSlot();
            case NamedSlot.ARMOR_BOOTS -> EquipmentSlot.FEET.getIndex(this.inv.getNonEquipmentItems().size());
            case NamedSlot.ARMOR_CHESTPLATE -> EquipmentSlot.CHEST.getIndex(this.inv.getNonEquipmentItems().size());
            case NamedSlot.ARMOR_HELMET -> EquipmentSlot.HEAD.getIndex(this.inv.getNonEquipmentItems().size());
            case NamedSlot.ARMOR_LEGGINGS -> EquipmentSlot.LEGS.getIndex(this.inv.getNonEquipmentItems().size());
            case NamedSlot.OFF_HAND -> this.inv.getNonEquipmentItems().size() + 4;
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)slot));
        };
    }
}

