/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.skin;

import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.DynamicTexture;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import com.tom.cpm.shared.config.ConfigKeys;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.definition.SafetyException;
import com.tom.cpm.shared.io.IOHelper;
import java.io.DataOutputStream;
import java.io.IOException;

public class TextureProvider {
    public DynamicTexture texture;
    public Vec2i size;

    public TextureProvider() {
        this.size = new Vec2i(64, 64);
    }

    public TextureProvider(IOHelper in, ModelDefinition def) throws IOException {
        this.size = in.read2s();
        IOHelper.ImageBlock block = in.readImage();
        if (def != null) {
            ConfigKeys.MAX_TEX_SHEET_SIZE.checkFor(def.getPlayerObj(), block.getWidth(), SafetyException.BlockReason.TEXTURE_OVERFLOW);
            ConfigKeys.MAX_TEX_SHEET_SIZE.checkFor(def.getPlayerObj(), block.getHeight(), SafetyException.BlockReason.TEXTURE_OVERFLOW);
        }
        block.doReadImage();
        this.texture = new DynamicTexture(block.getImage());
    }

    public TextureProvider(Image imgIn, Vec2i size) {
        this.size = size;
        this.texture = new DynamicTexture(imgIn);
    }

    public void write(IOHelper dout) throws IOException {
        dout.write2s(this.size);
        try (DataOutputStream baos = dout.writeNextBlock().getDout();){
            ImageIO.write(this.texture.getImage(), baos);
        }
    }

    public void bind() {
        if (this.texture == null) {
            return;
        }
        this.texture.bind();
    }

    public void free() {
        if (this.texture != null) {
            this.texture.free();
        }
    }

    public Vec2i getSize() {
        return this.size;
    }

    public Image getImage() {
        return this.texture == null ? null : this.texture.getImage();
    }

    public void setImage(Image image) {
        if (this.texture == null) {
            this.texture = new DynamicTexture(image);
        } else {
            this.texture.setImage(image);
        }
    }
}

