/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm;

import com.tom.cpl.config.ModConfigFile;
import com.tom.cpm.CommonBase;
import com.tom.cpm.MinecraftServerObject;
import com.tom.cpm.api.ICPMPlugin;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.common.PlatformCommon;
import com.tom.cpm.common.ServerHandler;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.PlatformFeature;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.util.IVersionCheck;
import com.tom.cpm.shared.util.VersionCheck;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.internal.versions.neoforge.NeoForgeVersion;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforgespi.language.IModInfo;

@Mod(value="cpm")
public class CustomPlayerModels
extends CommonBase {
    private static final EnumSet<PlatformFeature> features = EnumSet.of(PlatformFeature.EDITOR_HELD_ITEM, PlatformFeature.EDITOR_SUPPORTED);

    public CustomPlayerModels(IEventBus bus) {
        bus.addListener(this::doClientStuff);
        bus.addListener(this::setup);
        bus.addListener(this::processIMC);
        bus.addListener(this::onPayloadRegister);
        MinecraftObjectHolder.setCommonObject(this);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CustomPlayerModelsClient.INSTANCE.preInit(bus);
        }
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        CustomPlayerModelsClient.INSTANCE.init();
    }

    public void setup(FMLCommonSetupEvent evt) {
        this.cfg = new ModConfigFile(new File(FMLPaths.CONFIGDIR.get().toFile(), "cpm.json"));
        NeoForge.EVENT_BUS.register((Object)new ServerHandler());
        LOG.info("Customizable Player Models Initialized");
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(m -> {
            try {
                if (m.method().equals("api")) {
                    ICPMPlugin plugin = (ICPMPlugin)((Supplier)m.messageSupplier().get()).get();
                    api.register(plugin);
                }
            }
            catch (Throwable e) {
                LOG.error("Mod {} provides a broken implementation of CPM api", (Object)m.senderModId(), (Object)e);
            }
        });
        this.apiInit();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CustomPlayerModelsClient.apiInit();
        }
    }

    @SubscribeEvent
    public void onStart(ServerStartingEvent e) {
        MinecraftObjectHolder.setServerObject(new MinecraftServerObject(e.getServer()));
    }

    @SubscribeEvent
    public void onStop(ServerStoppingEvent e) {
        ModConfig.getWorldConfig().save();
        MinecraftObjectHolder.setServerObject(null);
    }

    private void onPayloadRegister(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1").optional().executesOn(HandlerThread.NETWORK);
        PlatformCommon.PacketRegistryP.register((arg_0, arg_1, arg_2) -> ((PayloadRegistrar)registrar).playToClient(arg_0, arg_1, arg_2), (arg_0, arg_1, arg_2) -> ((PayloadRegistrar)registrar).playToServer(arg_0, arg_1, arg_2), (arg_0, arg_1, arg_2, arg_3) -> ((PayloadRegistrar)registrar).playBidirectional(arg_0, arg_1, arg_2, arg_3));
    }

    @Override
    public EnumSet<PlatformFeature> getSupportedFeatures() {
        return features;
    }

    @Override
    public String getMCBrand() {
        return "(neoforge/" + NeoForgeVersion.getVersion() + ")";
    }

    @Override
    public String getModVersion() {
        return ModList.get().getModContainerById("cpm").map(m -> m.getModInfo().getVersion().toString()).orElse("?UNKNOWN?");
    }

    @Override
    public IVersionCheck getVersionCheck() {
        return VersionCheck.get(() -> ModList.get().getModContainerById("cpm").map(c -> VersionChecker.getResult((IModInfo)c.getModInfo()).changes()).orElse(Collections.emptyMap()));
    }
}

