/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.item.Stack;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpm.client.GLFWKeyCodes;
import com.tom.cpm.client.GuiGraphicsEx;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.Panel3dImpl;
import com.tom.cpm.client.TinyFDChooser;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.mixin.GuiAccessor;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.gui.panel.Panel3d;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.glfw.GLFW;

public class GuiImpl
extends Screen
implements IGui {
    protected static final KeyCodes CODES = new GLFWKeyCodes();
    protected static final NativeGuiComponents nativeComponents = new NativeGuiComponents();
    protected Frame gui;
    protected Screen parent;
    protected IGui.CtxStack stack;
    protected UIColors colors = new UIColors();
    protected Consumer<Runnable> closeListener;
    protected int keyModif;
    protected GuiGraphics graphics;
    protected int vanillaScale = -1;

    public GuiImpl(Function<IGui, Frame> creator, Screen parent) {
        super((Component)Component.literal((String)""));
        this.parent = parent;
        try {
            this.gui = creator.apply(this);
        }
        catch (Throwable e) {
            this.onGuiException("Error creating gui", e, true);
        }
    }

    private static <G extends Supplier<IGui>, N> NativeGuiComponents.NativeConstructor<G, N> local(Function<GuiImpl, N> fac) {
        return f -> fac.apply((GuiImpl)f.get());
    }

    public boolean isPauseScreen() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        String modVer;
        try {
            this.graphics = graphics;
            graphics.pose().pushMatrix();
            this.stack = new IGui.CtxStack(this.width, this.height);
            float pt = this.minecraft.getDeltaTracker().getRealtimeDeltaTicks();
            graphics.enableScissor(0, 0, this.width, this.height);
            this.gui.draw(mouseX, mouseY, pt);
            modVer = MinecraftCommonAccess.get().getModVersion();
        }
        catch (Throwable e) {
            String modVer2;
            try {
                this.onGuiException("Error drawing gui", e, true);
                modVer2 = MinecraftCommonAccess.get().getModVersion();
            }
            catch (Throwable throwable) {
                String modVer3 = MinecraftCommonAccess.get().getModVersion();
                Object s = "Minecraft " + SharedConstants.getCurrentVersion().name() + " (" + this.minecraft.getLaunchedVersion() + "/" + ClientBrandRetriever.getClientModName() + (String)("release".equalsIgnoreCase(this.minecraft.getVersionType()) ? "" : "/" + this.minecraft.getVersionType()) + ") " + modVer3;
                graphics.drawString(this.font, (String)s, this.width - this.font.width((String)s) - 4, 2, -16777216, false);
                s = this.minecraft.fpsString;
                graphics.drawString(this.font, (String)s, this.width - this.font.width((String)s) - 4, 11, -16777216, false);
                this.graphics = null;
                graphics.pose().popMatrix();
                throw throwable;
            }
            Object s = "Minecraft " + SharedConstants.getCurrentVersion().name() + " (" + this.minecraft.getLaunchedVersion() + "/" + ClientBrandRetriever.getClientModName() + (String)("release".equalsIgnoreCase(this.minecraft.getVersionType()) ? "" : "/" + this.minecraft.getVersionType()) + ") " + modVer2;
            graphics.drawString(this.font, (String)s, this.width - this.font.width((String)s) - 4, 2, -16777216, false);
            s = this.minecraft.fpsString;
            graphics.drawString(this.font, (String)s, this.width - this.font.width((String)s) - 4, 11, -16777216, false);
            this.graphics = null;
            graphics.pose().popMatrix();
        }
        Object s = "Minecraft " + SharedConstants.getCurrentVersion().name() + " (" + this.minecraft.getLaunchedVersion() + "/" + ClientBrandRetriever.getClientModName() + (String)("release".equalsIgnoreCase(this.minecraft.getVersionType()) ? "" : "/" + this.minecraft.getVersionType()) + ") " + modVer;
        graphics.drawString(this.font, (String)s, this.width - this.font.width((String)s) - 4, 2, -16777216, false);
        s = this.minecraft.fpsString;
        graphics.drawString(this.font, (String)s, this.width - this.font.width((String)s) - 4, 11, -16777216, false);
        this.graphics = null;
        graphics.pose().popMatrix();
        if (this.minecraft.player != null && this.gui.enableChat()) {
            ((GuiAccessor)this.minecraft.gui).callRenderChat(graphics, this.minecraft.getDeltaTracker());
        }
    }

    public void removed() {
        if (this.vanillaScale >= 0 && this.vanillaScale != (Integer)this.minecraft.options.guiScale().get()) {
            int v = this.vanillaScale;
            this.vanillaScale = -999;
            this.minecraft.options.guiScale().set((Object)v);
        }
    }

    public void onClose() {
        Screen p = this.parent;
        this.parent = null;
        this.minecraft.setScreen(p);
    }

    @Override
    public void drawBox(int x, int y, int w, int h, int color) {
        this.graphics.fill(x += this.getOffset().x, y += this.getOffset().y, x + w, y + h, color);
    }

    @Override
    public void drawBox(float xI, float yI, float w, float h, int color) {
        float x = xI + (float)this.getOffset().x;
        float y = yI + (float)this.getOffset().y;
        ((GuiGraphicsEx)this.graphics).cpm$fill(x, y, x + w, y + h, color);
    }

    protected void init() {
        try {
            this.gui.init(this.width, this.height);
        }
        catch (Throwable e) {
            this.onGuiException("Error in init gui", e, true);
        }
    }

    @Override
    public void drawText(int x, int y, String text, int color) {
        this.graphics.drawString(this.font, text, x += this.getOffset().x, y += this.getOffset().y, color | 0xFF000000, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(keyCode, scanCode, '\uffff', GLFW.glfwGetKeyName((int)keyCode, (int)scanCode));
            this.gui.keyPressed(evt);
            if (!evt.isConsumed() && this.minecraft.player != null && this.minecraft.options.keyChat.matches(keyCode, scanCode) && this.minecraft.options.chatVisibility().get() != ChatVisiblity.HIDDEN) {
                Minecraft.getInstance().schedule(() -> {
                    int scale = this.vanillaScale;
                    this.vanillaScale = -1;
                    this.minecraft.setScreen((Screen)new Overlay(scale));
                    this.vanillaScale = scale;
                });
                return true;
            }
            return true;
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean charTyped(char codePoint, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(-1, -1, codePoint, null);
            this.gui.keyPressed(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseClick(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseDrag(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseRelease(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xdelta, double ydelta) {
        if (ydelta != 0.0) {
            try {
                MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, (int)ydelta);
                this.gui.mouseWheel(evt);
                return evt.isConsumed();
            }
            catch (Throwable e) {
                this.onGuiException("Error processing mouse event", e, false);
                return true;
            }
        }
        return false;
    }

    public void onFilesDrop(List<Path> filesIn) {
        try {
            this.gui.filesDropped(filesIn.stream().map(Path::toFile).filter(File::exists).collect(Collectors.toList()));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    @Override
    public void displayError(String e) {
        Screen p = this.parent;
        this.parent = null;
        Minecraft.getInstance().setScreen((Screen)new CrashScreen(e, p));
    }

    @Override
    public void closeGui() {
        if (this.closeListener != null) {
            this.closeListener.accept(this::onClose);
        } else {
            this.onClose();
        }
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture) {
        this.graphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.tryBuild((String)"cpm", (String)("textures/gui/" + texture + ".png")), x += this.getOffset().x, y += this.getOffset().y, (float)u, (float)v, w, h, 256, 256);
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture, int color) {
        this.graphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.tryBuild((String)"cpm", (String)("textures/gui/" + texture + ".png")), x += this.getOffset().x, y += this.getOffset().y, (float)u, (float)v, w, h, 256, 256, color);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        this.graphics.blit(MinecraftObject.DynTexture.getBoundLoc(), x += this.getOffset().x, y += this.getOffset().y, x + width, y + height, u1, u2, v1, v2);
    }

    @Override
    public String i18nFormat(String key, Object ... obj) {
        return I18n.get((String)key, (Object[])obj);
    }

    @Override
    public void setupCut() {
        Box box = this.getContext().cutBox;
        this.graphics.disableScissor();
        this.graphics.enableScissor(box.x, box.y, box.x + box.w, box.y + box.h);
    }

    @Override
    public int textWidth(String text) {
        return this.font.width(text);
    }

    private TextField.ITextField createTextField() {
        return new TxtField();
    }

    @Override
    public UIColors getColors() {
        return this.colors;
    }

    @Override
    public void setCloseListener(Consumer<Runnable> listener) {
        this.closeListener = listener;
    }

    @Override
    public boolean isShiftDown() {
        return GuiImpl.hasShiftDown();
    }

    @Override
    public boolean isCtrlDown() {
        return GuiImpl.hasControlDown();
    }

    @Override
    public boolean isAltDown() {
        return GuiImpl.hasAltDown();
    }

    @Override
    public KeyCodes getKeyCodes() {
        return CODES;
    }

    @Override
    public void drawGradientBox(int xI, int yI, int w, int h, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        int x = xI + this.getOffset().x;
        int y = yI + this.getOffset().y;
        ((GuiGraphicsEx)this.graphics).cpm$fillGradient(x, y, x + w, y + h, topLeft, topRight, bottomLeft, bottomRight);
    }

    @Override
    public NativeGuiComponents getNative() {
        return nativeComponents;
    }

    @Override
    public void setClipboardText(String text) {
        this.minecraft.keyboardHandler.setClipboard(text);
    }

    @Override
    public Frame getFrame() {
        return this.gui;
    }

    @Override
    public String getClipboardText() {
        return this.minecraft.keyboardHandler.getClipboard();
    }

    @Override
    public void setScale(int value) {
        if (this.vanillaScale == -999) {
            return;
        }
        if (value != (Integer)this.minecraft.options.guiScale().get()) {
            if (this.vanillaScale == -1) {
                this.vanillaScale = (Integer)this.minecraft.options.guiScale().get();
            }
            if (value == -1) {
                if ((Integer)this.minecraft.options.guiScale().get() != this.vanillaScale) {
                    this.minecraft.options.guiScale().set((Object)this.vanillaScale);
                    this.vanillaScale = -1;
                }
            } else {
                this.minecraft.options.guiScale().set((Object)value);
            }
        }
    }

    @Override
    public int getScale() {
        return (Integer)this.minecraft.options.guiScale().get();
    }

    @Override
    public int getMaxScale() {
        return this.minecraft.getWindow().calculateScale(0, this.minecraft.isEnforceUnicode()) + 1;
    }

    @Override
    public IGui.CtxStack getStack() {
        return this.stack;
    }

    public void tick() {
        try {
            this.gui.tick();
        }
        catch (Throwable e) {
            this.onGuiException("Error in tick gui", e, true);
        }
    }

    @Override
    public void drawFormattedText(float x, float y, IText text, int color, float scale) {
        this.graphics.pose().pushMatrix();
        this.graphics.pose().translate(x += (float)this.getOffset().x, y += (float)this.getOffset().y);
        this.graphics.pose().scale(scale, scale);
        this.graphics.drawString(this.font, (Component)text.remap(), 0, 0, color | 0xFF000000, false);
        this.graphics.pose().popMatrix();
    }

    @Override
    public int textWidthFormatted(IText text) {
        return this.font.width(((Component)text.remap()).getVisualOrderText());
    }

    @Override
    public void openURL0(String url) {
        Util.getPlatform().openUri(url);
    }

    public GuiGraphics getMCGraphics() {
        return this.graphics;
    }

    public void added() {
        this.vanillaScale = -1;
    }

    @Override
    public void drawStack(int x, int y, Stack stack) {
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        this.graphics.renderItem(s, x += this.getOffset().x, y += this.getOffset().y);
        this.graphics.renderItemDecorations(this.font, s, x, y);
    }

    @Override
    public void drawStackTooltip(int mx, int my, Stack stack) {
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        this.graphics.setTooltipForNextFrame(this.font, s, mx, my);
    }

    public <I, S extends PictureInPictureRenderState> void drawPip(I instance, int w, int h, GuiGraphicsEx.StateFactory<I, S> sf) {
        int x = this.getOffset().x;
        int y = this.getOffset().y;
        ((GuiGraphicsEx)this.graphics).cpm$drawPip(instance, x, y, x + w, y + h, sf);
    }

    static {
        nativeComponents.register(TextField.class, GuiImpl.local(GuiImpl::createTextField));
        nativeComponents.register(FileChooserPopup.class, TinyFDChooser::new);
        nativeComponents.register(Panel3d.class, Panel3dImpl::new);
    }

    private static class CrashScreen
    extends Screen {
        private String error;
        private Screen parent;

        public CrashScreen(String error, Screen p) {
            super((Component)Component.literal((String)"Error"));
            this.error = error;
            this.parent = p;
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.render(graphics, mouseX, mouseY, partialTicks);
            String[] txt = I18n.get((String)"error.cpm.crash", (Object[])new Object[]{this.error}).split("\\\\");
            for (int i = 0; i < txt.length; ++i) {
                graphics.drawCenteredString(this.font, txt[i], this.width / 2, 15 + i * 10, -1);
            }
        }

        protected void init() {
            super.init();
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, p_213034_1_ -> this.minecraft.setScreen((Screen)null)).bounds(this.width / 2 - 100, 140, 200, 20).build());
        }

        public void onClose() {
            if (this.parent != null) {
                Screen p = this.parent;
                this.parent = null;
                this.minecraft.setScreen(p);
            }
        }
    }

    private class TxtField
    implements TextField.ITextField,
    Consumer<String> {
        private EditBox field;
        private Runnable eventListener;
        private Vec2i currentOff = new Vec2i(0, 0);
        private Box bounds = new Box(0, 0, 0, 0);
        private boolean settingText;
        private boolean updateField;
        private boolean enabled;

        public TxtField() {
            this.field = new EditBox(GuiImpl.this.font, 0, 0, 0, 0, (Component)Component.translatable((String)"narrator.cpm.field"));
            this.field.setMaxLength(0x100000);
            this.field.setBordered(false);
            this.field.setVisible(true);
            this.field.setTextColor(GuiImpl.this.colors.label_text_color);
            this.field.setResponder((Consumer)this);
            this.enabled = true;
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks, Box bounds) {
            Vec2i off = GuiImpl.this.getOffset();
            this.field.setX(bounds.x + off.x + 4);
            this.field.setY(bounds.y + off.y + 6);
            this.currentOff.x = off.x;
            this.currentOff.y = off.y;
            this.bounds.x = bounds.x;
            this.bounds.y = bounds.y;
            this.bounds.w = bounds.w;
            this.bounds.h = bounds.h;
            this.field.setWidth(bounds.w - 5);
            this.field.setHeight(bounds.h - 12);
            if (this.updateField) {
                this.settingText = true;
                this.field.moveCursorToEnd(false);
                this.settingText = false;
                this.updateField = false;
            }
            this.field.render(GuiImpl.this.graphics, mouseX, mouseY, partialTicks);
        }

        @Override
        public void keyPressed(KeyboardEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            if (evt.keyCode == -1) {
                if (this.field.charTyped(evt.charTyped, GuiImpl.this.keyModif)) {
                    evt.consume();
                }
            } else if (this.field.keyPressed(evt.keyCode, evt.scancode, GuiImpl.this.keyModif) || this.field.canConsumeInput()) {
                evt.consume();
            }
        }

        @Override
        public void mouseClick(MouseEvent evt) {
            if (evt.isConsumed() || !this.enabled) {
                this.field.setFocused(false);
                this.field.setHighlightPos(this.field.getCursorPosition());
                return;
            }
            this.field.setX(this.bounds.x + this.currentOff.x);
            this.field.setY(this.bounds.y + this.currentOff.y);
            this.field.setWidth(this.bounds.w);
            this.field.setHeight(this.bounds.h);
            if (this.field.mouseClicked((double)(evt.x + this.currentOff.x), (double)(evt.y + this.currentOff.y), evt.btn)) {
                this.field.setFocused(true);
                evt.consume();
            } else {
                this.field.setFocused(false);
                this.field.setHighlightPos(this.field.getCursorPosition());
            }
        }

        @Override
        public String getText() {
            return this.field.getValue();
        }

        @Override
        public void setText(String txt) {
            this.settingText = true;
            this.field.setValue(txt);
            this.settingText = false;
            this.updateField = true;
        }

        @Override
        public void setEventListener(Runnable eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public void accept(String value) {
            if (this.eventListener != null && !this.settingText && this.enabled) {
                this.eventListener.run();
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.field.setEditable(enabled);
            this.enabled = enabled;
        }

        @Override
        public boolean isFocused() {
            return this.field.isFocused();
        }

        @Override
        public void setFocused(boolean focused) {
            this.field.setFocused(focused);
        }

        @Override
        public int getCursorPos() {
            return this.field.getCursorPosition();
        }

        @Override
        public void setCursorPos(int pos) {
            this.field.setCursorPosition(pos);
        }

        @Override
        public void setSelectionPos(int pos) {
            this.field.setHighlightPos(pos);
        }

        @Override
        public int getSelectionPos() {
            return this.field.highlightPos;
        }
    }

    public class Overlay
    extends ChatScreen {
        private int vanillaScaleReset;

        public Overlay(int vanillaScaleReset) {
            super("");
            this.vanillaScaleReset = vanillaScaleReset;
        }

        public void render(GuiGraphics gr, int mouseX, int mouseY, float partialTicks) {
            GuiImpl.this.render(gr, Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            super.render(gr, mouseX, mouseY, partialTicks);
        }

        public void removed() {
            super.removed();
            this.minecraft.schedule(() -> {
                this.minecraft.setScreen((Screen)GuiImpl.this);
                GuiImpl.this.vanillaScale = this.vanillaScaleReset;
            });
        }
    }
}

