/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.DropDownBox;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.gui.gesture.GestureGuiButtons;
import com.tom.cpm.shared.gui.gesture.IGestureButtonContainer;
import com.tom.cpm.shared.parts.anim.menu.AbstractGestureButtonData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class PropertiesPopup
extends PopupPanel
implements IGestureButtonContainer {
    private ConfigEntry prop;
    private ConfigEntry current;
    private final ModelDefinition def;
    private List<Runnable> updateState;
    private List<Profile> ps;
    private DropDownBox<Profile> profileBox;
    private Profile createNew;

    public PropertiesPopup(IGui gui, int h, ModelDefinition def) {
        super(gui);
        Profile sel;
        this.def = def;
        this.updateState = new ArrayList<Runnable>();
        if (def.getAnimations().getProfileId() != null) {
            this.prop = ModConfig.getCommonConfig().getEntry("modelProperties").getEntry(def.getAnimations().getProfileId());
            this.ps = this.prop.getEntry("profiles").keySet().stream().map(x$0 -> new Profile((String)x$0)).collect(Collectors.toList());
            this.createNew = new Profile(false);
            this.ps.add(this.createNew);
            this.ps.add(new Profile(true));
            this.current = this.prop.getEntry("values");
            String s = this.prop.getString("selected", null);
            sel = s == null ? null : (Profile)this.ps.stream().filter(p -> s.equals(p.name)).findFirst().orElse(null);
        } else {
            this.ps = Collections.emptyList();
            sel = null;
        }
        this.profileBox = new DropDownBox<Profile>(gui.getFrame(), this.ps);
        this.profileBox.setBounds(new Box(5, 5, 160, 20));
        if (sel != null) {
            this.profileBox.setSelected(sel);
        }
        this.addElement(this.profileBox);
        Button save = new Button(gui, gui.i18nFormat("button.cpm.file.save", new Object[0]), () -> {
            Profile p = this.profileBox.getSelected();
            if (p != null) {
                if (p.name == null) {
                    new InputPopup(gui.getFrame(), gui.i18nFormat("label.cpm.name", new Object[0]), n -> {
                        if (this.prop.getEntry("profiles").hasEntry((String)n)) {
                            ConfirmPopup.confirm(gui.getFrame(), gui.i18nFormat("label.cpm.overwriteProfile", new Object[0]), () -> this.saveProfile((String)n));
                        } else {
                            Profile pr = new Profile((String)n);
                            this.saveProfile((String)n);
                            this.ps.add(pr);
                            this.profileBox.setSelected(pr);
                        }
                    }, null).run();
                } else {
                    ConfirmPopup.confirm(gui.getFrame(), gui.i18nFormat("label.cpm.overwriteProfile", new Object[0]), () -> this.saveProfile(p.name));
                }
            }
        });
        save.setBounds(new Box(5, 30, 50, 20));
        this.addElement(save);
        Button load = new Button(gui, gui.i18nFormat("button.cpm.file.load", new Object[0]), () -> {
            Profile p = this.profileBox.getSelected();
            if (p != null) {
                if (p.name != null) {
                    ConfirmPopup.confirm(gui.getFrame(), gui.i18nFormat("label.cpm.loadProfile", p.name), () -> this.loadProfile(p.name));
                } else if (p.reset) {
                    ConfirmPopup.confirm(gui.getFrame(), gui.i18nFormat("label.cpm.loadProfile", p.toString()), this::resetProfile);
                }
            }
        });
        load.setBounds(new Box(60, 30, 50, 20));
        this.addElement(load);
        Button del = new Button(gui, gui.i18nFormat("button.cpm.delete", new Object[0]), ConfirmPopup.confirmHandler(gui.getFrame(), gui.i18nFormat("label.cpm.confirmDel", new Object[0]), () -> {
            Profile p = this.profileBox.getSelected();
            if (p != null && p.name != null) {
                this.ps.remove(p);
                this.prop.getEntry("profiles").clearValue(p.name);
                this.profileBox.setSelected(null);
            }
        }));
        del.setBounds(new Box(115, 30, 50, 20));
        this.addElement(del);
        ScrollPanel scp = new ScrollPanel(gui);
        scp.setBounds(new Box(5, 55, 160, h - 60));
        this.addElement(scp);
        Panel panel = new Panel(gui);
        FlowLayout layout = new FlowLayout(panel, 5, 1);
        scp.setDisplay(panel);
        panel.setBounds(new Box(0, 0, 160, 0));
        def.getAnimations().getNamedActions().stream().filter(d -> d.isProperty() && d.canShow()).map(t -> GestureGuiButtons.make(this, t)).filter(e -> e != null).forEach(g -> {
            g.setBounds(new Box(5, 0, 150, 20));
            panel.addElement(g);
        });
        if (panel.getElements().isEmpty()) {
            panel.addElement(new Label(gui, gui.i18nFormat("label.cpm.nothing_here", new Object[0])).setBounds(new Box(5, 5, 100, 10)));
        } else {
            this.updateState.forEach(Runnable::run);
        }
        if (panel.getElements().isEmpty() || def.getAnimations().getProfileId() == null) {
            this.profileBox.setEnabled(false);
            save.setEnabled(false);
            load.setEnabled(false);
            del.setEnabled(false);
        }
        layout.reflow();
        this.setBounds(new Box(0, 0, 170, h));
    }

    private void saveProfile(String name) {
        ConfigEntry ce = this.prop.getEntry("profiles").getEntry(name);
        ce.clear();
        this.def.getAnimations().getNamedActions().stream().filter(AbstractGestureButtonData::isProperty).forEach(g -> g.storeTo(ce));
        this.prop.setString("selected", name);
        ModConfig.getCommonConfig().save();
    }

    private void resetProfile() {
        this.current.clear();
        this.prop.clearValue("selected");
        this.def.getAnimations().getNamedActions().stream().filter(AbstractGestureButtonData::isProperty).forEach(g -> g.loadFrom(this.current));
        ModConfig.getCommonConfig().save();
        this.updateState.forEach(Runnable::run);
    }

    private void loadProfile(String name) {
        ConfigEntry ce = this.prop.getEntry("profiles").getEntry(name);
        this.current.clear();
        this.prop.setString("selected", name);
        ModConfig.getCommonConfig().save();
        this.def.getAnimations().getNamedActions().stream().filter(AbstractGestureButtonData::isProperty).forEach(g -> g.loadFrom(ce));
        this.updateState.forEach(Runnable::run);
    }

    @Override
    public void onClosed() {
        this.def.getAnimations().getNamedActions().stream().filter(AbstractGestureButtonData::isProperty).forEach(g -> g.storeTo(this.current));
        ModConfig.getCommonConfig().save();
        super.onClosed();
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("button.cpm.modelProperties", new Object[0]);
    }

    @Override
    public IGui gui() {
        return this.gui;
    }

    @Override
    public void updateKeybind(String keybind, String id, boolean mode) {
    }

    @Override
    public IGestureButtonContainer.BoundKeyInfo getBoundKey(String id) {
        return null;
    }

    @Override
    public void valueChanged() {
        if (this.profileBox.getSelected() != null && this.profileBox.getSelected().reset) {
            this.profileBox.setSelected(this.createNew);
        }
    }

    @Override
    public boolean canBindKeys() {
        return false;
    }

    private class Profile
    implements Comparable<Profile> {
        private String name;
        private boolean reset;

        public Profile(boolean reset) {
            this.name = null;
            this.reset = reset;
        }

        public Profile(String name) {
            this.name = name;
            this.reset = false;
        }

        public String toString() {
            return this.name != null ? this.name : (this.reset ? PropertiesPopup.this.gui.i18nFormat("label.cpm.reset_profile", new Object[0]) : PropertiesPopup.this.gui.i18nFormat("label.cpm.new_profile", new Object[0]));
        }

        @Override
        public int compareTo(Profile o) {
            if (o.name == this.name) {
                return 0;
            }
            if (this.name == null && o.name != null) {
                return -1;
            }
            if (o.name == null && this.name != null) {
                return 1;
            }
            return this.name.compareTo(o.name);
        }
    }
}

