/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.Biome;
import com.tom.cpl.block.BiomeHandler;
import com.tom.cpm.MinecraftServerObject;
import com.tom.cpm.shared.MinecraftServerAccess;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class BiomeHandlerImpl
extends BiomeHandler<class_6880<class_1959>> {
    public static final BiomeHandlerImpl clientImpl = new BiomeHandlerImpl(() -> class_310.method_1551().field_1687.method_30349().method_30530(class_2378.field_25114));
    public static final BiomeHandlerImpl serverImpl = new BiomeHandlerImpl(() -> ((MinecraftServerObject)MinecraftServerAccess.get()).getServer().method_30611().method_30530(class_2378.field_25114));
    private final Supplier<class_2378<class_1959>> registry;

    public static BiomeHandlerImpl getImpl(class_1937 level) {
        return level.field_9236 ? clientImpl : serverImpl;
    }

    public BiomeHandlerImpl(Supplier<class_2378<class_1959>> registry) {
        this.registry = registry;
    }

    @Override
    public List<Biome> listNativeEntries(String tag) {
        class_2960 rl = class_2960.method_12829((String)tag);
        if (rl == null) {
            return Collections.emptyList();
        }
        class_6880 b = this.registry.get().method_40264(class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)rl)).orElse(null);
        if (b != null) {
            return Collections.singletonList(this.wrap(b));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> listNativeTags() {
        return this.registry.get().method_40273().map(k -> k.comp_327().toString()).toList();
    }

    @Override
    public Biome emptyObject() {
        return this.wrap(null);
    }

    @Override
    public boolean isInTag(String tag, class_6880<class_1959> state) {
        if (tag.charAt(0) == '#') {
            class_2960 rl = class_2960.method_12829((String)tag.substring(1));
            if (rl != null) {
                class_6862 i = class_6862.method_40092((class_5321)class_2378.field_25114, (class_2960)rl);
                return state.method_40220(i);
            }
        } else {
            return this.getBiomeId(state).equals(tag);
        }
        return false;
    }

    @Override
    public List<String> listTags(class_6880<class_1959> state) {
        return state.method_40228().map(k -> "#" + k.comp_327()).toList();
    }

    @Override
    public List<Biome> getAllElements() {
        return StreamSupport.stream(this.registry.get().method_40295().spliterator(), false).map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public boolean equals(class_6880<class_1959> a, class_6880<class_1959> b) {
        return a == b;
    }

    @Override
    public String getBiomeId(class_6880<class_1959> state) {
        return this.registry.get().method_10221((Object)((class_1959)state.comp_349())).toString();
    }

    @Override
    public float getTemperature(class_6880<class_1959> state) {
        return ((class_1959)state.comp_349()).method_8712();
    }

    @Override
    public float getHumidity(class_6880<class_1959> state) {
        return ((class_1959)state.comp_349()).method_8715();
    }

    @Override
    public BiomeHandler.RainType getRainType(class_6880<class_1959> state) {
        return BiomeHandler.RainType.get(((class_1959)state.comp_349()).method_8694().name());
    }

    @Override
    public boolean isAvailable() {
        try {
            return this.registry.get() != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

