/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.mixinplugin.IrisDetector;
import com.tom.cpm.mixinplugin.OFDetector;
import com.tom.cpm.mixinplugin.VRDetector;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.RenderManager;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.Log;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.ElytraModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class ClientBase {
    public static final ResourceLocation DEFAULT_CAPE = new ResourceLocation("cpm:textures/template/cape.png");
    public static boolean optifineLoaded;
    public static boolean vrLoaded;
    public static boolean irisLoaded;
    public static MinecraftObject mc;
    public Minecraft minecraft;
    public RenderManager<GameProfile, PlayerEntity, Model, IRenderTypeBuffer> manager;
    public NetHandler<ResourceLocation, PlayerEntity, ClientPlayNetHandler> netHandler;

    public void init0() {
        this.minecraft = Minecraft.func_71410_x();
        mc = new MinecraftObject(this.minecraft);
        optifineLoaded = OFDetector.doApply();
        vrLoaded = VRDetector.doApply();
        irisLoaded = IrisDetector.doApply();
        if (optifineLoaded) {
            Log.info("Optifine detected, enabling optifine compatibility");
        }
        if (vrLoaded) {
            Log.info("ViveCraft detected, enabling ViveCraft compatibility");
        }
        if (irisLoaded) {
            Log.info("Iris detected, enabling iris compatibility");
        }
    }

    public void init1() {
        this.manager = new RenderManager<GameProfile, PlayerEntity, Model, IRenderTypeBuffer>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), PlayerProfile::getPlayerProfile);
        this.manager.setGPGetters(GameProfile::getProperties, Property::getValue);
        this.netHandler = new NetHandler(ResourceLocation::new);
        this.netHandler.setExecutor(() -> this.minecraft);
        this.netHandler.setSendPacketClient(d -> new PacketBuffer(Unpooled.wrappedBuffer((byte[])d)), (c, rl, pb) -> c.func_147297_a((IPacket)new CCustomPayloadPacket(rl, pb)));
        this.netHandler.setPlayerToLoader(PlayerEntity::func_146103_bH);
        this.netHandler.setGetPlayerById(id -> {
            Entity ent = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
            if (ent instanceof PlayerEntity) {
                return (PlayerEntity)ent;
            }
            return null;
        });
        this.netHandler.setGetClient(() -> this.minecraft.field_71439_g);
        this.netHandler.setGetNet(c -> ((ClientPlayerEntity)c).field_71174_a);
        this.netHandler.setDisplayText(f -> this.minecraft.field_71439_g.func_146105_b((ITextComponent)f.remap(), false));
        this.netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
    }

    public static void apiInit() {
        CustomPlayerModels.api.buildClient().voicePlayer(PlayerEntity.class, Entity::func_110124_au).renderApi(Model.class, ResourceLocation.class, RenderType.class, IRenderTypeBuffer.class, GameProfile.class, ModelTexture::new).localModelApi(GameProfile::new).init();
    }

    public void playerRenderPre(PlayerEntity player, IRenderTypeBuffer buffer, PlayerModel model) {
        this.manager.bindPlayer(player, buffer, (Model)model);
    }

    public void playerRenderPost(IRenderTypeBuffer buffer, PlayerModel model) {
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            ((IRenderTypeBuffer.Impl)buffer).func_228461_a_();
        }
        this.manager.unbindClear((Model)model);
    }

    public void renderHand(IRenderTypeBuffer buffer, PlayerModel model) {
        this.manager.bindHand((PlayerEntity)Minecraft.func_71410_x().field_71439_g, buffer, (Model)model);
    }

    public void renderHandPost(IRenderTypeBuffer buffer, BipedModel model) {
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            ((IRenderTypeBuffer.Impl)buffer).func_228461_a_();
        }
        this.manager.unbindClear((Model)model);
    }

    public void renderSkull(Model skullModel, GameProfile profile, IRenderTypeBuffer buffer) {
        this.manager.bindSkull(profile, buffer, skullModel);
    }

    public void renderSkullPost(IRenderTypeBuffer buffer, Model model) {
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            ((IRenderTypeBuffer.Impl)buffer).func_228461_a_();
        }
        this.manager.unbindFlush(model);
    }

    public void renderElytra(BipedModel<LivingEntity> player, ElytraModel<LivingEntity> model) {
        this.manager.bindElytra((Model)player, (Model)model);
    }

    public void renderArmor(BipedModel<LivingEntity> modelArmor, BipedModel<LivingEntity> modelLeggings, BipedModel<LivingEntity> player) {
        this.manager.bindArmor((Model)player, (Model)modelArmor, 1);
        this.manager.bindArmor((Model)player, (Model)modelLeggings, 2);
    }

    public void updateJump() {
        if (this.minecraft.field_71439_g.func_233570_aj_() && this.minecraft.field_71439_g.field_71158_b.field_78901_c) {
            this.manager.jump((PlayerEntity)this.minecraft.field_71439_g);
        }
    }

    public static void renderCape(MatrixStack matrixStackIn, IVertexBuilder buffer, int packedLightIn, AbstractClientPlayerEntity playerIn, float partialTicks, PlayerModel<AbstractClientPlayerEntity> model, ModelDefinition modelDefinition) {
        float f3;
        float f2;
        float f1;
        matrixStackIn.func_227860_a_();
        if (playerIn != null) {
            double d0 = MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_71091_bM, (double)playerIn.field_71094_bP) - MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_70169_q, (double)playerIn.func_226277_ct_());
            double d1 = MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_71096_bN, (double)playerIn.field_71095_bQ) - MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_70167_r, (double)playerIn.func_226278_cu_());
            double d2 = MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_71097_bO, (double)playerIn.field_71085_bR) - MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_70166_s, (double)playerIn.func_226281_cx_());
            float f = playerIn.field_70760_ar + (playerIn.field_70761_aq - playerIn.field_70760_ar);
            double d3 = MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
            double d4 = -MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
            f1 = (float)d1 * 10.0f;
            f1 = MathHelper.func_76131_a((float)f1, (float)-6.0f, (float)32.0f);
            f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)150.0f);
            f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = MathHelper.func_76131_a((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = MathHelper.func_219799_g((float)partialTicks, (float)playerIn.field_71107_bF, (float)playerIn.field_71109_bG);
            f1 += MathHelper.func_76126_a((float)(MathHelper.func_219799_g((float)partialTicks, (float)playerIn.field_70141_P, (float)playerIn.field_70140_Q) * 6.0f)) * 32.0f * f4;
            if (playerIn.func_213453_ef()) {
                f1 += 25.0f;
            }
            if (playerIn.func_184582_a(EquipmentSlotType.CHEST).func_190926_b()) {
                if (playerIn.func_213453_ef()) {
                    model.field_178729_w.field_78798_e = 1.775f;
                    model.field_178729_w.field_78797_d = 2.35f;
                } else {
                    model.field_178729_w.field_78798_e = 2.0f;
                    model.field_178729_w.field_78797_d = 0.0f;
                }
            } else if (playerIn.func_213453_ef()) {
                model.field_178729_w.field_78798_e = 2.3f;
                model.field_178729_w.field_78797_d = 1.1f;
            } else {
                model.field_178729_w.field_78798_e = 2.9f;
                model.field_178729_w.field_78797_d = 0.14999998f;
            }
        } else {
            f1 = 0.0f;
            f2 = 0.0f;
            f3 = 0.0f;
        }
        model.field_178729_w.field_78795_f = (float)(-Math.toRadians(6.0f + f2 / 2.0f + f1));
        model.field_178729_w.field_78796_g = (float)Math.toRadians(180.0f - f3 / 2.0f);
        model.field_178729_w.field_78808_h = (float)Math.toRadians(f3 / 2.0f);
        mc.getPlayerRenderManager().setModelPose(model);
        model.field_178729_w.field_78795_f = 0.0f;
        model.field_178729_w.field_78796_g = 0.0f;
        model.field_178729_w.field_78808_h = 0.0f;
        model.func_228289_b_(matrixStackIn, buffer, packedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
    }

    public <E extends Entity> void renderNameTag(PlayerNameTagRenderer<E> r, E entityIn, GameProfile gprofile, String unique, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        FormatText st;
        double d0 = r.cpm$entityRenderDispatcher().func_229099_b_(entityIn);
        if (d0 < 1024.0 && (st = this.manager.getStatus(gprofile, unique)) != null) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)1.3f, 0.0);
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
            r.cpm$renderNameTag(entityIn, (ITextComponent)st.remap(), matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.func_227865_b_();
        }
    }

    public static interface PlayerNameTagRenderer<E extends Entity> {
        public void cpm$renderNameTag(E var1, ITextComponent var2, MatrixStack var3, IRenderTypeBuffer var4, int var5);

        public EntityRendererManager cpm$entityRenderDispatcher();
    }
}

