/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.item.Stack;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpm.client.GLFWKeyCodes;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.Panel3dImpl;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.TinyFDChooser;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.gui.panel.Panel3d;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.glfw.GLFW;

public class GuiBase
extends Screen
implements IGui {
    protected static final KeyCodes CODES = new GLFWKeyCodes();
    protected static final NativeGuiComponents nativeComponents = new NativeGuiComponents();
    protected Frame gui;
    protected Screen parent;
    protected IGui.CtxStack stack;
    protected UIColors colors = new UIColors();
    protected Consumer<Runnable> closeListener;
    protected int keyModif;
    protected MatrixStack matrixStack;
    protected boolean noScissorTest;
    protected int vanillaScale = -1;

    public GuiBase(Function<IGui, Frame> creator, Screen parent) {
        super((ITextComponent)new StringTextComponent(""));
        this.parent = parent;
        try {
            this.gui = creator.apply(this);
        }
        catch (Throwable e) {
            this.onGuiException("Error creating gui", e, true);
        }
        this.noScissorTest = this.isCtrlDown();
    }

    private static <G extends Supplier<IGui>, N> NativeGuiComponents.NativeConstructor<G, N> local(Function<GuiBase, N> fac) {
        return f -> fac.apply((GuiBase)f.get());
    }

    public boolean func_231177_au__() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        block8: {
            this.func_238651_a_(matrixStack, 0);
            try {
                this.matrixStack = matrixStack;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, 800.0);
                this.stack = new IGui.CtxStack(this.field_230708_k_, this.field_230709_l_);
                RenderSystem.runAsFancy(() -> this.gui.draw(mouseX, mouseY, partialTicks));
                if (this.noScissorTest) break block8;
            }
            catch (Throwable e) {
                block9: {
                    try {
                        this.onGuiException("Error drawing gui", e, true);
                        if (this.noScissorTest) break block9;
                    }
                    catch (Throwable throwable) {
                        if (!this.noScissorTest) {
                            RenderSystem.disableScissor();
                        }
                        String modVer = MinecraftCommonAccess.get().getModVersion();
                        String s = "Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.field_230706_i_.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.field_230706_i_.func_184123_d()) ? "" : "/" + this.field_230706_i_.func_184123_d()) + ") " + modVer;
                        this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(this.field_230708_k_ - this.field_230712_o_.func_78256_a(s) - 4), 2.0f, -16777216);
                        s = this.field_230706_i_.field_71426_K;
                        if (this.noScissorTest) {
                            s = s + " No Scissor";
                        }
                        this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(this.field_230708_k_ - this.field_230712_o_.func_78256_a(s) - 4), 11.0f, -16777216);
                        this.matrixStack = null;
                        matrixStack.func_227865_b_();
                        throw throwable;
                    }
                    RenderSystem.disableScissor();
                }
                String modVer = MinecraftCommonAccess.get().getModVersion();
                String s = "Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.field_230706_i_.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.field_230706_i_.func_184123_d()) ? "" : "/" + this.field_230706_i_.func_184123_d()) + ") " + modVer;
                this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(this.field_230708_k_ - this.field_230712_o_.func_78256_a(s) - 4), 2.0f, -16777216);
                s = this.field_230706_i_.field_71426_K;
                if (this.noScissorTest) {
                    s = s + " No Scissor";
                }
                this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(this.field_230708_k_ - this.field_230712_o_.func_78256_a(s) - 4), 11.0f, -16777216);
                this.matrixStack = null;
                matrixStack.func_227865_b_();
            }
            RenderSystem.disableScissor();
        }
        String modVer = MinecraftCommonAccess.get().getModVersion();
        String s = "Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.field_230706_i_.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.field_230706_i_.func_184123_d()) ? "" : "/" + this.field_230706_i_.func_184123_d()) + ") " + modVer;
        this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(this.field_230708_k_ - this.field_230712_o_.func_78256_a(s) - 4), 2.0f, -16777216);
        s = this.field_230706_i_.field_71426_K;
        if (this.noScissorTest) {
            s = s + " No Scissor";
        }
        this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(this.field_230708_k_ - this.field_230712_o_.func_78256_a(s) - 4), 11.0f, -16777216);
        this.matrixStack = null;
        matrixStack.func_227865_b_();
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        if (this.vanillaScale >= 0 && this.vanillaScale != this.field_230706_i_.field_71474_y.field_74335_Z) {
            this.field_230706_i_.field_71474_y.field_74335_Z = this.vanillaScale;
            this.vanillaScale = -999;
            this.field_230706_i_.func_213226_a();
        }
    }

    public void func_231175_as__() {
        Screen p = this.parent;
        this.parent = null;
        this.field_230706_i_.func_147108_a(p);
    }

    @Override
    public void drawBox(int x, int y, int w, int h, int color) {
        GuiBase.func_238467_a_((MatrixStack)this.matrixStack, (int)(x += this.getOffset().x), (int)(y += this.getOffset().y), (int)(x + w), (int)(y + h), (int)color);
    }

    @Override
    public void drawBox(float x, float y, float w, float h, int color) {
        float minX = x += (float)this.getOffset().x;
        float minY = y += (float)this.getOffset().y;
        float maxX = x + w;
        float maxY = y + h;
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        Matrix4f matrix = this.matrixStack.func_227866_c_().func_227870_a_();
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_227888_a_(matrix, minX, maxY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, maxX, maxY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, maxX, minY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, minX, minY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        try {
            this.gui.init(this.field_230708_k_, this.field_230709_l_);
        }
        catch (Throwable e) {
            this.onGuiException("Error in init gui", e, true);
        }
    }

    @Override
    public void drawText(int x, int y, String text, int color) {
        this.matrixStack.func_227860_a_();
        this.matrixStack.func_227861_a_(0.0, 0.0, 50.0);
        this.field_230712_o_.func_238421_b_(this.matrixStack, text, (float)(x += this.getOffset().x), (float)(y += this.getOffset().y), color);
        this.matrixStack.func_227865_b_();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(keyCode, scanCode, '\uffff', GLFW.glfwGetKeyName((int)keyCode, (int)scanCode));
            this.gui.keyPressed(evt);
            if (!evt.isConsumed() && this.gui.enableChat() && this.gui.enableChat() && this.field_230706_i_.field_71439_g != null && this.field_230706_i_.field_71474_y.field_74310_D.func_197976_a(keyCode, scanCode) && this.field_230706_i_.field_71474_y.field_74343_n != ChatVisibility.HIDDEN) {
                RenderSystem.recordRenderCall(() -> {
                    int scale = this.vanillaScale;
                    this.vanillaScale = -1;
                    this.field_230706_i_.func_147108_a((Screen)new Overlay());
                    this.vanillaScale = scale;
                });
                return true;
            }
            return true;
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(-1, -1, codePoint, null);
            this.gui.keyPressed(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseClick(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseDrag(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseRelease(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            try {
                MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, (int)delta);
                this.gui.mouseWheel(evt);
                return evt.isConsumed();
            }
            catch (Throwable e) {
                this.onGuiException("Error processing mouse event", e, false);
                return true;
            }
        }
        return false;
    }

    public void func_230476_a_(List<Path> filesIn) {
        try {
            this.gui.filesDropped(filesIn.stream().map(Path::toFile).filter(File::exists).collect(Collectors.toList()));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    @Override
    public void displayError(String e) {
        Screen p = this.parent;
        this.parent = null;
        Minecraft.func_71410_x().func_147108_a((Screen)new CrashScreen(e, p));
    }

    @Override
    public void closeGui() {
        if (this.closeListener != null) {
            this.closeListener.accept(this::func_231175_as__);
        } else {
            this.func_231175_as__();
        }
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture) {
        this.field_230706_i_.func_110434_K().func_110577_a(new ResourceLocation("cpm", "textures/gui/" + texture + ".png"));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.func_238474_b_(this.matrixStack, x += this.getOffset().x, y += this.getOffset().y, u, v, w, h);
        RenderSystem.disableBlend();
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture, int color) {
        this.field_230706_i_.func_110434_K().func_110577_a(new ResourceLocation("cpm", "textures/gui/" + texture + ".png"));
        x += this.getOffset().x;
        y += this.getOffset().y;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.func_238474_b_(this.matrixStack, x, y, u, v, w, h);
        RenderSystem.disableBlend();
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(MinecraftObject.DynTexture.getBoundLoc());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float bo = this.func_230927_p_();
        Matrix4f matrix = this.matrixStack.func_227866_c_().func_227870_a_();
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)(y + height), bo).func_225583_a_(u1, v2).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)(x + width), (float)(y + height), bo).func_225583_a_(u2, v2).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)(x + width), (float)y, bo).func_225583_a_(u2, v1).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)y, bo).func_225583_a_(u1, v1).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableBlend();
    }

    @Override
    public String i18nFormat(String key, Object ... obj) {
        return I18n.func_135052_a((String)key, (Object[])obj);
    }

    @Override
    public void setupCut() {
        if (!this.noScissorTest) {
            int dw = this.field_230706_i_.func_228018_at_().func_198109_k();
            int dh = this.field_230706_i_.func_228018_at_().func_198091_l();
            float multiplierX = (float)dw / (float)this.field_230708_k_;
            float multiplierY = (float)dh / (float)this.field_230709_l_;
            Box box = this.getContext().cutBox;
            RenderSystem.enableScissor((int)((int)((float)box.x * multiplierX)), (int)(dh - (int)((float)(box.y + box.h) * multiplierY)), (int)((int)((float)box.w * multiplierX)), (int)((int)((float)box.h * multiplierY)));
        }
    }

    @Override
    public int textWidth(String text) {
        return this.field_230712_o_.func_78256_a(text);
    }

    private TextField.ITextField createTextField() {
        return new TxtField();
    }

    @Override
    public UIColors getColors() {
        return this.colors;
    }

    @Override
    public void setCloseListener(Consumer<Runnable> listener) {
        this.closeListener = listener;
    }

    @Override
    public boolean isShiftDown() {
        return GuiBase.func_231173_s_();
    }

    @Override
    public boolean isCtrlDown() {
        return GuiBase.func_231172_r_();
    }

    @Override
    public boolean isAltDown() {
        return GuiBase.func_231174_t_();
    }

    @Override
    public KeyCodes getKeyCodes() {
        return CODES;
    }

    @Override
    public void drawGradientBox(int x, int y, int w, int h, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        int left = x += this.getOffset().x;
        int top = y += this.getOffset().y;
        int right = x + w;
        int bottom = y + h;
        float atr = (float)(topRight >> 24 & 0xFF) / 255.0f;
        float rtr = (float)(topRight >> 16 & 0xFF) / 255.0f;
        float gtr = (float)(topRight >> 8 & 0xFF) / 255.0f;
        float btr = (float)(topRight & 0xFF) / 255.0f;
        float atl = (float)(topLeft >> 24 & 0xFF) / 255.0f;
        float rtl = (float)(topLeft >> 16 & 0xFF) / 255.0f;
        float gtl = (float)(topLeft >> 8 & 0xFF) / 255.0f;
        float btl = (float)(topLeft & 0xFF) / 255.0f;
        float abl = (float)(bottomLeft >> 24 & 0xFF) / 255.0f;
        float rbl = (float)(bottomLeft >> 16 & 0xFF) / 255.0f;
        float gbl = (float)(bottomLeft >> 8 & 0xFF) / 255.0f;
        float bbl = (float)(bottomLeft & 0xFF) / 255.0f;
        float abr = (float)(bottomRight >> 24 & 0xFF) / 255.0f;
        float rbr = (float)(bottomRight >> 16 & 0xFF) / 255.0f;
        float gbr = (float)(bottomRight >> 8 & 0xFF) / 255.0f;
        float bbr = (float)(bottomRight & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Matrix4f mat = this.matrixStack.func_227866_c_().func_227870_a_();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_227888_a_(mat, (float)right, (float)top, (float)this.func_230927_p_()).func_227885_a_(rtr, gtr, btr, atr).func_181675_d();
        bufferbuilder.func_227888_a_(mat, (float)left, (float)top, (float)this.func_230927_p_()).func_227885_a_(rtl, gtl, btl, atl).func_181675_d();
        bufferbuilder.func_227888_a_(mat, (float)left, (float)bottom, (float)this.func_230927_p_()).func_227885_a_(rbl, gbl, bbl, abl).func_181675_d();
        bufferbuilder.func_227888_a_(mat, (float)right, (float)bottom, (float)this.func_230927_p_()).func_227885_a_(rbr, gbr, bbr, abr).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    @Override
    public NativeGuiComponents getNative() {
        return nativeComponents;
    }

    @Override
    public void setClipboardText(String text) {
        this.field_230706_i_.field_195559_v.func_197960_a(text);
    }

    @Override
    public Frame getFrame() {
        return this.gui;
    }

    @Override
    public String getClipboardText() {
        return this.field_230706_i_.field_195559_v.func_197965_a();
    }

    @Override
    public void setScale(int value) {
        if (this.vanillaScale == -999) {
            return;
        }
        if (value != this.field_230706_i_.field_71474_y.field_74335_Z) {
            if (this.vanillaScale == -1) {
                this.vanillaScale = this.field_230706_i_.field_71474_y.field_74335_Z;
            }
            if (value == -1) {
                if (this.field_230706_i_.field_71474_y.field_74335_Z != this.vanillaScale) {
                    this.field_230706_i_.field_71474_y.field_74335_Z = this.vanillaScale;
                    this.vanillaScale = -1;
                    this.field_230706_i_.func_213226_a();
                }
            } else {
                this.field_230706_i_.field_71474_y.field_74335_Z = value;
                this.field_230706_i_.func_213226_a();
            }
        }
    }

    @Override
    public int getScale() {
        return this.field_230706_i_.field_71474_y.field_74335_Z;
    }

    @Override
    public int getMaxScale() {
        return this.field_230706_i_.func_228018_at_().func_216521_a(0, this.field_230706_i_.func_211821_e()) + 1;
    }

    @Override
    public IGui.CtxStack getStack() {
        return this.stack;
    }

    public void func_231023_e_() {
        try {
            this.gui.tick();
        }
        catch (Throwable e) {
            this.onGuiException("Error in tick gui", e, true);
        }
    }

    @Override
    public void drawFormattedText(float x, float y, IText text, int color, float scale) {
        this.matrixStack.func_227860_a_();
        this.matrixStack.func_227861_a_((double)(x += (float)this.getOffset().x), (double)(y += (float)this.getOffset().y), 50.0);
        this.matrixStack.func_227862_a_(scale, scale, scale);
        this.field_230712_o_.func_243248_b(this.matrixStack, (ITextComponent)text.remap(), 0.0f, 0.0f, color);
        this.matrixStack.func_227865_b_();
    }

    @Override
    public int textWidthFormatted(IText text) {
        return this.field_230712_o_.func_243245_a(((ITextComponent)text.remap()).func_241878_f());
    }

    @Override
    public void openURL0(String url) {
        Util.func_110647_a().func_195640_a(url);
    }

    public void onOpened() {
        this.vanillaScale = -1;
    }

    @Override
    public void drawStack(int x, int y, Stack stack) {
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        this.field_230707_j_.field_77023_b = 600.0f;
        this.field_230707_j_.func_184391_a((LivingEntity)this.field_230706_i_.field_71439_g, s, x += this.getOffset().x, y += this.getOffset().y);
        this.field_230707_j_.func_180453_a(this.field_230712_o_, s, x, y, null);
        this.field_230707_j_.field_77023_b = 0.0f;
    }

    @Override
    public void drawStackTooltip(int mx, int my, Stack stack) {
        this.matrixStack.func_227860_a_();
        this.matrixStack.func_227861_a_(0.0, 0.0, -300.0);
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        this.func_230457_a_(this.matrixStack, s, mx, my);
        this.matrixStack.func_227865_b_();
        RenderSystem.disableRescaleNormal();
    }

    static {
        nativeComponents.register(TextField.class, GuiBase.local(GuiBase::createTextField));
        nativeComponents.register(FileChooserPopup.class, TinyFDChooser::new);
        nativeComponents.register(Panel3d.class, Panel3dImpl::new);
    }

    public class Overlay
    extends ChatScreen {
        public Overlay() {
            super("");
        }

        public void func_230430_a_(MatrixStack st, int mouseX, int mouseY, float partialTicks) {
            st.func_227860_a_();
            st.func_227861_a_(0.0, 0.0, -100.0);
            GuiBase.this.func_230430_a_(st, Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            st.func_227865_b_();
            st.func_227860_a_();
            st.func_227861_a_(0.0, 0.0, 900.0);
            super.func_230430_a_(st, mouseX, mouseY, partialTicks);
            st.func_227865_b_();
        }

        public Screen getGui() {
            return GuiBase.this;
        }
    }

    private class TxtField
    implements TextField.ITextField,
    Consumer<String> {
        private TextFieldWidget field;
        private Runnable eventListener;
        private Vec2i currentOff = new Vec2i(0, 0);
        private Box bounds = new Box(0, 0, 0, 0);
        private boolean settingText;
        private boolean updateField;
        private boolean enabled;

        public TxtField() {
            this.field = new TextFieldWidget(GuiBase.this.field_230712_o_, 0, 0, 0, 0, (ITextComponent)new TranslationTextComponent("narrator.cpm.field"));
            this.field.func_146203_f(0x100000);
            this.field.func_146185_a(false);
            this.field.func_146189_e(true);
            this.field.func_146193_g(GuiBase.this.colors.label_text_color);
            this.field.func_212954_a((Consumer)this);
            this.enabled = true;
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks, Box bounds) {
            Vec2i off = GuiBase.this.getOffset();
            this.field.field_230690_l_ = bounds.x + off.x + 4;
            this.field.field_230691_m_ = bounds.y + off.y + 6;
            this.currentOff.x = off.x;
            this.currentOff.y = off.y;
            this.bounds.x = bounds.x;
            this.bounds.y = bounds.y;
            this.bounds.w = bounds.w;
            this.bounds.h = bounds.h;
            this.field.func_230991_b_(bounds.w - 5);
            Platform.setHeight((Widget)this.field, bounds.h - 12);
            if (this.updateField) {
                this.settingText = true;
                this.field.func_146202_e();
                this.settingText = false;
                this.updateField = false;
            }
            this.field.func_230430_a_(GuiBase.this.matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void keyPressed(KeyboardEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            if (evt.keyCode == -1) {
                if (this.field.func_231042_a_(evt.charTyped, GuiBase.this.keyModif)) {
                    evt.consume();
                }
            } else if (this.field.func_231046_a_(evt.keyCode, evt.scancode, GuiBase.this.keyModif) || this.field.func_212955_f()) {
                evt.consume();
            }
        }

        @Override
        public void mouseClick(MouseEvent evt) {
            if (evt.isConsumed()) {
                this.field.func_231044_a_(-2.147483648E9, -2.147483648E9, evt.btn);
                return;
            }
            this.field.field_230690_l_ = this.bounds.x + this.currentOff.x;
            this.field.field_230691_m_ = this.bounds.y + this.currentOff.y;
            this.field.func_230991_b_(this.bounds.w);
            Platform.setHeight((Widget)this.field, this.bounds.h);
            if (this.field.func_231044_a_((double)(evt.x + this.currentOff.x), (double)(evt.y + this.currentOff.y), evt.btn)) {
                evt.consume();
            }
        }

        @Override
        public String getText() {
            return this.field.func_146179_b();
        }

        @Override
        public void setText(String txt) {
            this.settingText = true;
            this.field.func_146180_a(txt);
            this.settingText = false;
            this.updateField = true;
        }

        @Override
        public void setEventListener(Runnable eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public void accept(String value) {
            if (this.eventListener != null && !this.settingText && this.enabled) {
                this.eventListener.run();
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.field.func_146184_c(enabled);
            this.enabled = enabled;
        }

        @Override
        public boolean isFocused() {
            return this.field.func_230999_j_();
        }

        @Override
        public void setFocused(boolean focused) {
            this.field.func_146195_b(focused);
        }

        @Override
        public int getCursorPos() {
            return this.field.func_146198_h();
        }

        @Override
        public void setCursorPos(int pos) {
            this.field.func_212422_f(pos);
        }

        @Override
        public void setSelectionPos(int pos) {
            this.field.func_146199_i(pos);
        }

        @Override
        public int getSelectionPos() {
            return this.field.field_146223_s;
        }
    }

    private static class CrashScreen
    extends Screen {
        private String error;
        private Screen parent;

        public CrashScreen(String error, Screen p) {
            super((ITextComponent)new StringTextComponent("Error"));
            this.error = error;
            this.parent = p;
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.func_230446_a_(matrixStack);
            String[] txt = IGui.wordWrap(I18n.func_135052_a((String)"error.cpm.crash", (Object[])new Object[]{this.error}), this.field_230708_k_ - 200, arg_0 -> ((FontRenderer)this.field_230712_o_).func_78256_a(arg_0)).split("\\\\");
            for (int i = 0; i < txt.length; ++i) {
                CrashScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)txt[i], (int)(this.field_230708_k_ / 2), (int)(15 + i * 10), (int)0xFFFFFF);
            }
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        protected void func_231160_c_() {
            super.func_231160_c_();
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, 140, 200, 20, DialogTexts.field_240637_h_, p_213034_1_ -> this.field_230706_i_.func_147108_a((Screen)null)));
        }

        public void func_231175_as__() {
            if (this.parent != null) {
                Screen p = this.parent;
                this.parent = null;
                this.field_230706_i_.func_147108_a(p);
            }
        }
    }
}

