/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpm.common.PlatformCommon;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.ScalingOptions;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.ServerPlayerEntity;

public class AttributeScaler
implements NetHandler.ScalerInterface<ServerPlayerEntity, List<Attribute>> {
    private static final UUID CPM_ATTR_UUID = UUID.fromString("24bba381-9615-4530-8fcf-4fc42393a4b5");

    @Override
    public void setScale(List<Attribute> key, ServerPlayerEntity player, float value) {
        key.forEach(a -> {
            ModifiableAttributeInstance ai = player.func_233645_dx_().func_233779_a_(a);
            if (ai != null) {
                ai.func_188479_b(CPM_ATTR_UUID);
                if (Math.abs(value - 1.0f) > 0.01f) {
                    ai.func_233767_b_(new AttributeModifier(CPM_ATTR_UUID, "cpm", (double)(value - 1.0f), AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
        });
    }

    @Override
    public List<Attribute> toKey(ScalingOptions opt) {
        switch (opt) {
            case HEALTH: {
                return Collections.singletonList(Attributes.field_233818_a_);
            }
            case ATTACK_DMG: {
                return Collections.singletonList(Attributes.field_233823_f_);
            }
            case ATTACK_KNOCKBACK: {
                return Collections.singletonList(Attributes.field_233824_g_);
            }
            case ATTACK_SPEED: {
                return Collections.singletonList(Attributes.field_233825_h_);
            }
            case DEFENSE: {
                return Collections.singletonList(Attributes.field_233826_i_);
            }
            case MOB_VISIBILITY: {
                return Collections.singletonList(Attributes.field_233819_b_);
            }
            case MOTION: {
                return Collections.singletonList(Attributes.field_233821_d_);
            }
            case KNOCKBACK_RESIST: {
                return Collections.singletonList(Attributes.field_233820_c_);
            }
            case REACH: {
                return PlatformCommon.getReachAttr();
            }
        }
        return null;
    }

    @Override
    public String getMethodName() {
        return "attribute";
    }
}

