/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.Biome;
import com.tom.cpl.block.BiomeHandler;
import com.tom.cpm.MinecraftServerObject;
import com.tom.cpm.shared.MinecraftServerAccess;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class BiomeHandlerImpl
extends BiomeHandler<net.minecraft.world.biome.Biome> {
    public static final BiomeHandlerImpl clientImpl = new BiomeHandlerImpl(() -> Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_));
    public static final BiomeHandlerImpl serverImpl = new BiomeHandlerImpl(() -> ((MinecraftServerObject)MinecraftServerAccess.get()).getServer().func_244267_aX().func_243612_b(Registry.field_239720_u_));
    private final Supplier<Registry<net.minecraft.world.biome.Biome>> registry;

    public static BiomeHandlerImpl getImpl(World level) {
        return level.field_72995_K ? clientImpl : serverImpl;
    }

    public BiomeHandlerImpl(Supplier<Registry<net.minecraft.world.biome.Biome>> registry) {
        this.registry = registry;
    }

    @Override
    public List<Biome> listNativeEntries(String tag) {
        ResourceLocation rl = ResourceLocation.func_208304_a((String)tag);
        net.minecraft.world.biome.Biome b = (net.minecraft.world.biome.Biome)this.registry.get().func_82594_a(rl);
        if (b != null) {
            return Collections.singletonList(this.wrap(b));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> listNativeTags() {
        return Collections.emptyList();
    }

    @Override
    public Biome emptyObject() {
        return this.wrap(null);
    }

    @Override
    public boolean isInTag(String tag, net.minecraft.world.biome.Biome state) {
        return this.getBiomeId(state).equals(tag);
    }

    @Override
    public List<String> listTags(net.minecraft.world.biome.Biome state) {
        return Collections.emptyList();
    }

    @Override
    public List<Biome> getAllElements() {
        return this.registry.get().func_201756_e().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public boolean equals(net.minecraft.world.biome.Biome a, net.minecraft.world.biome.Biome b) {
        return a == b;
    }

    @Override
    public String getBiomeId(net.minecraft.world.biome.Biome state) {
        return this.registry.get().func_177774_c((Object)state).toString();
    }

    @Override
    public float getTemperature(net.minecraft.world.biome.Biome state) {
        return state.func_242445_k();
    }

    @Override
    public float getHumidity(net.minecraft.world.biome.Biome state) {
        return state.func_76727_i();
    }

    @Override
    public BiomeHandler.RainType getRainType(net.minecraft.world.biome.Biome state) {
        return BiomeHandler.RainType.get(state.func_201851_b().name());
    }

    @Override
    public boolean isAvailable() {
        try {
            return this.registry.get() != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

