/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.item.ItemStackHandler;
import com.tom.cpl.item.NbtMapper;
import com.tom.cpl.item.Stack;
import com.tom.cpl.nbt.NBTTagCompound;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ItemStackHandlerImpl
extends ItemStackHandler<ItemStack> {
    public static final ItemStackHandlerImpl impl = new ItemStackHandlerImpl();
    public static final NBT nbt = new NBT();

    @Override
    public int getCount(ItemStack stack) {
        return stack.func_190916_E();
    }

    @Override
    public int getMaxCount(ItemStack stack) {
        return stack.func_77976_d();
    }

    @Override
    public int getDamage(ItemStack stack) {
        return stack.func_77952_i();
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return stack.func_77958_k();
    }

    @Override
    public boolean itemEquals(ItemStack a, ItemStack b) {
        return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b);
    }

    @Override
    public boolean itemEqualsFull(ItemStack a, ItemStack b) {
        return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    @Override
    public List<String> listNativeTags() {
        return ItemTags.func_199903_a().func_199908_a().stream().map(e -> "#" + e).collect(Collectors.toList());
    }

    @Override
    public List<Stack> getAllElements() {
        NonNullList stacks = NonNullList.func_191196_a();
        Registry.field_212630_s.func_239659_c_().forEach(e -> ((Item)e.getValue()).func_150895_a(ItemGroup.field_78027_g, stacks));
        return stacks.stream().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public NBTTagCompound getTag(ItemStack stack) {
        return stack.func_77942_o() ? nbt.wrap(stack.func_77978_p()) : null;
    }

    @Override
    public List<Stack> listNativeEntries(String tag) {
        ArrayList<Stack> stacks = new ArrayList<Stack>();
        if (tag.charAt(0) == '#') {
            ITag t;
            ResourceLocation rl = ResourceLocation.func_208304_a((String)tag.substring(1));
            if (rl != null && (t = ItemTags.func_199903_a().func_199910_a(rl)) != null) {
                t.func_230236_b_().stream().map(i -> this.wrap(new ItemStack((IItemProvider)i))).forEach(stacks::add);
            }
        } else {
            ResourceLocation rl = ResourceLocation.func_208304_a((String)tag);
            Item item = (Item)Registry.field_212630_s.func_82594_a(rl);
            if (item != null) {
                stacks.add(this.wrap(new ItemStack((IItemProvider)item)));
            }
        }
        return stacks;
    }

    @Override
    public boolean isInTag(String tag, ItemStack stack) {
        if (tag.charAt(0) == '#') {
            ITag t;
            ResourceLocation rl = ResourceLocation.func_208304_a((String)tag.substring(1));
            if (rl != null && (t = ItemTags.func_199903_a().func_199910_a(rl)) != null) {
                return t.func_230235_a_((Object)stack.func_77973_b());
            }
        } else {
            return this.getItemId(stack).equals(tag);
        }
        return false;
    }

    @Override
    public List<String> listTags(ItemStack stack) {
        return ItemTags.func_199903_a().func_199913_a((Object)stack.func_77973_b()).stream().map(e -> "#" + e).collect(Collectors.toList());
    }

    @Override
    public String getItemId(ItemStack stack) {
        return Registry.field_212630_s.func_177774_c((Object)stack.func_77973_b()).toString();
    }

    @Override
    public Stack emptyObject() {
        return this.wrap(ItemStack.field_190927_a);
    }

    @Override
    public String getItemDisplayName(ItemStack stack) {
        return stack.func_151000_E().getString();
    }

    public static class NBT
    extends NbtMapper<INBT, CompoundNBT, ListNBT, NumberNBT> {
        @Override
        public long getLong(NumberNBT t) {
            return t.func_150291_c();
        }

        @Override
        public int getInt(NumberNBT t) {
            return t.func_150287_d();
        }

        @Override
        public short getShort(NumberNBT t) {
            return t.func_150289_e();
        }

        @Override
        public byte getByte(NumberNBT t) {
            return t.func_150290_f();
        }

        @Override
        public double getDouble(NumberNBT t) {
            return t.func_150286_g();
        }

        @Override
        public float getFloat(NumberNBT t) {
            return t.func_150288_h();
        }

        @Override
        public NumberNBT asNumber(INBT t) {
            return t instanceof NumberNBT ? (NumberNBT)t : null;
        }

        @Override
        public String getString(INBT t) {
            return t.func_150285_a_();
        }

        @Override
        public INBT getTag(CompoundNBT t, String name) {
            return t.func_74781_a(name);
        }

        @Override
        public ListNBT asList(INBT t) {
            return t instanceof ListNBT ? (ListNBT)t : null;
        }

        @Override
        public CompoundNBT asCompound(INBT t) {
            return t instanceof CompoundNBT ? (CompoundNBT)t : null;
        }

        @Override
        public int listSize(ListNBT t) {
            return t.size();
        }

        @Override
        public INBT getAt(ListNBT t, int i) {
            return t.get(i);
        }

        @Override
        public boolean contains(CompoundNBT t, String name, int type) {
            return t.func_150297_b(name, type);
        }

        @Override
        public CompoundNBT newCompound() {
            return new CompoundNBT();
        }

        @Override
        public ListNBT newList() {
            return new ListNBT();
        }

        @Override
        public Iterable<String> keys(CompoundNBT t) {
            return t.func_150296_c();
        }

        @Override
        public int getId(INBT t) {
            return t.func_74732_a();
        }

        @Override
        public byte[] getByteArray(INBT t) {
            return t instanceof ByteArrayNBT ? ((ByteArrayNBT)t).func_150292_c() : new byte[]{};
        }

        @Override
        public int[] getIntArray(INBT t) {
            return t instanceof IntArrayNBT ? ((IntArrayNBT)t).func_150302_c() : new int[]{};
        }

        @Override
        public long[] getLongArray(INBT t) {
            return t instanceof LongArrayNBT ? ((LongArrayNBT)t).func_197652_h() : new long[]{};
        }
    }
}

