/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.externals.com.udojava.evalex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Expression {
    protected String expression = null;
    protected List<String> rpn = null;
    protected Map<String, Operator> operators = new HashMap<String, Operator>();
    protected static final Map<String, Operator> builtinOperators;
    protected Map<String, Function> functions = new HashMap<String, Function>();
    protected static final Map<String, Function> builtinFunctions;
    protected Map<String, Float> variables = new HashMap<String, Float>();
    private final char decimalSeparator = (char)46;
    private final char minusSign = (char)45;

    public Expression(String expression) {
        this.expression = expression;
        this.operators.putAll(builtinOperators);
        this.functions.putAll(builtinFunctions);
        this.variables.put("PI", Float.valueOf((float)Math.PI));
        this.variables.put("TRUE", Float.valueOf(1.0f));
        this.variables.put("FALSE", Float.valueOf(0.0f));
    }

    public static boolean isTrue(float v) {
        return v >= 0.5f;
    }

    public static boolean epsEqual(float v1, float v2) {
        return Math.abs(v1 - v2) < 0.01f;
    }

    private boolean isNumber(String st) {
        if (st.charAt(0) == '-' && st.length() == 1) {
            return false;
        }
        for (char ch : st.toCharArray()) {
            if (Character.isDigit(ch) || ch == '-' || ch == '.') continue;
            return false;
        }
        return true;
    }

    private List<String> shuntingYard(String expression) throws ExpressionException {
        ArrayList<String> outputQueue = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        Tokenizer tokenizer = new Tokenizer(expression);
        String lastFunction = null;
        String previousToken = null;
        while (tokenizer.hasNext()) {
            String token = tokenizer.next();
            if (this.isNumber(token)) {
                outputQueue.add(token);
            } else if (this.variables.containsKey(token)) {
                outputQueue.add(token);
            } else if (this.functions.containsKey(token.toUpperCase())) {
                stack.push(token);
                lastFunction = token;
            } else if (Character.isLetter(token.charAt(0))) {
                stack.push(token);
            } else if (",".equals(token)) {
                while (!stack.isEmpty() && !"(".equals(stack.peek())) {
                    outputQueue.add((String)stack.pop());
                }
                if (stack.isEmpty()) {
                    throw new ExpressionException("Parse error for function '" + lastFunction + "'");
                }
            } else if (this.operators.containsKey(token)) {
                String token2;
                Operator o1 = this.operators.get(token);
                String string = token2 = stack.isEmpty() ? null : (String)stack.peek();
                while (this.operators.containsKey(token2) && (o1.isLeftAssoc() && o1.getPrecedence() <= this.operators.get(token2).getPrecedence() || o1.getPrecedence() < this.operators.get(token2).getPrecedence())) {
                    outputQueue.add((String)stack.pop());
                    token2 = stack.isEmpty() ? null : (String)stack.peek();
                }
                stack.push(token);
            } else if ("(".equals(token)) {
                if (previousToken != null && this.isNumber(previousToken)) {
                    throw new ExpressionException("Missing operator at character position " + tokenizer.getPos());
                }
                stack.push(token);
            } else if (")".equals(token)) {
                while (!stack.isEmpty() && !"(".equals(stack.peek())) {
                    outputQueue.add((String)stack.pop());
                }
                if (stack.isEmpty()) {
                    throw new ExpressionException("Mismatched parentheses");
                }
                stack.pop();
                if (!stack.isEmpty() && this.functions.containsKey(((String)stack.peek()).toUpperCase())) {
                    outputQueue.add((String)stack.pop());
                }
            }
            previousToken = token;
        }
        while (!stack.isEmpty()) {
            String element = (String)stack.pop();
            if ("(".equals(element) || ")".equals(element)) {
                throw new ExpressionException("Mismatched parentheses");
            }
            if (!this.operators.containsKey(element)) {
                throw new ExpressionException("Unknown operator or function: " + element);
            }
            outputQueue.add(element);
        }
        return outputQueue;
    }

    public float eval() throws ExpressionException {
        Stack<Float> stack = new Stack<Float>();
        for (String token : this.getRPN()) {
            if (this.operators.containsKey(token)) {
                float v1 = ((Float)stack.pop()).floatValue();
                float v2 = ((Float)stack.pop()).floatValue();
                stack.push(Float.valueOf(this.operators.get(token).eval(v2, v1)));
                continue;
            }
            if (this.variables.containsKey(token)) {
                stack.push(this.variables.get(token));
                continue;
            }
            if (this.functions.containsKey(token.toUpperCase())) {
                Function f = this.functions.get(token.toUpperCase());
                ArrayList<Float> p = new ArrayList<Float>();
                for (int i = 0; i < f.numParams; ++i) {
                    p.add(0, (Float)stack.pop());
                }
                float fResult = f.eval(p);
                stack.push(Float.valueOf(fResult));
                continue;
            }
            try {
                stack.push(Float.valueOf(Float.parseFloat(token)));
            }
            catch (NumberFormatException e) {
                throw new ExpressionException(e.getMessage());
            }
        }
        return ((Float)stack.pop()).floatValue();
    }

    public Operator addOperator(Operator operator) {
        return this.operators.put(operator.getOper(), operator);
    }

    private static void addOperator0(Map<String, Operator> operators, Operator operator) {
        operators.put(operator.getOper(), operator);
    }

    public Function addFunction(Function function) {
        return this.functions.put(function.getName(), function);
    }

    private static void addFunction0(Map<String, Function> functions, Function function) {
        functions.put(function.getName(), function);
    }

    public Expression setVariable(String variable, float value) {
        this.variables.put(variable, Float.valueOf(value));
        return this;
    }

    public Expression setVariable(String variable, String value) {
        if (this.isNumber(value)) {
            this.variables.put(variable, Float.valueOf(Float.parseFloat(value)));
        } else {
            this.expression = this.expression.replaceAll("\\b" + variable + "\\b", "(" + value + ")");
            this.rpn = null;
        }
        return this;
    }

    public Expression with(String variable, float value) {
        return this.setVariable(variable, value);
    }

    public Expression and(String variable, String value) {
        return this.setVariable(variable, value);
    }

    public Expression and(String variable, float value) {
        return this.setVariable(variable, value);
    }

    public Expression with(String variable, String value) {
        return this.setVariable(variable, value);
    }

    public Iterator<String> getExpressionTokenizer() {
        return new Tokenizer(this.expression);
    }

    protected List<String> getRPN() throws ExpressionException {
        if (this.rpn == null) {
            this.rpn = this.shuntingYard(this.expression);
        }
        return this.rpn;
    }

    public String toRPN() {
        String result = new String();
        for (String st : this.getRPN()) {
            result = result.isEmpty() ? result : result + " ";
            result = result + st;
        }
        return result;
    }

    static {
        HashMap<String, Operator> operators = new HashMap<String, Operator>();
        HashMap<String, Function> functions = new HashMap<String, Function>();
        Expression.addOperator0(operators, new Operator("+", 20, true){

            @Override
            public float eval(float v1, float v2) {
                return v1 + v2;
            }
        });
        Expression.addOperator0(operators, new Operator("-", 20, true){

            @Override
            public float eval(float v1, float v2) {
                return v1 - v2;
            }
        });
        Expression.addOperator0(operators, new Operator("*", 30, true){

            @Override
            public float eval(float v1, float v2) {
                return v1 * v2;
            }
        });
        Expression.addOperator0(operators, new Operator("/", 30, true){

            @Override
            public float eval(float v1, float v2) {
                return v1 / v2;
            }
        });
        Expression.addOperator0(operators, new Operator("%", 30, true){

            @Override
            public float eval(float v1, float v2) {
                return v1 % v2;
            }
        });
        Expression.addOperator0(operators, new Operator("^", 40, false){

            @Override
            public float eval(float v1, float v2) {
                return (float)Math.pow(v1, v2);
            }
        });
        Expression.addOperator0(operators, new Operator("&&", 4, false){

            @Override
            public float eval(float v1, float v2) {
                boolean b1 = Expression.isTrue(v1);
                boolean b2 = Expression.isTrue(v2);
                return b1 && b2 ? 1.0f : 0.0f;
            }
        });
        Expression.addOperator0(operators, new Operator("||", 2, false){

            @Override
            public float eval(float v1, float v2) {
                boolean b1 = Expression.isTrue(v1);
                boolean b2 = Expression.isTrue(v2);
                return b1 || b2 ? 1.0f : 0.0f;
            }
        });
        Expression.addOperator0(operators, new Operator(">", 10, false){

            @Override
            public float eval(float v1, float v2) {
                return v1 > v2 ? 1.0f : 0.0f;
            }
        });
        Expression.addOperator0(operators, new Operator(">=", 10, false){

            @Override
            public float eval(float v1, float v2) {
                return v1 >= v2 ? 1.0f : 0.0f;
            }
        });
        Expression.addOperator0(operators, new Operator("<", 10, false){

            @Override
            public float eval(float v1, float v2) {
                return v1 < v2 ? 1.0f : 0.0f;
            }
        });
        Expression.addOperator0(operators, new Operator("<=", 10, false){

            @Override
            public float eval(float v1, float v2) {
                return v1 <= v2 ? 1.0f : 0.0f;
            }
        });
        Expression.addOperator0(operators, new Operator("=", 7, false){

            @Override
            public float eval(float v1, float v2) {
                return Expression.epsEqual(v1, v2) ? 1.0f : 0.0f;
            }
        });
        Expression.addOperator0(operators, new Operator("==", 7, false){

            @Override
            public float eval(float v1, float v2) {
                return Expression.epsEqual(v1, v2) ? 1.0f : 0.0f;
            }
        });
        Expression.addOperator0(operators, new Operator("!=", 7, false){

            @Override
            public float eval(float v1, float v2) {
                return !Expression.epsEqual(v1, v2) ? 1.0f : 0.0f;
            }
        });
        Expression.addOperator0(operators, new Operator("<>", 7, false){

            @Override
            public float eval(float v1, float v2) {
                return !Expression.epsEqual(v1, v2) ? 1.0f : 0.0f;
            }
        });
        Expression.addFunction0(functions, new Function("NOT", 1){

            @Override
            public float eval(List<Float> parameters) {
                boolean zero = !Expression.isTrue(parameters.get(0).floatValue());
                return zero ? 1.0f : 0.0f;
            }
        });
        Expression.addFunction0(functions, new Function("BOOL", 1){

            @Override
            public float eval(List<Float> parameters) {
                boolean zero = !Expression.isTrue(parameters.get(0).floatValue());
                return zero ? 0.0f : 1.0f;
            }
        });
        Expression.addFunction0(functions, new Function("IF", 3){

            @Override
            public float eval(List<Float> parameters) {
                boolean isTrue = Expression.isTrue(parameters.get(0).floatValue());
                return isTrue ? parameters.get(1).floatValue() : parameters.get(2).floatValue();
            }
        });
        Expression.addFunction0(functions, new Function("RANDOM", 0){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.random();
            }

            @Override
            public boolean isConstFunction() {
                return false;
            }
        });
        Expression.addFunction0(functions, new Function("SIN", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.sin(Math.toRadians(parameters.get(0).floatValue()));
            }
        });
        Expression.addFunction0(functions, new Function("COS", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.cos(Math.toRadians(parameters.get(0).floatValue()));
            }
        });
        Expression.addFunction0(functions, new Function("TAN", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.tan(Math.toRadians(parameters.get(0).floatValue()));
            }
        });
        Expression.addFunction0(functions, new Function("SINH", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.sinh(parameters.get(0).floatValue());
            }
        });
        Expression.addFunction0(functions, new Function("COSH", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.cosh(parameters.get(0).floatValue());
            }
        });
        Expression.addFunction0(functions, new Function("TANH", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.tanh(parameters.get(0).floatValue());
            }
        });
        Expression.addFunction0(functions, new Function("RAD", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.toRadians(parameters.get(0).floatValue());
            }
        });
        Expression.addFunction0(functions, new Function("DEG", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.toDegrees(parameters.get(0).floatValue());
            }
        });
        Expression.addFunction0(functions, new Function("MAX", 2){

            @Override
            public float eval(List<Float> parameters) {
                float v2;
                float v1 = parameters.get(0).floatValue();
                return v1 > (v2 = parameters.get(1).floatValue()) ? v1 : v2;
            }
        });
        Expression.addFunction0(functions, new Function("MIN", 2){

            @Override
            public float eval(List<Float> parameters) {
                float v2;
                float v1 = parameters.get(0).floatValue();
                return v1 < (v2 = parameters.get(1).floatValue()) ? v1 : v2;
            }
        });
        Expression.addFunction0(functions, new Function("ABS", 1){

            @Override
            public float eval(List<Float> parameters) {
                return Math.abs(parameters.get(0).floatValue());
            }
        });
        Expression.addFunction0(functions, new Function("LOG", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.log(parameters.get(0).floatValue());
            }
        });
        Expression.addFunction0(functions, new Function("LOG10", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.log10(parameters.get(0).floatValue());
            }
        });
        Expression.addFunction0(functions, new Function("ROUND", 2){

            @Override
            public float eval(List<Float> parameters) {
                float toRound = parameters.get(0).floatValue();
                int precision = parameters.get(1).intValue();
                double d = Math.pow(10.0, precision);
                return (float)((double)((int)((double)toRound * d)) / d);
            }
        });
        Expression.addFunction0(functions, new Function("FLOOR", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.floor(parameters.get(0).floatValue());
            }
        });
        Expression.addFunction0(functions, new Function("CEILING", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.ceil(parameters.get(0).floatValue());
            }
        });
        Expression.addFunction0(functions, new Function("SQRT", 1){

            @Override
            public float eval(List<Float> parameters) {
                return (float)Math.sqrt(parameters.get(0).floatValue());
            }
        });
        builtinOperators = Collections.unmodifiableMap(operators);
        builtinFunctions = Collections.unmodifiableMap(functions);
    }

    private class Tokenizer
    implements Iterator<String> {
        private int pos = 0;
        private String input;
        private String previousToken;

        public Tokenizer(String input) {
            this.input = input.trim();
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.input.length();
        }

        private char peekNextChar() {
            if (this.pos < this.input.length() - 1) {
                return this.input.charAt(this.pos + 1);
            }
            return '\u0000';
        }

        @Override
        public String next() {
            StringBuilder token = new StringBuilder();
            if (this.pos >= this.input.length()) {
                this.previousToken = null;
                return null;
            }
            char ch = this.input.charAt(this.pos);
            while (Character.isWhitespace(ch) && this.pos < this.input.length()) {
                ch = this.input.charAt(++this.pos);
            }
            if (Character.isDigit(ch) || ch == '.' && Character.isDigit(this.peekNextChar())) {
                while ((Character.isDigit(ch) || ch == '.') && this.pos < this.input.length()) {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
            } else if (ch == '-' && (Character.isDigit(this.peekNextChar()) || this.peekNextChar() == '.' && this.pos < this.input.length() - 2 && Character.isDigit(this.input.charAt(this.pos + 2))) && ("(".equals(this.previousToken) || ",".equals(this.previousToken) || this.previousToken == null || Expression.this.operators.containsKey(this.previousToken))) {
                token.append('-');
                ++this.pos;
                token.append(this.next());
            } else if (Character.isLetter(ch) || ch == '_') {
                while ((Character.isLetter(ch) || Character.isDigit(ch) || ch == '_') && this.pos < this.input.length()) {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
            } else if (ch == '(' || ch == ')' || ch == ',') {
                token.append(ch);
                ++this.pos;
            } else {
                while (!(Character.isLetter(ch) || Character.isDigit(ch) || ch == '_' || Character.isWhitespace(ch) || ch == '(' || ch == ')' || ch == ',' || this.pos >= this.input.length())) {
                    token.append(this.input.charAt(this.pos));
                    ++this.pos;
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                    if (ch != '-') continue;
                }
                if (!Expression.this.operators.containsKey(token.toString())) {
                    throw new ExpressionException("Unknown operator '" + token + "' at position " + (this.pos - token.length() + 1));
                }
            }
            this.previousToken = token.toString();
            return this.previousToken;
        }

        @Override
        public void remove() {
            throw new ExpressionException("remove() not supported");
        }

        public int getPos() {
            return this.pos;
        }
    }

    public static abstract class Operator {
        private String oper;
        private int precedence;
        private boolean leftAssoc;

        public Operator(String oper, int precedence, boolean leftAssoc) {
            this.oper = oper;
            this.precedence = precedence;
            this.leftAssoc = leftAssoc;
        }

        public String getOper() {
            return this.oper;
        }

        public int getPrecedence() {
            return this.precedence;
        }

        public boolean isLeftAssoc() {
            return this.leftAssoc;
        }

        public abstract float eval(float var1, float var2);
    }

    public static abstract class Function {
        private String name;
        private int numParams;

        public Function(String name, int numParams) {
            this.name = name.toUpperCase();
            this.numParams = numParams;
        }

        public String getName() {
            return this.name;
        }

        public int getNumParams() {
            return this.numParams;
        }

        public abstract float eval(List<Float> var1);

        public boolean isConstFunction() {
            return true;
        }
    }

    public class ExpressionException
    extends RuntimeException {
        private static final long serialVersionUID = 1118142866870779047L;

        public ExpressionException(String message) {
            super(message);
        }
    }
}

