/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project;

import com.tom.cpl.util.ThrowingBiConsumer;
import com.tom.cpl.util.ThrowingRunnable;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.JsonMapImpl;
import com.tom.cpm.shared.editor.project.ProjectFile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface ProjectWriter {
    public <T> T queueSave(String var1, Supplier<T> var2, ThrowingBiConsumer<T, OutputStream, IOException> var3);

    default public JsonMap getJson(String path) {
        return this.queueSave(path, JsonMapImpl::new, (data, out) -> {
            try (OutputStreamWriter os = new OutputStreamWriter((OutputStream)out);){
                MinecraftObjectHolder.gson.toJson(data.asMap(), (Appendable)os);
            }
        });
    }

    public void clearFolder(String var1);

    public void delete(String var1);

    public <T> void putFile(String var1, T var2, ThrowingBiConsumer<T, OutputStream, IOException> var3);

    public void flush() throws IOException;

    public static class Impl
    implements ProjectWriter {
        private final ProjectFile project;
        private Map<String, Data<?>> files = new HashMap();
        private List<ThrowingRunnable<IOException>> saveActions = new ArrayList<ThrowingRunnable<IOException>>();

        public Impl(ProjectFile project) {
            this.project = project;
        }

        @Override
        public <T> T queueSave(String path, Supplier<T> creator, ThrowingBiConsumer<T, OutputStream, IOException> save) {
            return this.files.computeIfAbsent(path, k -> new Data(creator.get(), save)).get();
        }

        @Override
        public <T> void putFile(String path, T val, ThrowingBiConsumer<T, OutputStream, IOException> save) {
            this.files.put(path, new Data<T>(val, save));
        }

        @Override
        public void flush() throws IOException {
            for (ThrowingRunnable<IOException> throwingRunnable : this.saveActions) {
                throwingRunnable.run();
            }
            for (Map.Entry entry : this.files.entrySet()) {
                OutputStream os = this.project.setAsStream((String)entry.getKey());
                Throwable throwable = null;
                try {
                    ((Data)entry.getValue()).save(os);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (os == null) continue;
                    if (throwable != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    os.close();
                }
            }
        }

        @Override
        public void clearFolder(String path) {
            this.saveActions.add(() -> this.project.clearFolder(path));
        }

        @Override
        public void delete(String path) {
            this.saveActions.add(() -> this.project.delete(path));
        }

        private static class Data<T> {
            private final T value;
            private final ThrowingBiConsumer<T, OutputStream, IOException> save;

            public Data(T value, ThrowingBiConsumer<T, OutputStream, IOException> save) {
                this.value = value;
                this.save = save;
            }

            public void save(OutputStream os) throws IOException {
                this.save.accept(this.value, os);
            }

            public T get() {
                return this.value;
            }
        }
    }
}

