/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project.loaders;

import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.project.IProject;
import com.tom.cpm.shared.editor.project.JsonList;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.ProjectPartLoader;
import com.tom.cpm.shared.editor.project.ProjectWriter;
import com.tom.cpm.shared.editor.tags.EditorTagManager;
import java.io.IOException;

public class TagsLoaderV1
implements ProjectPartLoader {
    @Override
    public String getId() {
        return "tags";
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void load(Editor editor, IProject project) throws IOException {
        this.readTags(project, (EditorTagManager)editor.tags.getItemTags(), "items");
        this.readTags(project, (EditorTagManager)editor.tags.getBlockTags(), "blocks");
        this.readTags(project, (EditorTagManager)editor.tags.getEntityTags(), "entities");
        this.readTags(project, (EditorTagManager)editor.tags.getBiomeTags(), "biomes");
    }

    @Override
    public void save(Editor editor, ProjectWriter project) throws IOException {
        this.writeTags(project, (EditorTagManager)editor.tags.getItemTags(), "items");
        this.writeTags(project, (EditorTagManager)editor.tags.getBlockTags(), "blocks");
        this.writeTags(project, (EditorTagManager)editor.tags.getEntityTags(), "entities");
        this.writeTags(project, (EditorTagManager)editor.tags.getBiomeTags(), "biomes");
    }

    protected <T> void readTags(IProject project, EditorTagManager<T> mngr, String name) throws IOException {
        project.jsonIfExists("tags/" + name + ".json", data -> {
            JsonList list = data.getList("tags");
            list.forEachMap(d -> {
                String id = d.getString("id");
                if (id == null) {
                    return;
                }
                if ((id = EditorTagManager.formatTag(id)) == null) {
                    return;
                }
                String[] elems = (String[])d.getList("elements").stream().map(String::valueOf).toArray(String[]::new);
                mngr.load(id, elems);
            });
        });
    }

    protected <T> void writeTags(ProjectWriter project, EditorTagManager<T> mngr, String name) throws IOException {
        String path = "tags/" + name + ".json";
        if (mngr.hasTags()) {
            JsonMap data = project.getJson(path);
            JsonList list = data.putList("tags");
            mngr.getTags().forEach(t -> {
                JsonMap d = list.addMap();
                d.put("id", t.getRawId());
                JsonList l = d.putList("elements");
                t.getEntries().forEach(l::add);
            });
        } else {
            project.delete(path);
        }
    }
}

