/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.loaders;

import com.tom.cpm.shared.config.ResourceLoader;
import com.tom.cpm.shared.loaders.HttpResourceLoader;
import java.io.IOException;
import java.net.URL;

public class GithubRepoResourceLoader
extends HttpResourceLoader {
    @Override
    protected URL createURL(String path) throws IOException {
        return new URL("https://raw.githubusercontent.com/" + path);
    }

    @Override
    public ResourceLoader.Validator getValidator() {
        return new ResourceLoader.Validator("GitHub Repo File", "github.com", "https\\:\\/\\/github\\.com\\/([a-zA-Z_0-9\\-]+)\\/([a-zA-Z_0-9\\-]+)\\/blob\\/([a-zA-Z_0-9\\-\\/]+)\\/([a-zA-Z_0-9\\-\\/\\.]+)\\#?[a-zA-Z_0-9\\-]*", "gh:$1/$2/$3/$4", "https://github.com/<username>/<repo>/blob/<branch>/<path>");
    }
}

