/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.builtin;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.model.builtin.IItemModel;
import com.tom.cpm.shared.model.builtin.SimpleModel;
import com.tom.cpm.shared.model.builtin.SimplePartRenderer;

public class TridentModel
extends SimpleModel
implements IItemModel {
    private final SimplePartRenderer pole;

    public TridentModel() {
        this.textureWidth = 32;
        this.textureHeight = 32;
        this.pole = new SimplePartRenderer(this, 0, 6);
        this.pole.addBox(-0.5f, 2.0f, -0.5f, 1.0f, 25.0f, 1.0f, 0.0f);
        SimplePartRenderer modelrenderer = new SimplePartRenderer(this, 4, 0);
        modelrenderer.addBox(-1.5f, 0.0f, -0.5f, 3.0f, 2.0f, 1.0f);
        this.pole.addChild(modelrenderer);
        SimplePartRenderer modelrenderer1 = new SimplePartRenderer(this, 4, 3);
        modelrenderer1.addBox(-2.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f);
        this.pole.addChild(modelrenderer1);
        SimplePartRenderer modelrenderer2 = new SimplePartRenderer(this, 0, 0);
        modelrenderer2.addBox(-0.5f, -4.0f, -0.5f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.pole.addChild(modelrenderer2);
        SimplePartRenderer modelrenderer3 = new SimplePartRenderer(this, 4, 3);
        modelrenderer3.mirror = true;
        modelrenderer3.addBox(1.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f);
        this.pole.addChild(modelrenderer3);
    }

    @Override
    public void render(MatrixStack stack, VertexBuffer buf) {
        this.pole.render(stack, buf);
    }

    @Override
    public String getTexture() {
        return "trident";
    }

    @Override
    public void render(MatrixStack stack, VertexBuffer buf, ItemSlot inSlot) {
        stack.push();
        stack.rotate(Vec3f.POSITIVE_X.getDegreesQuaternion(-90.0f));
        stack.rotate(Vec3f.POSITIVE_Y.getDegreesQuaternion(-90.0f));
        float z = inSlot == ItemSlot.LEFT_HAND ? -0.05f : 0.05f;
        stack.translate(0.5, -1.0, z);
        this.render(stack, buf);
        stack.pop();
    }
}

