/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpl.function.FloatUnaryOperator;
import com.tom.cpm.shared.animation.InterpolationInfo;
import com.tom.cpm.shared.animation.interpolator.Interpolator;
import com.tom.cpm.shared.animation.interpolator.InterpolatorType;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.AnimationFrameData;
import com.tom.cpm.shared.parts.anim.AnimationFrameDataType;
import com.tom.cpm.shared.parts.anim.AnimatorChannel;
import com.tom.cpm.shared.parts.anim.SerializedAnimation;
import com.tom.cpm.shared.parts.anim.TagType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConstantTimeFloat
implements AnimationFrameData {
    private InterpolatorType intType;
    private float[] frames;

    public ConstantTimeFloat(InterpolatorType intType, float[] frames) {
        this.intType = intType;
        this.frames = frames;
    }

    public static void parse(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedAnimation cA = state.getAnim();
        InterpolatorType intType = (InterpolatorType)block.readEnum(InterpolatorType.VALUES);
        int frames = block.readVarInt();
        int compCount = block.readVarInt();
        for (int i = 0; i < compCount; ++i) {
            int channelID = block.readVarInt();
            AnimatorChannel ch = cA.animatorChannels.get(channelID);
            float[] f = new float[frames];
            for (int j = 0; j < frames; ++j) {
                f[j] = block.readVarFloat();
            }
            ch.frameData = new ConstantTimeFloat(intType, f);
        }
    }

    public static void write(List<SerializedAnimation.AnimFrame<ConstantTimeFloat>> frames, IOHelper h) throws IOException {
        HashMap groups = new HashMap();
        frames.forEach(f -> groups.computeIfAbsent(new AnimType(((ConstantTimeFloat)f.data).intType, ((ConstantTimeFloat)f.data).frames.length), __ -> new ArrayList()).add(f));
        for (Map.Entry e : groups.entrySet()) {
            IOHelper d = h.writeNextObjectBlock(TagType.CONSTANT_FRAME_TIME_FLOAT);
            Throwable throwable = null;
            try {
                AnimType t = (AnimType)e.getKey();
                d.writeEnum(t.intType);
                d.writeVarInt(t.frames);
                d.writeVarInt(((List)e.getValue()).size());
                for (SerializedAnimation.AnimFrame f2 : (List)e.getValue()) {
                    d.writeVarInt(f2.channel);
                    for (int i = 0; i < t.frames; ++i) {
                        d.writeVarFloat(((ConstantTimeFloat)f2.data).frames[i]);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (d == null) continue;
                if (throwable != null) {
                    try {
                        d.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                d.close();
            }
        }
    }

    @Override
    public AnimationFrameDataType getType() {
        return AnimationFrameDataType.CONSTANT_FRAME_FLOAT;
    }

    @Override
    public FloatUnaryOperator createDriver(InterpolationInfo part) {
        return new ConstantTimeFloatDriver(part, this.intType, this.frames);
    }

    public static class ConstantTimeFloatDriver
    implements FloatUnaryOperator {
        private final Interpolator intp;
        private final int frames;

        public ConstantTimeFloatDriver(InterpolationInfo output, InterpolatorType intType, float[] frames) {
            this.frames = frames.length;
            this.intp = intType.create();
            this.intp.init(frames, output.createInterpolatorSetup());
        }

        @Override
        public float apply(float value) {
            if (this.frames == 0) {
                return 0.0f;
            }
            return (float)this.intp.applyAsDouble(value * (float)this.frames);
        }
    }

    private static class AnimType {
        private final InterpolatorType intType;
        private final int frames;

        public AnimType(InterpolatorType intType, int frames) {
            this.intType = intType;
            this.frames = frames;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.frames;
            result = 31 * result + (this.intType == null ? 0 : this.intType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnimType other = (AnimType)obj;
            if (this.frames != other.frames) {
                return false;
            }
            return this.intType == other.intType;
        }
    }
}

