
<a name="cpm-api-documentation"/>

# CPM Api documentation
Table of contents:
* [Setup](#setup) ([Versions](#latest-versions))
* [Create your Plugin](#create-your-plugin)
* [Client API](#client-api)
* [Common API](#common-api)


<a name="setup"/>

## Setup
Add the CPM api to your gradle build script (`build.gradle`):  


<a name="manual"/>

### Manual
Download the api from [Releases](https://github.com/tom5454/CustomPlayerModels/releases)
and put it into your mod dev folder.  
Add it to your gradle file

```gradle
dependencies {
	implementation files("CustomPlayerModels-API-${cpm_api_version}.jar");
}
```


<a name="gradle"/>

### Gradle


<a name="repositories"/>

#### Repositories

```gradle
repositories {
  maven {
    name = "tom5454 maven"
    url = "https://raw.githubusercontent.com/tom5454/maven/main"
  }
}
```


<a name="latest-versions"/>

#### Latest versions
API version: ![API version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-API%2Fmaven-metadata.xml)

| Minecraft Version ID (Actual MC Version) | Runtime version (Forge) | Runtime version (NeoForge) | Runtime version (Fabric) | Runtime version (Quilt) |
| ----------------- | ----------------------- | -------------------------- | ------------------------ | ----------------------- |
| 1.21.4 | ![1.21.4 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModelsLexForge-1.21.4%2Fmaven-metadata.xml) | ![1.21.4 neoforge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.21.4%2Fmaven-metadata.xml) | ![1.21.4 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.21.4%2Fmaven-metadata.xml) | - |
| 1.21.3 | ![1.21.3 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModelsLexForge-1.21.3%2Fmaven-metadata.xml) | ![1.21.3 neoforge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.21.3%2Fmaven-metadata.xml) | ![1.21.3 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.21.3%2Fmaven-metadata.xml) | - |
| 1.21, (1.21.1) | ![1.21 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModelsLexForge-1.21%2Fmaven-metadata.xml) | ![1.21 neoforge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.21%2Fmaven-metadata.xml) | ![1.21 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.21%2Fmaven-metadata.xml) | ![1.21 quilt version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Quilt-1.21%2Fmaven-metadata.xml) |
| 1.20.6 | ![1.20.6 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModelsLexForge-1.20.6%2Fmaven-metadata.xml) | ![1.20.6 neoforge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.20.6%2Fmaven-metadata.xml) | ![1.20.6 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.20.6%2Fmaven-metadata.xml) | Use the Fabric version |
| 1.20.4 | ![1.20.4 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModelsLexForge-1.20.4%2Fmaven-metadata.xml) | ![1.20.4 neoforge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.20.4%2Fmaven-metadata.xml) | ![1.20.4 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.20.4%2Fmaven-metadata.xml) | ![1.20.4 quilt version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Quilt-1.20.4%2Fmaven-metadata.xml) |
| 1.20.2 | ![1.20.2 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModelsLexForge-1.20.2%2Fmaven-metadata.xml) | ![1.20.2 neoforge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.20.2%2Fmaven-metadata.xml) | ![1.20.2 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.20.2%2Fmaven-metadata.xml) | Use the Fabric version |
| 1.20, (1.20.1) | ![1.20 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.20%2Fmaven-metadata.xml) | Use the Forge version | ![1.20 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.20%2Fmaven-metadata.xml) | ![1.20 quilt version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Quilt-1.20%2Fmaven-metadata.xml) |
| 1.19.4 | ![1.19.4 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.19.4%2Fmaven-metadata.xml) | - | ![1.19.4 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.19.4%2Fmaven-metadata.xml) | Use the Fabric version |
| 1.19.3 | ![1.19.3 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.19.3%2Fmaven-metadata.xml) | - | ![1.19.3 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.19.3%2Fmaven-metadata.xml) | Use the Fabric version |
| 1.19, (1.19.2) | ![1.19 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.19%2Fmaven-metadata.xml) | - | ![1.19 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.19%2Fmaven-metadata.xml) | Use the Fabric version |
| 1.18, (1.18.2) | ![1.18 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.18%2Fmaven-metadata.xml) | - | ![1.18 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.18%2Fmaven-metadata.xml) | Use the Fabric version |
| 1.17, (1.17.1) | ![1.17 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.17%2Fmaven-metadata.xml) | - | ![1.17 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.17%2Fmaven-metadata.xml) | - |
| 1.16, (1.16.5) | ![1.16 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.16%2Fmaven-metadata.xml) | - | ![1.16 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.16%2Fmaven-metadata.xml) | - |
| 1.15, (1.15.2) | ![1.15 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.15%2Fmaven-metadata.xml) | - | ![1.15 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.15%2Fmaven-metadata.xml) | - |
| 1.14, (1.14.4) | ![1.14 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.14%2Fmaven-metadata.xml) | - | ![1.14 fabric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-Fabric-1.14%2Fmaven-metadata.xml) | - |
| 1.12.2 | ![1.12 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.12.2%2Fmaven-metadata.xml) | - | - | - |
| 1.10.2 | ![1.10 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.10.2%2Fmaven-metadata.xml) | - | - | - |
| 1.8 | ![1.8 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.8%2Fmaven-metadata.xml) | - | - | - |
| 1.7.10 | ![1.7 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.7.10%2Fmaven-metadata.xml) | - | - | - |
| 1.6.4 | ![1.6 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.6.4%2Fmaven-metadata.xml) | - | - | - |
| 1.5.2 | ![1.5 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.5.2%2Fmaven-metadata.xml) | - | - | - |
| 1.4.7 | ![1.4 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.4.7%2Fmaven-metadata.xml) | - | - | - |
| 1.2.5 | ![1.2 forge version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-1.7.10%2Fmaven-metadata.xml) | - | - | - |
| b1.7.3 | - | - | ![b1.7.3 babric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-b1.7.3%2Fmaven-metadata.xml) | - |
| BTA | - | - | ![BTA babric version badge](https://img.shields.io/maven-metadata/v?color=forestgreen&label=release&metadataUrl=https%3A%2F%2Fraw.githubusercontent.com%2Ftom5454%2Fmaven%2Fmain%2Fcom%2Ftom5454%2Fcpm%2FCustomPlayerModels-BTA%2Fmaven-metadata.xml) | - |


<a name="gradleproperties"/>

#### gradle.properties
```ini
# CPM versions
cpm_api_version=<api version>
cpm_mc_version=<minecraft version>
cpm_runtime_version=<runtime version>
```


<a name="dependencies-using-fg2"/>

#### Dependencies using FG2
```gradle
dependencies {
  compile "com.tom5454.cpm:CustomPlayerModels-API:${project.cpm_api_version}"
  deobfProvided "com.tom5454.cpm:CustomPlayerModels-${project.cpm_mc_version}:${project.cpm_runtime_version}"
}
```


<a name="dependencies-using-fg3"/>

#### Dependencies using FG3+

```gradle
dependencies {
  /* minecraft dependency is here */

  compileOnly "com.tom5454.cpm:CustomPlayerModels-API:${project.cpm_api_version}"
  runtimeOnly fg.deobf("com.tom5454.cpm:CustomPlayerModels-${project.cpm_mc_version}:${project.cpm_runtime_version}")
}
```


<a name="dependencies-using-neogradle"/>

#### Dependencies using NeoGradle

```gradle
dependencies {
  /* minecraft dependency is here */

  compileOnly "com.tom5454.cpm:CustomPlayerModels-API:${project.cpm_api_version}"
  runtimeOnly "com.tom5454.cpm:CustomPlayerModels-${project.cpm_mc_version}:${project.cpm_runtime_version}"
}
```


<a name="dependencies-using-fabric"/>

#### Dependencies using Fabric

```gradle
dependencies {
  /* minecraft dependency is here */
  
  compileOnly "com.tom5454.cpm:CustomPlayerModels-API:${project.cpm_api_version}"
  modRuntimeOnly "com.tom5454.cpm:CustomPlayerModels-Fabric-${project.cpm_mc_version}:${project.cpm_runtime_version}"
}
```


<a name="dependencies-using-voldeloom"/>

#### Dependencies using Voldeloom

```gradle
dependencies {
  /* minecraft dependency is here */
  
  compileOnly "com.tom5454.cpm:CustomPlayerModels-API:${project.cpm_api_version}"
  //1.4.7, 1.5.2
  coremodImplementation ("com.tom5454.cpm:CustomPlayerModels-${project.cpm_mc_version}:${project.cpm_runtime_version}") {
    copyToFolder("coremods")
  }
  //1.6.4
  modRuntimeOnly "com.tom5454.cpm:CustomPlayerModels-${project.cpm_mc_version}:${project.cpm_runtime_version}"
}
```

On 1.2.5:  

```gradle
volde {
	runs {
		client {
			programArg "Dev"
			vmArg "-Dcpmcore.deobf=true"
			vmArg "-Dcpmcore.env.client=true"
			vmArg "-javaagent:\"" + file("CustomPlayerModels-${project.cpm_runtime_version}.jar").absolutePath + "\""
		}
	}
}

dependencies {
  /* minecraft dependency is here */
  
  compileOnly "com.tom5454.cpm:CustomPlayerModels-API:${project.cpm_api_version}"
}
```

You have to place the current mod version from Modrinth to the project root folder, or the Java Agent won't load.


<a name="create-your-plugin"/>

## Create your Plugin

Create a class implementing `ICPMPlugin`.

```java
public class CPMCompat implements ICPMPlugin {
	public void initClient(IClientAPI api) {
		//Init client
	}
	
	public void initCommon(ICommonAPI api) {
		//Init common
	}
	
	public String getOwnerModId() {
		return "example_mod";
	}
}
```


<a name="forge-125"/>

### Forge 1.2.5
The plugin loader isn't implemented yet.


<a name="forge-112-and-lower"/>

### Forge 1.12 and lower
Send an IMC message with your plugin class location.  
`FMLInterModComms.sendMessage("customplayermodels", "api", "com.example.mod.CPMCompat");`


<a name="forge-116-and-up"/>

### Forge 1.16 and up
Send an IMC message. 
 
```java
public MyMod() {
	...
	FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
	...
}
	
private void enqueueIMC(final InterModEnqueueEvent event)  {
	InterModComms.sendTo("cpm", "api", () -> (Supplier<?>) () -> new CPMCompat());
	...
}
```


<a name="fabric"/>

### Fabric
Register your plugin class as entry point in your fabric.mod.json as such:

```json
"entrypoints": {
    "cpmapi": [ "com.example.mod.CPMCompat" ]
}
```


<a name="bukkit-spigot-paper"/>

### Bukkit, Spigot, Paper (0.4.1+)
Register your plugin using the service manager, your plugin's `initCommon` method will be called with the `ICommonAPI` instance.

```java
RegisteredServiceProvider<CPMPluginRegistry> rsp = getServer().getServicesManager().getRegistration(CPMPluginRegistry.class);
if (rsp != null)
	rsp.getProvider().register(new CPMCompat());
else
	log.info("Customizable Player Models plugin not installed, compat disabled");
```


<a name="client-api"/>

## Client API


<a name="voice-animation"/>

### Voice animation
Register a voice level supplier.  
`IClientAPI:registerVoice(Player.class, player -> voiceLevel);`  
[Player.class](#client-playerclass)  

Register a voice level supplier. (UUID variant) (0.6.0+)  
`IClientAPI:registerVoice(playerUUID -> voiceLevel);`  

Register a voice muted supplier. (0.6.0+)  
`IClientAPI:registerVoiceMute(Player.class, player -> voiceMuted);`  
[Player.class](#client-playerclass)  

Register a voice muted supplier. (UUID variant) (0.6.0+)  
`IClientAPI:registerVoiceMute(playerUUID -> voiceMuted);`  


<a name="rendering-api"/>

### Rendering API
Create a player renderer to render CPM models on any Humanoid Entity.  
`PlayerRenderer<Model, ResourceLocation, RenderType, MultiBufferSource, GameProfile> renderer = IClientAPI.createPlayerRenderer(Model.class, ResourceLocation.class, RenderType.class, MultiBufferSource.class, GameProfile.class)`  
For 1.12 and lower use:  
`RetroPlayerRenderer<Model, GameProfile> renderer = IClientAPI.createPlayerRenderer(Model.class, GameProfile.class);`  
[Model.class](#client-modelclass)  
[ResourceLocation.class](#client-resourcelocationclass)  
[RenderType.class](#client-rendertypeclass)  
[MultiBufferSource.class](#client-multibuffersourceclass)  
[GameProfile.class](#client-gameprofileclass)  


<a name="rendering-an-entity-with-cpm-model"/>

#### Rendering an Entity with CPM model
1. Using the renderer set the GameProfile or LocalModel before rendering.  
`setGameProfile(gameProfile)`: Render player model  
`setLocalModel(localModel)`: Render a local model, [Loading a local model](#loading-a-local-model)  
2. Set the base model, must be a Humanoid or Biped model: `setRenderModel(model)`
3. Set the default RenderType factory on 1.16+: e.g.: translucent entity: `setRenderType(RenderType::entityTranslucent)`.
4. Pose the model, apply animations to the model using `getAnimationState()`, `setActivePose(pose)`, `setActiveGesture(gesture)`.
5. Call `preRender(buffers, mode)` (or `preRender(mode)`, on 1.12-)
6. Render your model normally. CPM has injected it's renderer into your model. (Use `getDefaultRenderType()` for getting the RenderType for the model (1.16+)).
    1. To render additional parts (elytra, cape, armor) call: `prepareSubModel(model, type, texture)` (or `prepareSubModel(model, type)` on 1.12-)  
    2. Optionally on 1.16+ change the default RenderType for the part: e.g.: `setRenderType(RenderType::armorCutoutNoCull)`
    3. Render your part (Use `getRenderTypeForSubModel(subModel)` for getting the RenderType for the model (1.16+)).
7. Call `postRender()` to finish rendering.  

Example (1.18 Forge):

```java
import java.io.IOException;
import java.io.InputStream;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider.Context;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;

import com.tom.cpm.api.IClientAPI;
import com.tom.cpm.api.IClientAPI.PlayerRenderer;
import com.tom.cpm.shared.animation.AnimationEngine.AnimationMode;

public class ExampleRenderer extends LivingEntityRenderer<ExampleEntity, PlayerModel<ExampleEntity>> {
	private static PlayerRenderer<Model, ResourceLocation, RenderType, MultiBufferSource, GameProfile> renderer;

	public static void init(IClientAPI api) {
		renderer = api.createPlayerRenderer(Model.class, ResourceLocation.class, RenderType.class, MultiBufferSource.class, GameProfile.class);
		
		// TODO: replace with resource reload listeners to support resourcepacks.
		try (InputStream is = Minecraft.getInstance().getResourceManager().open(new ResourceLocation("example_mod", "models/example_entity_model.cpmmodel"))){
			renderer.setLocalModel(api.loadModel("example_entity_model", is));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public ExampleRenderer(Context pContext, float pShadowRadius) {
		super(pContext, new PlayerModel<>(pContext.bakeLayer(ModelLayers.PLAYER), false), pShadowRadius);

	}

	@Override
	public void render(ExampleEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack,
			MultiBufferSource pBuffer, int pPackedLight) {
		renderer.setRenderModel(model);
		renderer.setRenderType(RenderType::entityTranslucent);
		//Pose model using renderer.getAnimationState(), setActivePose(name) or setActiveGesture(name)
		renderer.preRender(pBuffer, AnimationMode.PLAYER);
		if(renderer.getDefaultTexture() != null) {
			super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
		} else {
			renderNameTag(pEntity, pEntity.getDisplayName(), pMatrixStack, pBuffer, pPackedLight);
		}
		renderer.postRender();
	}

	@Override
	public ResourceLocation getTextureLocation(ExampleEntity pEntity) {
		return renderer.getDefaultTexture();
	}
}
```

While the model is loading in the background `renderer.getDefaultTexture()` will return null!


<a name="loading-a-local-model"/>

#### Loading a local model
Load a model from a `.cpmmodel` file.  
`IClientAPI.loadModel(name, inputstream)`  
Use the loaded model for [Rendering an Entity](#rendering-an-entity-with-cpm-model)


<a name="register-editor-generator"/>

### Register Editor Generator
Register a model generator for the editor. Generators are under `Edit/Tools`.  
`IClientAPI.registerEditorGenerator("button.example_mod.example_generator", "tooltip.example_mod.example_generator", ExampleGenerator::apply);`  

```java
public class ExampleGenerator {
	public static void apply(EditorGui gui) {
		//TODO: apply the generator
		// Use gui.getEditor() to access the editor
		// Use Editor.action and ActionBuilder to make undoable changes.
		// Note: parts of the editor may change.
	}
}
```

Localization:  
Add `button.example_mod.example_generator`, `tooltip.example_mod.example_generator` to your language file. Use `\` characters for line breaks in the tooltip.


<a name="play-animation"/>

### Play Animation (0.6.0+)
Play the given command animation for a player (Client-side).  

Name: Animation name  
`IClientAPI.playAnimation(name);` or  
Value: 0: reset pose/gesture, 1: play pose/gesture, for layers value: 0-255, toggle: 0-1 or -1 to switch state
`IClientAPI.playAnimation(name, value);`  
Returns: true if the animation was found and started playing  


<a name="detect-animation"/>

### Detect Animation (0.6.14+)
Detect if an animation is playing for the player  
`int value = IClientAPI.getAnimationPlaying(name);`  
Returns: The animation value (value layer: 0-255, other animations: 0-1), -1 if animation doesn't exist  

<a name="get-animation-max-value"/>

### Get Animation Maximum Value (0.6.20+)
Get the max value for the given animation (value or toggle)  
`int value = IClientAPI.getAnimationMaxValue(name);`  
Returns: maximum value for layers (value set in the animation 0-255, toggle: always 1, -1 if animation doesn't exist or isn't a layer)  

<a name="client-networking"/>

### Client Networking (0.6.1+)
Register a NBT message to send to the server, or broadcast it to other clients.  
`MessageSender sender = IClientAPI.registerPluginMessage(Player.class, message_id, (player, message) -> {/*Handle message*/}, broadcastToTracking);`  
[Player.class](#client-playerclass)  
or UUID version:  
`MessageSender sender = IClientAPI.registerPluginMessage(message_id, (player_uuid, message) -> {/*Handle message*/}, broadcastToTracking);`  
Use the `MessageSender` to send messages.  
`boolean success = sender.sendMessage(message_tag);`  
Use the platform independent NBT implementation from `com.tom.cpl.nbt.*` package.  
broadcastToTracking: false: Send the message to the server / true: broadcast message to nearby players (through the server).  
CPM 0.6.1+ is required on the server side for the networking to work.  
When using broadcastToTracking, or State Messages your mod/plugin is not required on the server for the packet forwarding to work, you don't have to register anything. To receive non broadcast messages use the ICommonAPI.registerPluginMessage  


<a name="state-messages"/>

#### State Messages
The last state message is stored on the server and sent to every client that enters the tracking range (render distance).  
`MessageSender sender = IClientAPI.registerPluginStateMessage(Player.class, message_id, (player, message) -> {/*Handle message*/});`  
[Player.class](#client-playerclass)  
or UUID version:  
`MessageSender sender = IClientAPI.registerPluginMessage(message_id, (player_uuid, message) -> {/*Handle message*/});`  


<a name="class-map"/>

### Class Map
Classes are dependent on your minecraft version and mod loader.  

<a name="client-playerclass"/>

#### Client Player.class
Minecraft Forge 1.12 and lower: `EntityPlayer.class`  
Minecraft Forge 1.16 and Fabric: `PlayerEntity.class`  
Minecraft Forge 1.17 and up: `Player.class` from `net.minecraft.*`  


<a name="client-modelclass"/>

#### Client Model.class
Minecraft Forge 1.16+ and Fabric: `Model.class` from `net.minecraft.client.*`  
Minecraft Forge 1.12 and lower: `ModelBase.class`  


<a name="client-resourcelocationclass"/>

#### Client ResourceLocation.class
Minecraft Forge: `ResourceLocation.class`  
Fabric: `Identifier.class`  


<a name="client-rendertypeclass"/>

#### Client RenderType.class
Minecraft Forge: `RenderType.class`  
Fabric: `RenderLayer.class`  


<a name="client-multibuffersourceclass"/>

#### Client MultiBufferSource.class
Minecraft Forge 1.16: `IRenderTypeBuffer.class`  
Minecraft Forge (1.17+): `MultiBufferSource.class`  
Fabric: `VertexConsumerProvider.class`  


<a name="client-gameprofileclass"/>

#### Client GameProfile.class
GameProfile from AuthLib: `com.mojang.authlib.GameProfile`  


<a name="common-api"/>

## Common API


<a name="set-model"/>

### Set Model (0.4.1+)
Set the player model  
`ICommonAPI.setPlayerModel(Player.class, playerObj, base64Model, forced, persistent);`  
or  
`ICommonAPI.setPlayerModel(Player.class, playerObj, modelFile, forced);`  
Create a ModelFile using `ModelFile.load(file);` or `ModelFile.load(inputstream);`  
or  
`ICommonAPI.resetPlayerModel(Player.class, playerObj);`  
clear the server set model  
[Player.class](#common-playerclass)  


<a name="jump"/>

### Jump (0.4.1+)
Play the jump animation on for a player.  
`ICommonAPI.playerJumped(Player.class, playerObj);`  
[Player.class](#common-playerclass)


<a name="play-animation"/>

### Play Animation (0.6.0+)
Play the given command animation for a player (Server-side).  

Name: Animation name  
`ICommonAPI.playAnimation(Player.class, playerObj, name);` or  
`ICommonAPI.playAnimation(Player.class, playerObj, name, value);`  
Value: 0: reset pose/gesture, 1: play pose/gesture, for layers value: 0-255, toggle: 0-1 or -1 to switch state  
[Player.class](#common-playerclass)


<a name="server-networking"/>

### Server Networking (0.6.1+)
Register a NBT message to receive non broadcast messages/send messages to clients.  
`MessageSender<Player> sender = ICommonAPI.registerPluginMessage(Player.class, message_id, (player, message) -> {/*Handle message*/});`  
[Player.class](#client-playerclass)  
Use the `MessageSender` to send messages.  
`boolean success = sender.sendMessageTo(player, message_tag);`  
or broadcast to nearby players:  
`sender.sendMessageToTracking(player, message_tag, sendToSelf);`  
Use the platform independent NBT implementation from `com.tom.cpl.nbt.*` package.  
sendToSelf: Send message to the selected player in argument 1


<a name="detect-animation"/>

### Detect Animation (0.6.9+)
Detect if an animation is playing for the player  
`int value = ICommonAPI.getAnimationPlaying(Player.class, playerObj, name);`  
Returns: The animation value (value layer: 0-255, other animations: 0-1), -1 if animation doesn't exist  
[Player.class](#common-playerclass)  


<a name="class-map"/>

### Class Map
Classes are dependent on your minecraft version and mod loader.  

<a name="common-playerclass"/>

#### Common Player.class
Minecraft Forge 1.12 and lower: `EntityPlayer.class`  
Minecraft Forge 1.16 and Fabric: `PlayerEntity.class`  
Minecraft Forge 1.17 and up: `Player.class` from `net.minecraft.*`  
Bukkit: `Player.class` from `org.bukkit.entity`.
