/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.math.Box;

public class ConfirmPopup
extends PopupPanel
implements Runnable {
    private boolean okPressed;
    private Frame frm;
    private String title;

    public ConfirmPopup(Frame frame, String msg, Runnable ok, Runnable cancel) {
        this(frame, frame.getGui().i18nFormat("label.cpm.confirm", new Object[0]), msg, ok, cancel);
    }

    public ConfirmPopup(Frame frame, String title, String msg, Runnable ok, Runnable cancel) {
        this(frame, title, msg, ok, cancel, frame.getGui().i18nFormat("button.cpm.ok", new Object[0]));
    }

    public ConfirmPopup(Frame frame, String title, String msg, Runnable ok, Runnable cancel, String okTxt) {
        this(frame, title, msg, ok, cancel, okTxt, frame.getGui().i18nFormat("button.cpm.cancel", new Object[0]));
    }

    public ConfirmPopup(Frame frame, String title, String msg, Runnable ok, Runnable cancel, String okTxt, String cancelTxt) {
        super(frame.getGui());
        int w;
        int i;
        this.frm = frame;
        this.title = title;
        String[] lines = msg.split("\\\\");
        int wm = 180;
        for (i = 0; i < lines.length; ++i) {
            w = this.gui.textWidth(lines[i]);
            if (w <= wm) continue;
            wm = w;
        }
        for (i = 0; i < lines.length; ++i) {
            w = this.gui.textWidth(lines[i]);
            this.addElement(new Label(this.gui, lines[i]).setBounds(new Box(wm / 2 - w / 2 + 10, 5 + i * 10, 0, 0)));
        }
        this.setBounds(new Box(0, 0, wm + 20, 45 + lines.length * 10));
        Button btn = new Button(this.gui, okTxt, () -> {
            this.okPressed = true;
            this.close();
            ok.run();
        });
        Button btnNo = new Button(this.gui, cancelTxt, () -> {
            this.close();
            if (cancel != null) {
                cancel.run();
            }
        });
        btn.setBounds(new Box(5, 20 + lines.length * 10, 25 + this.gui.textWidth(okTxt), 20));
        btnNo.setBounds(new Box(35 + this.gui.textWidth(okTxt), 20 + lines.length * 10, 25 + this.gui.textWidth(cancelTxt), 20));
        this.addElement(btn);
        this.addElement(btnNo);
        if (cancel != null) {
            this.setOnClosed(() -> {
                if (!this.okPressed) {
                    cancel.run();
                }
            });
        }
    }

    @Override
    public void run() {
        this.frm.openPopup(this);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private static Runnable action(ConfirmPopup p, Runnable ok) {
        return () -> {
            if (p.getGui().isShiftDown()) {
                ok.run();
            } else {
                p.run();
            }
        };
    }

    public static Runnable confirmHandler(Frame frame, String title, String msg, Runnable ok, Runnable cancel, String okTxt, String cancelTxt) {
        ConfirmPopup p = new ConfirmPopup(frame, title, msg, ok, cancel, okTxt, cancelTxt);
        return ConfirmPopup.action(p, ok);
    }

    public static Runnable confirmHandler(Frame frame, String title, String msg, Runnable ok, String okTxt) {
        ConfirmPopup p = new ConfirmPopup(frame, title, msg, ok, null, okTxt);
        return ConfirmPopup.action(p, ok);
    }

    public static Runnable confirmHandler(Frame frame, String title, String msg, Runnable ok) {
        ConfirmPopup p = new ConfirmPopup(frame, title, msg, ok, null);
        return ConfirmPopup.action(p, ok);
    }

    public static Runnable confirmHandler(Frame frame, String msg, Runnable ok) {
        ConfirmPopup p = new ConfirmPopup(frame, msg, ok, null);
        return ConfirmPopup.action(p, ok);
    }

    public static void confirm(Frame frame, String title, String msg, Runnable ok, Runnable cancel, String okTxt, String cancelTxt) {
        ConfirmPopup.confirmHandler(frame, title, msg, ok, cancel, okTxt, cancelTxt).run();
    }

    public static void confirm(Frame frame, String title, String msg, Runnable ok, String okTxt) {
        ConfirmPopup.confirmHandler(frame, title, msg, ok, okTxt).run();
    }

    public static void confirm(Frame frame, String title, String msg, Runnable ok) {
        ConfirmPopup.confirmHandler(frame, title, msg, ok).run();
    }

    public static void confirm(Frame frame, String msg, Runnable ok) {
        ConfirmPopup.confirmHandler(frame, msg, ok).run();
    }
}

