/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.render;

import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.render.VertexBuffer;

public class TransformedBuffer
implements VertexBuffer {
    private VertexBuffer buf;
    private Mat4f matrix;
    private Mat3f normal;

    public TransformedBuffer(VertexBuffer buf, MatrixStack.Entry transform) {
        this.buf = buf;
        this.matrix = transform.getMatrix();
        this.normal = transform.getNormal();
    }

    @Override
    public VertexBuffer pos(float x, float y, float z) {
        this.buf.pos(this.matrix, x, y, z);
        return this;
    }

    @Override
    public VertexBuffer tex(float u, float v) {
        this.buf.tex(u, v);
        return this;
    }

    @Override
    public VertexBuffer color(float red, float green, float blue, float alpha) {
        this.buf.color(red, green, blue, alpha);
        return this;
    }

    @Override
    public VertexBuffer normal(float x, float y, float z) {
        this.buf.normal(this.normal, x, y, z);
        return this;
    }

    @Override
    public void endVertex() {
        this.buf.endVertex();
    }

    @Override
    public void finish() {
        this.buf.finish();
    }
}

