/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.item.Stack;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpm.client.GLFWKeyCodes;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.Panel3dImpl;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.TinyFDChooser;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.gui.panel.Panel3d;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.glfw.GLFW;

public class GuiBase
extends Screen
implements IGui {
    protected static final KeyCodes CODES = new GLFWKeyCodes();
    protected static final NativeGuiComponents nativeComponents = new NativeGuiComponents();
    protected Frame gui;
    protected Screen parent;
    protected IGui.CtxStack stack;
    protected UIColors colors = new UIColors();
    protected Consumer<Runnable> closeListener;
    protected int keyModif;
    protected PoseStack matrixStack;
    protected boolean noScissorTest;
    protected int vanillaScale = -1;

    public GuiBase(Function<IGui, Frame> creator, Screen parent) {
        super((Component)new TextComponent(""));
        this.parent = parent;
        try {
            this.gui = creator.apply(this);
        }
        catch (Throwable e) {
            this.onGuiException("Error creating gui", e, true);
        }
        this.noScissorTest = this.isCtrlDown();
    }

    private static <G extends Supplier<IGui>, N> NativeGuiComponents.NativeConstructor<G, N> local(Function<GuiBase, N> fac) {
        return f -> fac.apply((GuiBase)f.get());
    }

    public boolean m_7043_() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        block8: {
            this.m_96558_(matrixStack, 0);
            try {
                this.matrixStack = matrixStack;
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.0, 0.0, 800.0);
                this.stack = new IGui.CtxStack(this.f_96543_, this.f_96544_);
                RenderSystem.m_69890_(() -> this.gui.draw(mouseX, mouseY, partialTicks));
                if (this.noScissorTest) break block8;
            }
            catch (Throwable e) {
                block9: {
                    try {
                        this.onGuiException("Error drawing gui", e, true);
                        if (this.noScissorTest) break block9;
                    }
                    catch (Throwable throwable) {
                        if (!this.noScissorTest) {
                            RenderSystem.m_69471_();
                        }
                        String modVer = MinecraftCommonAccess.get().getModVersion();
                        Object s = "Minecraft " + SharedConstants.m_183709_().getName() + " (" + this.f_96541_.m_91388_() + "/" + ClientBrandRetriever.m_129629_() + (String)("release".equalsIgnoreCase(this.f_96541_.m_91389_()) ? "" : "/" + this.f_96541_.m_91389_()) + ") " + modVer;
                        this.f_96547_.m_92883_(matrixStack, (String)s, (float)(this.f_96543_ - this.f_96547_.m_92895_((String)s) - 4), 2.0f, -16777216);
                        s = this.f_96541_.f_90977_;
                        if (this.noScissorTest) {
                            s = (String)s + " No Scissor";
                        }
                        this.f_96547_.m_92883_(matrixStack, (String)s, (float)(this.f_96543_ - this.f_96547_.m_92895_((String)s) - 4), 11.0f, -16777216);
                        this.matrixStack = null;
                        matrixStack.m_85849_();
                        throw throwable;
                    }
                    RenderSystem.m_69471_();
                }
                String modVer = MinecraftCommonAccess.get().getModVersion();
                Object s = "Minecraft " + SharedConstants.m_183709_().getName() + " (" + this.f_96541_.m_91388_() + "/" + ClientBrandRetriever.m_129629_() + (String)("release".equalsIgnoreCase(this.f_96541_.m_91389_()) ? "" : "/" + this.f_96541_.m_91389_()) + ") " + modVer;
                this.f_96547_.m_92883_(matrixStack, (String)s, (float)(this.f_96543_ - this.f_96547_.m_92895_((String)s) - 4), 2.0f, -16777216);
                s = this.f_96541_.f_90977_;
                if (this.noScissorTest) {
                    s = (String)s + " No Scissor";
                }
                this.f_96547_.m_92883_(matrixStack, (String)s, (float)(this.f_96543_ - this.f_96547_.m_92895_((String)s) - 4), 11.0f, -16777216);
                this.matrixStack = null;
                matrixStack.m_85849_();
            }
            RenderSystem.m_69471_();
        }
        String modVer = MinecraftCommonAccess.get().getModVersion();
        Object s = "Minecraft " + SharedConstants.m_183709_().getName() + " (" + this.f_96541_.m_91388_() + "/" + ClientBrandRetriever.m_129629_() + (String)("release".equalsIgnoreCase(this.f_96541_.m_91389_()) ? "" : "/" + this.f_96541_.m_91389_()) + ") " + modVer;
        this.f_96547_.m_92883_(matrixStack, (String)s, (float)(this.f_96543_ - this.f_96547_.m_92895_((String)s) - 4), 2.0f, -16777216);
        s = this.f_96541_.f_90977_;
        if (this.noScissorTest) {
            s = (String)s + " No Scissor";
        }
        this.f_96547_.m_92883_(matrixStack, (String)s, (float)(this.f_96543_ - this.f_96547_.m_92895_((String)s) - 4), 11.0f, -16777216);
        this.matrixStack = null;
        matrixStack.m_85849_();
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
        if (this.vanillaScale >= 0 && this.vanillaScale != this.f_96541_.f_91066_.f_92072_) {
            this.f_96541_.f_91066_.f_92072_ = this.vanillaScale;
            this.vanillaScale = -999;
            this.f_96541_.m_5741_();
        }
    }

    public void m_7379_() {
        Screen p = this.parent;
        this.parent = null;
        this.f_96541_.m_91152_(p);
    }

    @Override
    public void drawBox(int x, int y, int w, int h, int color) {
        GuiBase.m_93172_((PoseStack)this.matrixStack, (int)(x += this.getOffset().x), (int)(y += this.getOffset().y), (int)(x + w), (int)(y + h), (int)color);
    }

    @Override
    public void drawBox(float x, float y, float w, float h, int color) {
        float minX = x += (float)this.getOffset().x;
        float minY = y += (float)this.getOffset().y;
        float maxX = x + w;
        float maxY = y + h;
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        Matrix4f matrix = this.matrixStack.m_85850_().m_85861_();
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(matrix, minX, maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrix, maxX, maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrix, maxX, minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrix, minX, minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        try {
            this.gui.init(this.f_96543_, this.f_96544_);
        }
        catch (Throwable e) {
            this.onGuiException("Error in init gui", e, true);
        }
    }

    @Override
    public void drawText(int x, int y, String text, int color) {
        this.matrixStack.m_85836_();
        this.matrixStack.m_85837_(0.0, 0.0, 50.0);
        this.f_96547_.m_92883_(this.matrixStack, text, (float)(x += this.getOffset().x), (float)(y += this.getOffset().y), color);
        this.matrixStack.m_85849_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(keyCode, scanCode, '\uffff', GLFW.glfwGetKeyName((int)keyCode, (int)scanCode));
            this.gui.keyPressed(evt);
            if (!evt.isConsumed() && this.gui.enableChat() && this.f_96541_.f_91074_ != null && this.f_96541_.f_91066_.f_92098_.m_90832_(keyCode, scanCode) && this.f_96541_.f_91066_.f_92119_ != ChatVisiblity.HIDDEN) {
                RenderSystem.m_69879_(() -> {
                    int scale = this.vanillaScale;
                    this.vanillaScale = -1;
                    this.f_96541_.m_91152_((Screen)new Overlay());
                    this.vanillaScale = scale;
                });
                return true;
            }
            return true;
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(-1, -1, codePoint, null);
            this.gui.keyPressed(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseClick(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseDrag(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseRelease(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            try {
                MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, (int)delta);
                this.gui.mouseWheel(evt);
                return evt.isConsumed();
            }
            catch (Throwable e) {
                this.onGuiException("Error processing mouse event", e, false);
                return true;
            }
        }
        return false;
    }

    public void m_7400_(List<Path> filesIn) {
        try {
            this.gui.filesDropped(filesIn.stream().map(Path::toFile).filter(File::exists).collect(Collectors.toList()));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    @Override
    public void displayError(String e) {
        Screen p = this.parent;
        this.parent = null;
        Minecraft.m_91087_().m_91152_((Screen)new CrashScreen(e, p));
    }

    @Override
    public void closeGui() {
        if (this.closeListener != null) {
            this.closeListener.accept(this::m_7379_);
        } else {
            this.m_7379_();
        }
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("cpm", "textures/gui/" + texture + ".png"));
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        this.m_93228_(this.matrixStack, x, y, u, v, w, h);
        RenderSystem.m_69461_();
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture, int color) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("cpm", "textures/gui/" + texture + ".png"));
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        this.m_93228_(this.matrixStack, x, y, u, v, w, h);
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        RenderSystem.m_157456_((int)0, (ResourceLocation)MinecraftObject.DynTexture.getBoundLoc());
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float bo = this.m_93252_();
        Matrix4f matrix = this.matrixStack.m_85850_().m_85861_();
        bufferbuilder.m_85982_(matrix, (float)x, (float)(y + height), bo).m_7421_(u1, v2).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(x + width), (float)(y + height), bo).m_7421_(u2, v2).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(x + width), (float)y, bo).m_7421_(u2, v1).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x, (float)y, bo).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69461_();
    }

    @Override
    public String i18nFormat(String key, Object ... obj) {
        return I18n.m_118938_((String)key, (Object[])obj);
    }

    @Override
    public void setupCut() {
        if (!this.noScissorTest) {
            int dw = this.f_96541_.m_91268_().m_85441_();
            int dh = this.f_96541_.m_91268_().m_85442_();
            float multiplierX = (float)dw / (float)this.f_96543_;
            float multiplierY = (float)dh / (float)this.f_96544_;
            Box box = this.getContext().cutBox;
            RenderSystem.m_69488_((int)((int)((float)box.x * multiplierX)), (int)(dh - (int)((float)(box.y + box.h) * multiplierY)), (int)((int)((float)box.w * multiplierX)), (int)((int)((float)box.h * multiplierY)));
        }
    }

    @Override
    public int textWidth(String text) {
        return this.f_96547_.m_92895_(text);
    }

    private TextField.ITextField createTextField() {
        return new TxtField();
    }

    @Override
    public UIColors getColors() {
        return this.colors;
    }

    @Override
    public void setCloseListener(Consumer<Runnable> listener) {
        this.closeListener = listener;
    }

    @Override
    public boolean isShiftDown() {
        return GuiBase.m_96638_();
    }

    @Override
    public boolean isCtrlDown() {
        return GuiBase.m_96637_();
    }

    @Override
    public boolean isAltDown() {
        return GuiBase.m_96639_();
    }

    @Override
    public KeyCodes getKeyCodes() {
        return CODES;
    }

    @Override
    public void drawGradientBox(int x, int y, int w, int h, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        int left = x += this.getOffset().x;
        int top = y += this.getOffset().y;
        int right = x + w;
        int bottom = y + h;
        float atr = (float)(topRight >> 24 & 0xFF) / 255.0f;
        float rtr = (float)(topRight >> 16 & 0xFF) / 255.0f;
        float gtr = (float)(topRight >> 8 & 0xFF) / 255.0f;
        float btr = (float)(topRight & 0xFF) / 255.0f;
        float atl = (float)(topLeft >> 24 & 0xFF) / 255.0f;
        float rtl = (float)(topLeft >> 16 & 0xFF) / 255.0f;
        float gtl = (float)(topLeft >> 8 & 0xFF) / 255.0f;
        float btl = (float)(topLeft & 0xFF) / 255.0f;
        float abl = (float)(bottomLeft >> 24 & 0xFF) / 255.0f;
        float rbl = (float)(bottomLeft >> 16 & 0xFF) / 255.0f;
        float gbl = (float)(bottomLeft >> 8 & 0xFF) / 255.0f;
        float bbl = (float)(bottomLeft & 0xFF) / 255.0f;
        float abr = (float)(bottomRight >> 24 & 0xFF) / 255.0f;
        float rbr = (float)(bottomRight >> 16 & 0xFF) / 255.0f;
        float gbr = (float)(bottomRight >> 8 & 0xFF) / 255.0f;
        float bbr = (float)(bottomRight & 0xFF) / 255.0f;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        Matrix4f mat = this.matrixStack.m_85850_().m_85861_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(mat, (float)right, (float)top, (float)this.m_93252_()).m_85950_(rtr, gtr, btr, atr).m_5752_();
        bufferbuilder.m_85982_(mat, (float)left, (float)top, (float)this.m_93252_()).m_85950_(rtl, gtl, btl, atl).m_5752_();
        bufferbuilder.m_85982_(mat, (float)left, (float)bottom, (float)this.m_93252_()).m_85950_(rbl, gbl, bbl, abl).m_5752_();
        bufferbuilder.m_85982_(mat, (float)right, (float)bottom, (float)this.m_93252_()).m_85950_(rbr, gbr, bbr, abr).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    @Override
    public NativeGuiComponents getNative() {
        return nativeComponents;
    }

    @Override
    public void setClipboardText(String text) {
        this.f_96541_.f_91068_.m_90911_(text);
    }

    @Override
    public Frame getFrame() {
        return this.gui;
    }

    @Override
    public String getClipboardText() {
        return this.f_96541_.f_91068_.m_90876_();
    }

    @Override
    public void setScale(int value) {
        if (this.vanillaScale == -999) {
            return;
        }
        if (value != this.f_96541_.f_91066_.f_92072_) {
            if (this.vanillaScale == -1) {
                this.vanillaScale = this.f_96541_.f_91066_.f_92072_;
            }
            if (value == -1) {
                if (this.f_96541_.f_91066_.f_92072_ != this.vanillaScale) {
                    this.f_96541_.f_91066_.f_92072_ = this.vanillaScale;
                    this.vanillaScale = -1;
                    this.f_96541_.m_5741_();
                }
            } else {
                this.f_96541_.f_91066_.f_92072_ = value;
                this.f_96541_.m_5741_();
            }
        }
    }

    @Override
    public int getScale() {
        return this.f_96541_.f_91066_.f_92072_;
    }

    @Override
    public int getMaxScale() {
        return this.f_96541_.m_91268_().m_85385_(0, this.f_96541_.m_91390_()) + 1;
    }

    @Override
    public IGui.CtxStack getStack() {
        return this.stack;
    }

    public void m_96624_() {
        try {
            this.gui.tick();
        }
        catch (Throwable e) {
            this.onGuiException("Error in tick gui", e, true);
        }
    }

    @Override
    public void drawFormattedText(float x, float y, IText text, int color, float scale) {
        this.matrixStack.m_85836_();
        this.matrixStack.m_85837_((double)(x += (float)this.getOffset().x), (double)(y += (float)this.getOffset().y), 50.0);
        this.matrixStack.m_85841_(scale, scale, scale);
        this.f_96547_.m_92889_(this.matrixStack, (Component)text.remap(), 0.0f, 0.0f, color);
        this.matrixStack.m_85849_();
    }

    @Override
    public int textWidthFormatted(IText text) {
        return this.f_96547_.m_92724_(((Component)text.remap()).m_7532_());
    }

    @Override
    public void openURL0(String url) {
        Util.m_137581_().m_137646_(url);
    }

    public void onOpened() {
        this.vanillaScale = -1;
    }

    @Override
    public void drawStack(int x, int y, Stack stack) {
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        this.f_96542_.f_115093_ = 600.0f;
        this.f_96542_.m_174229_((LivingEntity)this.f_96541_.f_91074_, s, x += this.getOffset().x, y += this.getOffset().y, 0);
        this.f_96542_.m_115174_(this.f_96547_, s, x, y, null);
        this.f_96542_.f_115093_ = 0.0f;
    }

    @Override
    public void drawStackTooltip(int mx, int my, Stack stack) {
        this.matrixStack.m_85836_();
        this.matrixStack.m_85837_(0.0, 0.0, -300.0);
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        this.m_6057_(this.matrixStack, s, mx, my);
        this.matrixStack.m_85849_();
    }

    static {
        nativeComponents.register(TextField.class, GuiBase.local(GuiBase::createTextField));
        nativeComponents.register(FileChooserPopup.class, TinyFDChooser::new);
        nativeComponents.register(Panel3d.class, Panel3dImpl::new);
    }

    private static class CrashScreen
    extends Screen {
        private String error;
        private Screen parent;

        public CrashScreen(String error, Screen p) {
            super((Component)new TextComponent("Error"));
            this.error = error;
            this.parent = p;
        }

        public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.m_7333_(matrixStack);
            String[] txt = I18n.m_118938_((String)"error.cpm.crash", (Object[])new Object[]{this.error}).split("\\\\");
            for (int i = 0; i < txt.length; ++i) {
                CrashScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)txt[i], (int)(this.f_96543_ / 2), (int)(15 + i * 10), (int)0xFFFFFF);
            }
            super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }

        protected void m_7856_() {
            super.m_7856_();
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, 140, 200, 20, CommonComponents.f_130660_, p_213034_1_ -> this.f_96541_.m_91152_((Screen)null)));
        }

        public void m_7379_() {
            if (this.parent != null) {
                Screen p = this.parent;
                this.parent = null;
                this.f_96541_.m_91152_(p);
            }
        }
    }

    private class TxtField
    implements TextField.ITextField,
    Consumer<String> {
        private EditBox field;
        private Runnable eventListener;
        private Vec2i currentOff = new Vec2i(0, 0);
        private Box bounds = new Box(0, 0, 0, 0);
        private boolean settingText;
        private boolean updateField;
        private boolean enabled;

        public TxtField() {
            this.field = new EditBox(GuiBase.this.f_96547_, 0, 0, 0, 0, (Component)new TranslatableComponent("narrator.cpm.field"));
            this.field.m_94199_(0x100000);
            this.field.m_94182_(false);
            this.field.m_94194_(true);
            this.field.m_94202_(GuiBase.this.colors.label_text_color);
            this.field.m_94151_((Consumer)this);
            this.enabled = true;
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks, Box bounds) {
            Vec2i off = GuiBase.this.getOffset();
            this.field.f_93620_ = bounds.x + off.x + 4;
            this.field.f_93621_ = bounds.y + off.y + 6;
            this.currentOff.x = off.x;
            this.currentOff.y = off.y;
            this.bounds.x = bounds.x;
            this.bounds.y = bounds.y;
            this.bounds.w = bounds.w;
            this.bounds.h = bounds.h;
            this.field.m_93674_(bounds.w - 5);
            Platform.setHeight((AbstractWidget)this.field, bounds.h - 12);
            if (this.updateField) {
                this.settingText = true;
                this.field.m_94201_();
                this.settingText = false;
                this.updateField = false;
            }
            this.field.m_6305_(GuiBase.this.matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void keyPressed(KeyboardEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            if (evt.keyCode == -1) {
                if (this.field.m_5534_(evt.charTyped, GuiBase.this.keyModif)) {
                    evt.consume();
                }
            } else if (this.field.m_7933_(evt.keyCode, evt.scancode, GuiBase.this.keyModif) || this.field.m_94204_()) {
                evt.consume();
            }
        }

        @Override
        public void mouseClick(MouseEvent evt) {
            if (evt.isConsumed()) {
                this.field.m_6375_(-2.147483648E9, -2.147483648E9, evt.btn);
                return;
            }
            this.field.f_93620_ = this.bounds.x + this.currentOff.x;
            this.field.f_93621_ = this.bounds.y + this.currentOff.y;
            this.field.m_93674_(this.bounds.w);
            Platform.setHeight((AbstractWidget)this.field, this.bounds.h);
            if (this.field.m_6375_((double)(evt.x + this.currentOff.x), (double)(evt.y + this.currentOff.y), evt.btn)) {
                evt.consume();
            }
        }

        @Override
        public String getText() {
            return this.field.m_94155_();
        }

        @Override
        public void setText(String txt) {
            this.settingText = true;
            this.field.m_94144_(txt);
            this.settingText = false;
            this.updateField = true;
        }

        @Override
        public void setEventListener(Runnable eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public void accept(String value) {
            if (this.eventListener != null && !this.settingText && this.enabled) {
                this.eventListener.run();
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.field.m_94186_(enabled);
            this.enabled = enabled;
        }

        @Override
        public boolean isFocused() {
            return this.field.m_93696_();
        }

        @Override
        public void setFocused(boolean focused) {
            this.field.m_94178_(focused);
        }

        @Override
        public int getCursorPos() {
            return this.field.m_94207_();
        }

        @Override
        public void setCursorPos(int pos) {
            this.field.m_94196_(pos);
        }

        @Override
        public void setSelectionPos(int pos) {
            this.field.m_94208_(pos);
        }

        @Override
        public int getSelectionPos() {
            return this.field.f_94102_;
        }
    }

    public class Overlay
    extends ChatScreen {
        public Overlay() {
            super("");
        }

        public void m_6305_(PoseStack st, int mouseX, int mouseY, float partialTicks) {
            GuiBase.this.m_6305_(st, Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            super.m_6305_(st, mouseX, mouseY, partialTicks);
        }

        public Screen getGui() {
            return GuiBase.this;
        }
    }
}

