/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpm.shared.animation.AnimatedTexture;
import com.tom.cpm.shared.animation.AnimationTrigger;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.CopyTransform;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser;
import com.tom.cpm.shared.parts.anim.ParameterDetails;
import com.tom.cpm.shared.parts.anim.menu.AbstractGestureButtonData;
import com.tom.cpm.shared.parts.anim.menu.CommandAction;
import com.tom.cpm.shared.parts.anim.menu.CustomPoseGestureButtonData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnimationRegistry {
    private ParameterDetails params = ParameterDetails.DEFAULT;
    private List<AnimatedTexture> animatedTextures = new ArrayList<AnimatedTexture>();
    private List<AbstractGestureButtonData> namedActions = new ArrayList<AbstractGestureButtonData>();
    private Map<String, AbstractGestureButtonData> namedActionByKeybind = new HashMap<String, AbstractGestureButtonData>();
    private Map<String, CommandAction> commandActionsMap = new HashMap<String, CommandAction>();
    private Map<IPose, List<AnimationTrigger>> poseToTriggers = new HashMap<IPose, List<AnimationTrigger>>();
    private Set<AnimationTrigger> animations = new HashSet<AnimationTrigger>();
    private Map<Integer, IPose> poseById = new HashMap<Integer, IPose>();
    private Map<Integer, CustomPoseGestureButtonData> gestureById = new HashMap<Integer, CustomPoseGestureButtonData>();
    private Map<Integer, IPose> encodedToPose = new HashMap<Integer, IPose>();
    private Map<Integer, CustomPoseGestureButtonData> encodedToGesture = new HashMap<Integer, CustomPoseGestureButtonData>();
    private Map<String, CustomPose> customPoseByName = new HashMap<String, CustomPose>();
    private List<CopyTransform> copyTransforms = new ArrayList<CopyTransform>();
    private int blankGesture;
    private int poseResetId;
    private String profileId;
    private LegacyAnimationParser legacyParser;

    public Set<AnimationTrigger> getAnimations() {
        return this.animations;
    }

    public IPose getPoseEncoded(int gesture, IPose pose) {
        return this.encodedToPose.getOrDefault(gesture, pose);
    }

    public IPose getPoseById(int gesture, IPose pose) {
        return this.poseById.getOrDefault(gesture, pose);
    }

    public List<AnimationTrigger> getPoseAnimations(IPose id) {
        return this.poseToTriggers.getOrDefault(id, Collections.emptyList());
    }

    public CustomPoseGestureButtonData getGestureEncoded(int gesture) {
        return this.encodedToGesture.get(gesture);
    }

    public CustomPoseGestureButtonData getGestureById(int gesture) {
        return this.gestureById.get(gesture);
    }

    public Map<String, CustomPose> getCustomPoses() {
        return this.customPoseByName;
    }

    public int getBlankGesture() {
        return this.blankGesture;
    }

    public void setBlankGesture(int blankGesture) {
        this.blankGesture = blankGesture;
    }

    public void setPoseResetId(int poseResetId) {
        this.poseResetId = poseResetId;
    }

    public int getPoseResetId() {
        return this.poseResetId;
    }

    public void addAnimatedTexture(AnimatedTexture tex) {
        this.animatedTextures.add(tex);
    }

    public void tickAnimated(long time, boolean inGui) {
        for (int i = 0; i < this.animatedTextures.size(); ++i) {
            this.animatedTextures.get(i).update(time, inGui);
        }
    }

    public List<AbstractGestureButtonData> getNamedActions() {
        return this.namedActions;
    }

    public Map<String, CommandAction> getCommandActionsMap() {
        return this.commandActionsMap;
    }

    public Map<String, AbstractGestureButtonData> getNamedActionByKeybind() {
        return this.namedActionByKeybind;
    }

    public boolean hasPoseAnimations(VanillaPose pose) {
        return !this.getPoseAnimations(pose).isEmpty();
    }

    public void addCopy(CopyTransform ct) {
        this.copyTransforms.add(ct);
    }

    public void applyCopy() {
        this.copyTransforms.forEach(CopyTransform::apply);
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public void setParams(ParameterDetails params) {
        this.params = params;
    }

    public ParameterDetails getParams() {
        return this.params;
    }

    public void register(AbstractGestureButtonData btn) {
        btn.onRegistered();
        this.namedActions.add(btn);
        if (btn.getKeybindId() != null) {
            this.namedActionByKeybind.put(btn.getKeybindId(), btn);
        }
        btn.getCommandActions().forEach(c -> this.commandActionsMap.put(c.getName(), (CommandAction)c));
        if (btn instanceof CustomPoseGestureButtonData) {
            CustomPoseGestureButtonData b = (CustomPoseGestureButtonData)btn;
            if (b.isPose()) {
                CustomPose pose = new CustomPose(b.getName(), 0);
                if (b.layerCtrl) {
                    this.encodedToPose.put(b.gid, pose);
                }
                this.poseById.put(b.id, pose);
                this.customPoseByName.put(b.getName(), pose);
            } else {
                if (b.layerCtrl) {
                    this.encodedToGesture.put(b.gid, b);
                }
                this.gestureById.put(b.id, b);
            }
        }
    }

    public void register(AnimationTrigger trigger) {
        this.animations.add(trigger);
        trigger.onPoses.forEach(p -> this.poseToTriggers.computeIfAbsent((IPose)p, __ -> new ArrayList()).add(trigger));
    }

    public LegacyAnimationParser getLegacyParser(ModelDefinition def) {
        if (this.legacyParser == null) {
            this.legacyParser = new LegacyAnimationParser(def);
        }
        return this.legacyParser;
    }

    public void finishLoading() {
        if (this.legacyParser != null) {
            this.legacyParser.register();
        }
        this.legacyParser = null;
    }
}

