/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.config;

import com.google.common.collect.Iterables;
import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.shared.animation.ServerAnimationState;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.network.ModelEventType;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.network.NetworkUtil;
import com.tom.cpm.shared.parts.anim.menu.CommandAction;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.ScalingOptions;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlayerData {
    public long ticksSinceLogin;
    public byte[] data;
    public boolean forced;
    public boolean save;
    public final Map<ScalingOptions, Float> scale = new EnumMap<ScalingOptions, Float>(ScalingOptions.class);
    public final Map<ScalingOptions, Float> targetScale = new EnumMap<ScalingOptions, Float>(ScalingOptions.class);
    public final EnumSet<ModelEventType> eventSubs = EnumSet.noneOf(ModelEventType.class);
    public final EnumSet<ModelEventType> selfSubs = EnumSet.noneOf(ModelEventType.class);
    public byte[] gestureData = new byte[0];
    public Map<String, CommandAction.ServerCommandAction> animNames = new HashMap<String, CommandAction.ServerCommandAction>();
    public final Map<String, NBTTagCompound> pluginStates = new HashMap<String, NBTTagCompound>();
    public final ServerAnimationState state = new ServerAnimationState();

    public void setModel(byte[] data, boolean forced, boolean save) {
        this.data = data;
        this.forced = forced;
        this.save = save;
    }

    public void setModel(String data, boolean forced, boolean save) {
        this.data = data != null ? Base64.getDecoder().decode(data) : null;
        this.forced = forced;
        this.save = save;
    }

    public boolean canChangeModel() {
        return this.data == null || !this.forced;
    }

    public void load(String id) {
        ConfigEntry sc;
        ConfigEntry e = ModConfig.getWorldConfig().getEntry("skins").getEntry(id);
        boolean forced = e.getBoolean("forced", false);
        String b64 = e.getString("model", null);
        if (b64 != null) {
            this.setModel(b64, forced, true);
        }
        if ((sc = ModConfig.getWorldConfig().getEntry("player_scaling")).hasEntry(id)) {
            sc = sc.getEntry(id);
            for (ScalingOptions opt : ScalingOptions.VALUES) {
                float v = sc.getFloat(opt.getNetKey(), 1.0f);
                if (v == 1.0f) continue;
                this.scale.put(opt, Float.valueOf(v));
            }
        }
    }

    public void save(String id) {
        ConfigEntry e = ModConfig.getWorldConfig().getEntry("skins");
        if (this.save) {
            if (this.data == null) {
                e.clearValue(id);
            } else {
                e = e.getEntry(id);
                e.setString("model", Base64.getEncoder().encodeToString(this.data));
                e.setBoolean("forced", this.forced);
            }
        } else {
            e.clearValue(id);
        }
        ConfigEntry sc = ModConfig.getWorldConfig().getEntry("player_scaling").getEntry(id);
        sc.clear();
        this.scale.forEach((k, v) -> sc.setFloat(k.getNetKey(), v.floatValue()));
        ModConfig.getWorldConfig().save();
    }

    public <P> void rescale(NetHandler<?, P, ?> handler, P player) {
        EnumMap<ScalingOptions, Float> map = new EnumMap<ScalingOptions, Float>(this.scale);
        this.scale.clear();
        this.rescale(handler, player, map, null, false);
    }

    public <P> void rescaleToTarget(NetHandler<?, P, ?> handler, P player, List<ScalingOptions> blocked) {
        this.rescale(handler, player, this.targetScale, blocked, true);
    }

    public <P> void resetScale(NetHandler<?, P, ?> handler, P player) {
        this.rescale(handler, player, Collections.emptyMap(), null, true);
    }

    public <P> void rescale(NetHandler<?, P, ?> handler, P player, Map<ScalingOptions, Float> values, List<ScalingOptions> blocked) {
        this.rescale(handler, player, values, blocked, false);
    }

    private <P> void rescale(NetHandler<?, P, ?> handler, P player, Map<ScalingOptions, Float> values, List<ScalingOptions> blocked, boolean force) {
        String id = handler.getID(player);
        for (Map.Entry<ScalingOptions, Map<String, NetHandler.Scaler<P>>> e : handler.getScaleSetters().entrySet()) {
            Map<String, NetHandler.Scaler<P>> scl;
            NetHandler.Scaler<P> s;
            float selNewV;
            float oldV = this.scale.getOrDefault((Object)e.getKey(), Float.valueOf(1.0f)).floatValue();
            float newV = selNewV = values.getOrDefault((Object)e.getKey(), Float.valueOf(1.0f)).floatValue();
            NetworkUtil.ScalingSettings l = NetworkUtil.getScalingLimits(e.getKey(), id);
            String scaler = l.scaler;
            if (scaler == null) {
                scaler = (String)Iterables.getLast(e.getValue().keySet());
            }
            if ("disable".equals(scaler)) continue;
            float f = newV = newV == 0.0f ? 1.0f : MathHelper.clamp(newV, l.min, l.max);
            if ((newV != oldV || force) && (s = (scl = e.getValue()).get(scaler)) != null) {
                Log.debug("Scaling " + (Object)((Object)e.getKey()) + " " + oldV + " -> " + newV);
                s.applyScaling(player, newV);
                this.scale.put(e.getKey(), Float.valueOf(newV));
            }
            if (blocked == null || newV == selNewV || selNewV == 0.0f) continue;
            blocked.add(e.getKey());
        }
    }
}

