/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.definition;

import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.PartRoot;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.PlayerPartValues;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.RootModelElement;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.skin.TextureProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;

public class VanillaDefinition
extends ModelDefinition {
    private Supplier<TextureProvider> texture;
    private SkinType type;

    public VanillaDefinition(Supplier<TextureProvider> texture, SkinType type) {
        this.texture = texture;
        this.type = type;
        HashMap<Integer, RootModelElement> playerModelParts = new HashMap<Integer, RootModelElement>();
        for (int i2 = 0; i2 < PlayerModelParts.VALUES.length; ++i2) {
            RootModelElement elem = new RootModelElement(PlayerModelParts.VALUES[i2], this);
            playerModelParts.put(i2, elem);
            elem.reset();
        }
        this.cubes = new ArrayList();
        for (PlayerModelParts part : PlayerModelParts.VALUES) {
            if (part == PlayerModelParts.CUSTOM_PART) continue;
            RootModelElement elem = (RootModelElement)playerModelParts.get(part.ordinal());
            this.cubes.add(elem);
            elem.setHidden(true);
            Cube cube = new Cube();
            PlayerPartValues val = PlayerPartValues.getFor(part, type);
            cube.offset = val.getOffset();
            cube.rotation = new Vec3f(0.0f, 0.0f, 0.0f);
            cube.pos = new Vec3f(0.0f, 0.0f, 0.0f);
            cube.size = val.getSize();
            cube.meshScale = new Vec3f(1.0f, 1.0f, 1.0f);
            cube.scale = new Vec3f(1.0f, 1.0f, 1.0f);
            cube.u = val.u;
            cube.v = val.v;
            cube.texSize = 1;
            cube.id = 65520 + part.ordinal();
            RenderedCube rc = new RenderedCube(cube);
            rc.setParent(elem);
            elem.addChild(rc);
            this.cubes.add(rc);
            cube = new Cube();
            cube.offset = val.getOffset();
            cube.rotation = new Vec3f(0.0f, 0.0f, 0.0f);
            cube.pos = new Vec3f(0.0f, 0.0f, 0.0f);
            cube.size = val.getSize();
            cube.meshScale = new Vec3f(1.0f, 1.0f, 1.0f);
            cube.scale = new Vec3f(1.0f, 1.0f, 1.0f);
            cube.u = val.u2;
            cube.v = val.v2;
            cube.mcScale = 0.25f;
            cube.texSize = 1;
            cube.id = 65528 + part.ordinal();
            rc = new RenderedCube(cube);
            rc.setParent(elem);
            elem.addChild(rc);
            this.cubes.add(rc);
        }
        this.rootRenderingCubes = new HashMap();
        playerModelParts.forEach((i, e) -> this.rootRenderingCubes.put(PlayerModelParts.VALUES[i], new PartRoot((RootModelElement)e)));
    }

    @Override
    public TextureProvider getTexture(TextureSheetType key, boolean inGui) {
        if (key == TextureSheetType.SKIN) {
            return this.texture.get();
        }
        return null;
    }

    @Override
    public SkinType getSkinType() {
        return this.type;
    }
}

