/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec3i;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.gui.ModeDisplayType;
import com.tom.cpm.shared.editor.gui.TextureDisplay;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.tree.VecType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface MultiSelector
extends TreeElement {
    public boolean add(TreeElement var1);

    public void forEachSelected(Consumer<TreeElement> var1);

    @Override
    default public String getName() {
        return "";
    }

    public static class ElementImpl
    implements MultiSelector {
        private List<ModelElement> elements = new ArrayList<ModelElement>();
        private final Editor editor;

        public ElementImpl(Editor editor) {
            this.editor = editor;
        }

        private void addImpl(ModelElement modelElement) {
            if (this.elements.contains(modelElement)) {
                this.elements.remove(modelElement);
            } else {
                this.elements.add(modelElement);
            }
        }

        @Override
        public boolean isSelected(Editor e, TreeElement other) {
            return this.elements.contains(other);
        }

        public boolean allMatch(Predicate<ModelElement> test) {
            for (int i = 0; i < this.elements.size(); ++i) {
                ModelElement e = this.elements.get(i);
                if (test.test(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void updateGui() {
            if (this.elements.isEmpty()) {
                return;
            }
            if (this.allMatch(e -> e.type == ElementType.NORMAL)) {
                this.editor.setOffset.accept(this.getVec(VecType.OFFSET));
                if (this.allMatch(e -> e.itemRenderer == null)) {
                    if (this.allMatch(e -> e.texture)) {
                        if (this.allMatch(e -> e.faceUV == null)) {
                            this.editor.setModeBtn.accept(this.editor.ui.i18nFormat("button.cpm.mode.tex", new Object[0]));
                            this.editor.setModePanel.accept(ModeDisplayType.TEX);
                            this.editor.setTexturePanel.accept(this.getVecUV());
                        }
                    } else {
                        this.editor.setModeBtn.accept(this.editor.ui.i18nFormat("button.cpm.mode.color", new Object[0]));
                        this.editor.setModePanel.accept(ModeDisplayType.COLOR);
                        this.editor.setPartColor.accept(0);
                    }
                    double mc = this.elements.stream().mapToDouble(e -> e.mcScale).average().orElse(0.0);
                    this.editor.setMCScale.accept(Float.valueOf((float)mc));
                }
                this.editor.setDelEn.accept(true);
                ModelElement me = this.elements.get(0);
                this.editor.setHiddenEffect.accept(me.hidden);
                this.editor.setGlow.accept(me.glow);
                this.editor.setMirror.accept(me.mirror);
                this.editor.setSingleTex.accept(me.singleTex);
            }
            this.editor.setPosition.accept(this.getVec(VecType.POSITION));
            this.editor.setRot.accept(this.getVec(VecType.ROTATION));
        }

        @Override
        public void setElemColor(int color) {
            this.elements.forEach(e -> e.setElemColor(color));
        }

        @Override
        public void setVec(Vec3f v, VecType object) {
            if (object == VecType.TEXTURE) {
                Vec3i uv = this.getVecUV();
                float uOff = v.x - (float)uv.x;
                float vOff = v.y - (float)uv.y;
                this.elements.forEach(e -> e.setVec(new Vec3f((float)e.u + uOff, (float)e.v + vOff, e.textureSize), object));
            } else {
                Vec3f s = this.getVec(object);
                Vec3f off = v.sub(s);
                this.elements.forEach(e -> e.setVec(this.getVec((ModelElement)e, object).add(off), object));
            }
        }

        public Vec3f getVecAnim(Function<ModelElement, Vec3f> getter) {
            return this.elements.stream().map(getter).reduce(new Vec3f(), Vec3f::add).mul(1.0f / (float)this.elements.size());
        }

        public void setVecAnim(Vec3f v, Function<ModelElement, Vec3f> getter, BiConsumer<ModelElement, Vec3f> setter) {
            Vec3f s = this.elements.stream().map(getter).reduce(new Vec3f(), Vec3f::add).mul(1.0f / (float)this.elements.size());
            Vec3f off = v.sub(s);
            this.elements.forEach(e -> setter.accept((ModelElement)e, ((Vec3f)getter.apply((ModelElement)e)).add(off)));
        }

        @Override
        public void delete() {
            this.elements.forEach(ModelElement::delete);
        }

        @Override
        public void switchVis() {
            this.elements.forEach(ModelElement::switchVis);
        }

        @Override
        public void switchEffect(Effect effect) {
            this.elements.forEach(e -> e.switchEffect(effect));
        }

        @Override
        public void modeSwitch() {
            this.elements.forEach(ModelElement::modeSwitch);
        }

        @Override
        public void setMCScale(float scale) {
            float mc = (float)((double)scale - this.elements.stream().mapToDouble(e -> e.mcScale).average().orElse(0.0));
            this.elements.forEach(e -> e.setMCScale(e.mcScale + mc));
        }

        @Override
        public Vec3f getVec(VecType type) {
            if (type == VecType.TEXTURE) {
                Vec3i uv = this.getVecUV();
                return new Vec3f(uv.x, uv.y, uv.z);
            }
            return this.elements.stream().map(e -> this.getVec((ModelElement)e, type)).reduce(new Vec3f(), Vec3f::add).mul(1.0f / (float)this.elements.size());
        }

        public Vec3i getVecUV() {
            return this.elements.stream().map(e -> new Vec3i(e.u, e.v, e.textureSize)).reduce(new Vec3i(Integer.MAX_VALUE, Integer.MAX_VALUE, 256), (a, b) -> new Vec3i(Math.min(a.x, b.x), Math.min(a.y, b.y), Math.min(a.z, b.z)));
        }

        public Vec3f getVec(ModelElement e, VecType type) {
            switch (type) {
                case OFFSET: {
                    return e.offset;
                }
                case POSITION: {
                    return e.getPosition();
                }
                case ROTATION: {
                    return e.getRotation();
                }
                case MESH_SCALE: {
                    return e.meshScale;
                }
                case SIZE: {
                    return e.size;
                }
            }
            return null;
        }

        @Override
        public ETextures getTexture() {
            List texs = this.elements.stream().map(ModelElement::getTexture).distinct().collect(Collectors.toList());
            return texs.size() == 1 ? (ETextures)texs.get(0) : null;
        }

        @Override
        public Box getTextureBox() {
            return this.elements.stream().map(ModelElement::getTextureBox).filter(e -> e != null).reduce(null, (a, b) -> a == null ? b : (b == null ? a : a.union((Box)b)));
        }

        @Override
        public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
            this.elements.forEach(e -> TextureDisplay.drawBoxTextureOverlay(gui, e, x, y, xs, ys, TextureDisplay.getAlphaForBox(true)));
        }

        @Override
        public void setVecTemp(VecType object, Vec3f v) {
            if (object == VecType.TEXTURE) {
                Vec3i uv = this.getVecUV();
                float uOff = v.x - (float)uv.x;
                float vOff = v.y - (float)uv.y;
                this.elements.forEach(e -> e.setVecTemp(object, new Vec3f((float)e.u + uOff, (float)e.v + vOff, e.textureSize)));
            } else {
                Vec3f s = this.getVec(object);
                Vec3f off = v.sub(s);
                this.elements.forEach(e -> e.setVecTemp(object, this.getVec((ModelElement)e, object).add(off)));
            }
        }

        @Override
        public boolean add(TreeElement elem) {
            if (elem instanceof ModelElement) {
                this.addImpl((ModelElement)elem);
            }
            return this.elements.isEmpty();
        }

        @Override
        public void forEachSelected(Consumer<TreeElement> c) {
            this.elements.forEach(c);
        }

        public ModelElement getFirst() {
            return this.elements.get(0);
        }

        public boolean hasElements() {
            return !this.elements.isEmpty();
        }
    }
}

