/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Slider;
import com.tom.cpl.math.Box;

public class MouseControlsPanel
extends Panel {
    private final ConfigEntry ce;
    private Button buttonRMB;
    private Button buttonDMB;
    private Button buttonMMB;
    private Button buttonSMB;
    private Slider wheelS;

    public MouseControlsPanel(IGui gui, ConfigEntry ce) {
        super(gui);
        this.ce = ce;
        this.setBounds(new Box(5, 0, 250, 120));
        this.buttonRMB = new Button(gui, "", null);
        this.buttonDMB = new Button(gui, "", null);
        this.buttonMMB = new Button(gui, "", null);
        this.buttonSMB = new Button(gui, "", null);
        this.wheelS = new Slider(gui, "");
        this.buttonRMB.setAction(() -> {
            int b = ce.getSetInt("editorRotateMouseButton", 2) - 1;
            int d = ce.getSetInt("editorDragMouseButton", -1);
            if (b < 0) {
                b = 2;
            }
            if (b == d) {
                ce.setInt("editorDragMouseButton", -1);
            }
            ce.setInt("editorRotateMouseButton", b);
            this.updateMouseButtons();
        });
        this.buttonRMB.setBounds(new Box(0, 0, 250, 20));
        this.addElement(this.buttonRMB);
        this.buttonDMB.setAction(() -> {
            int b = ce.getSetInt("editorDragMouseButton", -1) - 1;
            int r = ce.getSetInt("editorRotateMouseButton", 2);
            if (b < -1) {
                b = 2;
            }
            if (b == r) {
                --b;
            }
            ce.setInt("editorDragMouseButton", b);
            this.updateMouseButtons();
        });
        this.buttonDMB.setBounds(new Box(0, 25, 250, 20));
        this.addElement(this.buttonDMB);
        this.buttonMMB.setAction(() -> {
            int b = ce.getSetInt("editorMenuMouseButton", 1) - 1;
            int r = ce.getSetInt("editorSelectMouseButton", 0);
            if (b < -1) {
                b = 2;
            }
            if (b == r) {
                --b;
            }
            ce.setInt("editorMenuMouseButton", b);
            this.updateMouseButtons();
        });
        this.buttonMMB.setBounds(new Box(0, 50, 250, 20));
        this.addElement(this.buttonMMB);
        this.buttonSMB.setAction(() -> {
            int b = ce.getSetInt("editorSelectMouseButton", 0) - 1;
            int d = ce.getSetInt("editorMenuMouseButton", 1);
            if (b < 0) {
                b = 2;
            }
            if (b == d) {
                ce.setInt("editorMenuMouseButton", -1);
            }
            ce.setInt("editorSelectMouseButton", b);
            this.updateMouseButtons();
        });
        this.buttonSMB.setBounds(new Box(0, 75, 250, 20));
        this.addElement(this.buttonSMB);
        this.wheelS.setAction(() -> {
            this.updateWheelS();
            ce.setInt("mouseWheelSensitivity", (int)((this.wheelS.getValue() * 3.75f + 0.25f) * 100.0f));
        });
        float wsv = (float)ce.getInt("mouseWheelSensitivity", 100) / 100.0f;
        this.wheelS.setValue((wsv - 0.5f) / 1.5f);
        this.wheelS.setBounds(new Box(0, 100, 250, 20));
        this.addElement(this.wheelS);
        this.updateMouseButtons();
        this.updateWheelS();
    }

    private void updateWheelS() {
        this.wheelS.setText(this.gui.i18nFormat("label.cpm.mouseWheelSensitivity", (int)((this.wheelS.getValue() * 3.75f + 0.25f) * 100.0f)));
    }

    private void updateMouseButtons() {
        this.buttonRMB.setText(this.gui.i18nFormat("button.cpm.config.rotateButton", this.getRotateBtn()));
        this.buttonDMB.setText(this.gui.i18nFormat("button.cpm.config.dragButton", this.getDragBtn()));
        this.buttonMMB.setText(this.gui.i18nFormat("button.cpm.config.menuButton", this.getMenuBtn()));
        this.buttonSMB.setText(this.gui.i18nFormat("button.cpm.config.selectButton", this.getSelectBtn()));
    }

    private String getRotateBtn() {
        return this.gui.i18nFormat("label.cpm.mouse." + this.ce.getInt("editorRotateMouseButton", 2), new Object[0]);
    }

    private String getDragBtn() {
        int d = this.ce.getInt("editorDragMouseButton", -1);
        if (d == -1) {
            return this.gui.i18nFormat("label.cpm.keybind.mod.shift", this.getRotateBtn());
        }
        return this.gui.i18nFormat("label.cpm.mouse." + d, new Object[0]);
    }

    private String getMenuBtn() {
        int d = this.ce.getInt("editorMenuMouseButton", -1);
        if (d == -1) {
            return this.gui.i18nFormat("label.cpm.keybind.mod.alt", this.getSelectBtn());
        }
        return this.gui.i18nFormat("label.cpm.mouse." + d, new Object[0]);
    }

    private String getSelectBtn() {
        return this.gui.i18nFormat("label.cpm.mouse." + this.ce.getInt("editorSelectMouseButton", 0), new Object[0]);
    }
}

