/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.builtin;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Quaternion;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.util.ItemSlot;

public interface IItemModel {
    public void render(MatrixStack var1, VertexBuffer var2, ItemSlot var3);

    public String getTexture();

    public static class ItemRenderTransform {
        public Vec3f translation;
        public Vec3f rotation;
        public Vec3f scale;

        public ItemRenderTransform(Vec3f translation, Vec3f rotation, Vec3f scale) {
            this.translation = translation;
            this.rotation = rotation;
            this.scale = scale;
        }

        public void apply(MatrixStack stack) {
            float f = this.rotation.x;
            float f1 = this.rotation.y;
            float f2 = this.rotation.z;
            stack.translate(this.translation.x / 16.0f, this.translation.y / 16.0f, this.translation.z / 16.0f);
            stack.rotate(new Quaternion(f, f1, f2, true));
            stack.scale(this.scale.x, -this.scale.y, -this.scale.z);
        }
    }
}

