/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.ModelPartType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ModelPartCubes
implements IModelPart,
IResolvedModelPart {
    private List<Cube> cubes;
    private List<RenderedCube> rc;

    public ModelPartCubes(IOHelper is, ModelDefinition def) throws IOException {
        int count = is.readVarInt();
        this.cubes = new ArrayList<Cube>(count);
        for (int i = 0; i < count; ++i) {
            Cube c = Cube.loadDefinitionCubeV2(is);
            c.id = i + 10;
            this.cubes.add(c);
        }
    }

    public ModelPartCubes(List<Cube> cubes) {
        this.cubes = cubes;
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        this.rc = Cube.resolveCubesV2(this.cubes);
        return this;
    }

    @Override
    public void preApply(ModelDefinition def) {
        def.addCubes(this.rc);
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        dout.writeVarInt(this.cubes.size());
        ArrayList<Cube> lst = new ArrayList<Cube>(this.cubes);
        lst.sort((a, b) -> Integer.compare(a.id, b.id));
        for (Cube cube : lst) {
            Cube.saveDefinitionCubeV2(dout, cube);
        }
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.CUBES;
    }
}

