/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpm.shared.config.ResourceLoader;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.template.Template;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.IOException;
import java.io.InputStreamReader;

public class ModelPartTemplate
implements IModelPart {
    private Link link;
    private IOHelper args;
    private ModelDefinition def;

    public ModelPartTemplate(IOHelper in, ModelDefinition def) throws IOException {
        this.link = new Link(in);
        this.args = in.readNextBlock();
        this.def = def;
    }

    public ModelPartTemplate(Template template) throws IOException {
        this.link = template.getLink();
        this.args = template.writeArgs();
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        try (InputStreamReader rd = new InputStreamReader(this.def.getLoader().load(this.link, ResourceLoader.ResourceEncoding.NO_ENCODING, this.def));){
            Template template = new Template(this.link, rd, null, this.args, this.def);
            ModelPartResolvedTemplate modelPartResolvedTemplate = new ModelPartResolvedTemplate(template);
            return modelPartResolvedTemplate;
        }
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        this.link.write(dout);
        this.args.writeBlock(dout);
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.TEMPLATE;
    }

    public class ModelPartResolvedTemplate
    implements IResolvedModelPart {
        private Template template;

        public ModelPartResolvedTemplate(Template template) {
            this.template = template;
        }

        @Override
        public void preApply(ModelDefinition def) {
            def.addCubes(this.template.getCubes());
        }

        @Override
        public void stitch(TextureStitcher stitcher) {
            if (!this.template.isTextureMerged()) {
                stitcher.stitchImage(this.template.getTemplateDefaultTexture(), this.template::onStitch);
            }
        }
    }
}

