/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpl.function.FloatUnaryOperator;
import com.tom.cpm.shared.animation.AnimationNew;
import com.tom.cpm.shared.animation.InterpolationInfo;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.parts.anim.AnimatorChannel;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class Float3Driver
implements AnimationNew.AnimationDriver {
    private FloatUnaryOperator x;
    private FloatUnaryOperator y;
    private FloatUnaryOperator z;
    private Float3Consumer setter;

    public Float3Driver(Float3Consumer f3, AnimatorChannel dx, AnimatorChannel dy, AnimatorChannel dz) {
        this.setter = f3;
        this.x = dx.frameData != null ? dx.frameData.createDriver(f3.getXInfo()) : __ -> f3.getX();
        this.y = dy.frameData != null ? dy.frameData.createDriver(f3.getYInfo()) : __ -> f3.getY();
        this.z = dz.frameData != null ? dz.frameData.createDriver(f3.getZInfo()) : __ -> f3.getZ();
    }

    @Override
    public void set(float value) {
        this.setter.set(this.x.apply(value), this.y.apply(value), this.z.apply(value));
    }

    public static <T> void make(Float3Consumer f3, T x, T y, T z, BiConsumer<T, AnimatorChannel> registerChn) {
        PartDriver d = new PartDriver(f3, "X");
        AnimatorChannel chX = new AnimatorChannel(d);
        AnimatorChannel chY = new AnimatorChannel(new PartDriver(f3, "Y"));
        AnimatorChannel chZ = new AnimatorChannel(new PartDriver(f3, "Z"));
        d.init = def -> {
            if (chX.frameData != null || chY.frameData != null || chZ.frameData != null) {
                d.fd = new Float3Driver(f3, chX, chY, chZ);
            }
        };
        registerChn.accept(x, chX);
        registerChn.accept(y, chY);
        registerChn.accept(z, chZ);
    }

    public static Float3Consumer getFromPart(AnimationNew.PartAnimationDriver p) {
        if (p instanceof PartDriver) {
            PartDriver pd = (PartDriver)p;
            return pd.f3;
        }
        return null;
    }

    public static interface Float3Consumer {
        public void set(float var1, float var2, float var3);

        public float getX();

        public float getY();

        public float getZ();

        public InterpolationInfo getXInfo();

        public InterpolationInfo getYInfo();

        public InterpolationInfo getZInfo();

        public void init(ModelDefinition var1);
    }

    private static class PartDriver
    implements AnimationNew.PartAnimationDriver {
        public Float3Consumer f3;
        public Float3Driver fd;
        public Consumer<ModelDefinition> init;
        public String chn;

        public PartDriver(Float3Consumer f3, String chn) {
            this.f3 = f3;
            this.chn = chn;
        }

        @Override
        public void set(float value) {
        }

        @Override
        public InterpolationInfo getInterpolationInfo() {
            return InterpolationInfo.NULL;
        }

        @Override
        public void init(ModelDefinition def) {
            if (this.init != null) {
                this.f3.init(def);
                this.init.accept(def);
                this.init = null;
            }
        }

        @Override
        public AnimationNew.AnimationDriver makeDriver(FloatUnaryOperator frameDriver) {
            return this.fd;
        }

        public String toString() {
            return "F3: " + this.chn + " " + this.f3.toString();
        }
    }
}

