/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.template.args;

import com.tom.cpl.math.MathHelper;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.template.args.ArgBase;
import java.io.IOException;

public class Float1Arg
extends ArgBase {
    private float value;

    @Override
    public String getType() {
        return "float1";
    }

    @Override
    public void write(IOHelper h) throws IOException {
        h.write(MathHelper.clamp((int)(this.value * 10.0f), 0, 255));
    }

    @Override
    public void load(IOHelper h) throws IOException {
        this.value = (float)h.read() / 10.0f;
    }

    @Override
    public Object toJson() {
        return Float.valueOf(this.value);
    }

    @Override
    public void fromJson(Object v) {
        this.value = ((Number)v).floatValue();
    }
}

