/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.tag.TagManager;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.util.ErrorLog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class CPMTagLoader
extends SimplePreparableReloadListener<Map<String, List<Map<String, Object>>>> {
    private final TagManager<?> tags;
    private final String prefix;

    public CPMTagLoader(Minecraft mc, TagManager<?> tags, String prefix) {
        this.tags = tags;
        this.prefix = prefix;
        ResourceManager mngr = mc.m_91098_();
        if (mngr != null) {
            this.init(mngr);
        } else {
            mc.m_6937_(() -> this.init(mc.m_91098_()));
        }
    }

    private void init(ResourceManager mngr) {
        this.tags.applyBuiltin(this.load(mngr), this.prefix);
        if (mngr instanceof ReloadableResourceManager) {
            ReloadableResourceManager r = (ReloadableResourceManager)mngr;
            r.m_7217_((PreparableReloadListener)this);
        }
    }

    protected Map<String, List<Map<String, Object>>> prepare(ResourceManager mngr, ProfilerFiller profiler) {
        return this.load(mngr);
    }

    protected void apply(Map<String, List<Map<String, Object>>> tagMap, ResourceManager mngr, ProfilerFiller profiler) {
        this.tags.applyBuiltin(tagMap, this.prefix);
    }

    private Map<String, List<Map<String, Object>>> load(ResourceManager mngr) {
        HashMap<String, List<Map<String, Object>>> el = new HashMap<String, List<Map<String, Object>>>();
        mngr.m_6540_("cpm_tags/" + this.prefix, l -> l.endsWith(".json")).forEach(rl -> {
            ArrayList<Map> res = new ArrayList<Map>();
            el.put(rl.m_135827_() + ":" + rl.m_135815_().substring(9, rl.m_135815_().length() - 5), res);
            try {
                Iterator iterator = mngr.m_7396_(rl).iterator();
                while (iterator.hasNext()) {
                    Resource r;
                    Resource iresource = r = (Resource)iterator.next();
                    try {
                        InputStream inputstream = iresource.m_6679_();
                        try (BufferedReader rd = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                            Map tag = (Map)MinecraftObjectHolder.gson.fromJson((Reader)rd, Object.class);
                            res.add(tag);
                        }
                        finally {
                            if (inputstream == null) continue;
                            inputstream.close();
                        }
                    }
                    finally {
                        if (iresource == null) continue;
                        iresource.close();
                    }
                }
            }
            catch (Exception e) {
                ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load cpm builtin tag: " + rl, e);
            }
        });
        return el;
    }
}

