/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.CommandDispatcher;
import com.tom.cpm.client.ClientBase;
import com.tom.cpm.client.GuiBase;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.common.Command;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.gui.GestureGui;
import com.tom.cpm.shared.gui.SettingsGui;
import com.tom.cpm.shared.util.Log;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.SkinCustomizationScreen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CustomPlayerModelsClient
extends ClientBase {
    public static final CustomPlayerModelsClient INSTANCE = new CustomPlayerModelsClient();

    public void init() {
        this.init0();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerShaders0);
        KeyBindings.init();
        this.init1();
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, scr) -> new GuiImpl(SettingsGui::new, (Screen)scr)));
    }

    @SubscribeEvent
    public void playerRenderPre(RenderPlayerEvent.Pre event) {
        this.playerRenderPre(event.getPlayer(), event.getMultiBufferSource(), (PlayerModel)event.getRenderer().m_7200_());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void playerRenderPreC(RenderPlayerEvent.Pre event) {
        if (event.isCanceled()) {
            this.playerRenderPost(event.getMultiBufferSource(), (PlayerModel)event.getRenderer().m_7200_());
        }
    }

    @SubscribeEvent
    public void playerRenderPost(RenderPlayerEvent.Post event) {
        this.playerRenderPost(event.getMultiBufferSource(), (PlayerModel)event.getRenderer().m_7200_());
    }

    @SubscribeEvent
    public void initGui(ScreenEvent.InitScreenEvent.Post evt) {
        if (evt.getScreen() instanceof TitleScreen && ModConfig.getCommonConfig().getSetBoolean("titleScreenButton", true) || evt.getScreen() instanceof SkinCustomizationScreen) {
            Button btn = new Button(0, 0, () -> Minecraft.m_91087_().m_91152_((Screen)new GuiImpl(EditorGui::new, evt.getScreen())));
            evt.addListener((GuiEventListener)btn);
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            mc.getPlayerRenderManager().getAnimationEngine().update(evt.renderTickTime);
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START && !this.minecraft.m_91104_()) {
            mc.getPlayerRenderManager().getAnimationEngine().tick();
        }
        if (this.minecraft.f_91074_ == null || evt.phase == TickEvent.Phase.START) {
            return;
        }
        if (KeyBindings.gestureMenuBinding.m_90859_()) {
            Minecraft.m_91087_().m_91152_((Screen)new GuiImpl(GestureGui::new, null));
        }
        if (KeyBindings.renderToggleBinding.m_90859_()) {
            Player.setEnableRendering(!Player.isEnableRendering());
        }
        mc.getPlayerRenderManager().getAnimationEngine().updateKeys(KeyBindings.quickAccess);
    }

    @SubscribeEvent
    public void openGui(ScreenOpenEvent openGui) {
        Screen screen;
        if (openGui.getScreen() == null && this.minecraft.f_91080_ instanceof GuiBase.Overlay) {
            openGui.setScreen(((GuiBase.Overlay)this.minecraft.f_91080_).getGui());
        }
        if (openGui.getScreen() instanceof TitleScreen && EditorGui.doOpenEditor()) {
            openGui.setScreen((Screen)new GuiImpl(EditorGui::new, openGui.getScreen()));
        }
        if ((screen = openGui.getScreen()) instanceof GuiImpl) {
            GuiImpl i = (GuiImpl)screen;
            i.onOpened();
        }
    }

    @SubscribeEvent
    public void drawGuiPre(ScreenEvent.DrawScreenEvent.Pre evt) {
        PlayerProfile.inGui = true;
    }

    @SubscribeEvent
    public void drawGuiPost(ScreenEvent.DrawScreenEvent.Post evt) {
        PlayerProfile.inGui = false;
    }

    private void registerShaders0(RegisterShadersEvent evt) {
        this.registerShaders((a, b, c) -> this.registerShader(evt, a, b, c));
    }

    private void registerShader(RegisterShadersEvent evt, String name, VertexFormat vertexFormat, Consumer<ShaderInstance> finish) {
        try {
            evt.registerShader(new ShaderInstance((ResourceProvider)evt.getResourceManager(), new ResourceLocation("cpm", name), vertexFormat), finish);
        }
        catch (IOException e) {
            Log.error("Failed to load cpm '" + name + "' shader", e);
        }
    }

    @SubscribeEvent
    public void onLogout(ClientPlayerNetworkEvent.LoggedOutEvent evt) {
        mc.onLogOut();
    }

    @SubscribeEvent
    public void registerClientCommands(RegisterClientCommandsEvent event) {
        new Command((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), true);
    }

    public static class Button
    extends net.minecraft.client.gui.components.Button {
        public Button(int x, int y, Runnable r) {
            super(x, y, 100, 20, (Component)new TranslatableComponent("button.cpm.open_editor"), b -> r.run());
        }
    }
}

