/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.text.FormatText;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.SidedHandler;
import com.tom.cpm.client.ClientNetworkImpl;
import com.tom.cpm.client.EmulNetwork;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.Lang;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.RetroGL;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.common.ServerNetworkImpl;
import com.tom.cpm.lefix.FixSSL;
import com.tom.cpm.retro.GameProfile;
import com.tom.cpm.retro.GameProfileManager;
import com.tom.cpm.retro.MCExecutor;
import com.tom.cpm.retro.NetHandlerExt;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.gui.GestureGui;
import com.tom.cpm.shared.model.RenderManager;
import com.tom.cpm.shared.model.TextureSheetType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.entity.MobRendererPlayer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class CustomPlayerModelsClient
implements ClientModInitializer,
SidedHandler {
    public static MinecraftObject mc;
    private Minecraft minecraft;
    public static CustomPlayerModelsClient INSTANCE;
    public RenderManager<GameProfile, Player, ModelBase, Void> manager;
    public static NetHandlerExt<String, Player, ClientNetworkImpl> netHandler;

    public void onInitializeClient() {
        FixSSL.fixup();
        INSTANCE = this;
        this.minecraft = Minecraft.INSTANCE;
        CustomPlayerModels.proxy = this;
        mc = new MinecraftObject(this.minecraft);
        this.manager = new RenderManager<GameProfile, Player, ModelBase, Void>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), e -> GameProfileManager.getProfile(e.username));
        netHandler.setExecutor(() -> MCExecutor.ex);
        netHandler.setSendPacketClient(ClientNetworkImpl::cpm$sendPacket);
        netHandler.setPlayerToLoader(e -> GameProfileManager.getProfile(e.username));
        netHandler.setGetPlayerById(id -> {
            Entity ent = EmulNetwork.getClient((Player)this.minecraft.thePlayer).cpm$getEntityByID(id);
            if (ent instanceof Player) {
                return (Player)ent;
            }
            return null;
        });
        netHandler.setGetClient(() -> this.minecraft.thePlayer);
        netHandler.setGetNet(EmulNetwork::getClient);
        netHandler.setDisplayText(f -> this.minecraft.hudIngame.addChatMessage((String)f.remap()));
        netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
        this.apiInit();
    }

    public void postInit() {
        KeyBindings.init();
        RetroGL.init();
    }

    public void apiInit() {
        CustomPlayerModels.api.buildClient().localModelApi(GameProfile::new).renderApi(ModelBase.class, GameProfile.class).init();
    }

    public void playerRenderPre(MobRendererPlayer renderer, Player entityPlayer, ModelBiped model) {
        this.manager.bindPlayer(entityPlayer, null, (ModelBase)model);
        this.manager.bindSkin((ModelBase)model, TextureSheetType.SKIN);
        this.manager.bindArmor((ModelBase)model, (ModelBase)renderer.modelArmorChestplate, 1);
        this.manager.bindArmor((ModelBase)model, (ModelBase)renderer.modelArmor, 2);
        this.manager.bindSkin((ModelBase)renderer.modelArmorChestplate, TextureSheetType.ARMOR1);
        this.manager.bindSkin((ModelBase)renderer.modelArmor, TextureSheetType.ARMOR2);
    }

    public void playerRenderPost(MobRendererPlayer renderer) {
        this.manager.unbind((ModelBase)renderer.modelArmor);
        this.manager.unbind((ModelBase)renderer.modelArmorChestplate);
        this.manager.unbindClear((ModelBase)renderer.modelBipedMain);
    }

    public void clientTickStart() {
        if (!this.minecraft.isGamePaused) {
            mc.getPlayerRenderManager().getAnimationEngine().tick();
            if (this.minecraft.thePlayer != null && this.minecraft.thePlayer.onGround && Keyboard.isKeyDown((int)this.minecraft.gameSettings.keyJump.getKeyCode())) {
                this.manager.jump((Player)this.minecraft.thePlayer);
            }
        }
    }

    public void clientTickEnd() {
        if (this.minecraft.thePlayer == null) {
            return;
        }
        if (this.minecraft.currentScreen == null) {
            if (KeyBindings.gestureMenuBinding.isPressed()) {
                this.minecraft.displayScreen((Screen)new GuiImpl(GestureGui::new, null));
            }
            if (KeyBindings.renderToggleBinding.isPressed()) {
                com.tom.cpm.shared.config.Player.setEnableRendering(!com.tom.cpm.shared.config.Player.isEnableRendering());
            }
            mc.getPlayerRenderManager().getAnimationEngine().updateKeys(KeyBindings.quickAccess);
        }
    }

    public void onRenderName(MobRenderer renderer, Player entity, double xIn, double yIn, double zIn) {
        GameProfile gp;
        FormatText st;
        if (com.tom.cpm.shared.config.Player.isEnableLoadingInfo() && (st = CustomPlayerModelsClient.INSTANCE.manager.getStatus(gp = GameProfileManager.getProfile(entity.username), "player")) != null) {
            float f = 1.6f;
            float f1 = 0.016666668f * f / 2.0f;
            double d3 = EntityRenderDispatcher.instance.camera.distanceToSqr(entity.x, entity.y, entity.z);
            if (d3 < 1024.0) {
                double y = yIn;
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)-0.15f, (double)0.0);
                String s = (String)st.remap();
                if (entity.isSneaking()) {
                    Font fontrenderer = this.minecraft.font;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((float)xIn + 0.0f), (float)((float)y + entity.bbHeight + 0.5f), (float)((float)zIn));
                    GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-EntityRenderDispatcher.instance.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)EntityRenderDispatcher.instance.viewLerpPitch, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
                    GL11.glDisable((int)2896);
                    GL11.glTranslatef((float)0.0f, (float)(0.25f / f1), (float)0.0f);
                    GL11.glDepthMask((boolean)false);
                    GL11.glEnable((int)3042);
                    RetroGL.glBlendFunc(770, 771, 1, 0);
                    Tessellator tessellator = Tessellator.instance;
                    GL11.glDisable((int)3553);
                    tessellator.startDrawingQuads();
                    int i = fontrenderer.getStringWidth(s) / 2;
                    tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
                    tessellator.addVertex((double)(-i - 1), -1.0, 0.0);
                    tessellator.addVertex((double)(-i - 1), 8.0, 0.0);
                    tessellator.addVertex((double)(i + 1), 8.0, 0.0);
                    tessellator.addVertex((double)(i + 1), -1.0, 0.0);
                    tessellator.draw();
                    GL11.glEnable((int)3553);
                    GL11.glDepthMask((boolean)true);
                    fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, 0, 0x20FFFFFF);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                } else {
                    this.renderLivingLabel((Mob)entity, xIn, y, zIn, s, f1, d3);
                }
                GL11.glPopMatrix();
            }
        }
    }

    protected void renderLivingLabel(Mob p_96449_1_, double p_96449_2_, double p_96449_4_, double p_96449_6_, String p_96449_8_, float p_96449_9_, double p_96449_10_) {
        if (p_96449_1_.isPlayerSleeping()) {
            this.renderLivingLabel0((Entity)p_96449_1_, p_96449_8_, p_96449_2_, p_96449_4_ - 1.5, p_96449_6_, 64);
        } else {
            this.renderLivingLabel0((Entity)p_96449_1_, p_96449_8_, p_96449_2_, p_96449_4_, p_96449_6_, 64);
        }
    }

    protected void renderLivingLabel0(Entity p_147906_1_, String p_147906_2_, double p_147906_3_, double p_147906_5_, double p_147906_7_, int p_147906_9_) {
        double d3 = EntityRenderDispatcher.instance.camera.distanceToSqr(p_147906_1_.x, p_147906_1_.y, p_147906_1_.z);
        if (d3 <= (double)(p_147906_9_ * p_147906_9_)) {
            Font fontrenderer = this.minecraft.font;
            float f = 1.6f;
            float f1 = 0.016666668f * f / 2.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)p_147906_3_ + 0.0f), (float)((float)p_147906_5_ + p_147906_1_.bbHeight + 0.5f), (float)((float)p_147906_7_));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-EntityRenderDispatcher.instance.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)EntityRenderDispatcher.instance.viewLerpPitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            RetroGL.glBlendFunc(770, 771, 1, 0);
            Tessellator tessellator = Tessellator.instance;
            int b0 = 0;
            if (p_147906_2_.equals("deadmau5")) {
                b0 = -10;
            }
            GL11.glDisable((int)3553);
            tessellator.startDrawingQuads();
            int j = fontrenderer.getStringWidth(p_147906_2_) / 2;
            tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
            tessellator.addVertex((double)(-j - 1), (double)(-1 + b0), 0.0);
            tessellator.addVertex((double)(-j - 1), (double)(8 + b0), 0.0);
            tessellator.addVertex((double)(j + 1), (double)(8 + b0), 0.0);
            tessellator.addVertex((double)(j + 1), (double)(-1 + b0), 0.0);
            tessellator.draw();
            GL11.glEnable((int)3553);
            fontrenderer.drawString(p_147906_2_, -fontrenderer.getStringWidth(p_147906_2_) / 2, b0, 0x20FFFFFF);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            fontrenderer.drawString(p_147906_2_, -fontrenderer.getStringWidth(p_147906_2_) / 2, b0, -1);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public void onLogout() {
        mc.onLogOut();
    }

    public static void renderCape(Player player, float partialTick, ModelBiped model, ModelDefinition modelDefinition) {
        float f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
        if (player != null) {
            float yawOff = player.yBodyRotO + (player.yBodyRot - player.yBodyRotO) * partialTick;
            float bodyAngle = 5.0f;
            if (player.isSneaking()) {
                bodyAngle += 25.0f;
            }
            double _xd = player.vehicle instanceof Entity ? ((Entity)player.vehicle).xd : MathHelper.lerp((double)player.xdO, (double)player.xd, (double)partialTick);
            double _yd = Math.min(player.vehicle instanceof Entity ? ((Entity)player.vehicle).yd : MathHelper.lerp((double)player.ydO, (double)player.yd, (double)partialTick), 0.0);
            double _zd = player.vehicle instanceof Entity ? ((Entity)player.vehicle).zd : MathHelper.lerp((double)player.zd0, (double)player.zd, (double)partialTick);
            double vel = -1.0 / (3.0 * Math.hypot(_xd, _zd) + 1.0) + 1.0;
            double moveAng = Math.atan2(_xd, _zd);
            double yawRad = Math.toRadians(yawOff);
            double multiplier = 1.0 - Math.abs((Math.cos(yawRad) + 1.0 - (Math.cos(moveAng) + 1.0) + 2.0) / 2.0 - 1.0);
            player.wobbleTimer += (float)((double)((float)player.tickCount + partialTick - (float)player.lastRenderTick) / (30.0 - 29.0 * MathHelper.clamp((double)vel, (double)0.0, (double)1.0)));
            player.lastRenderTick = player.tickCount;
            double wobble = Math.sin(player.wobbleTimer) * (1.5 + 4.5 * vel * multiplier);
            f = (float)MathHelper.clamp((double)(MathHelper.clamp((double)((double)bodyAngle + vel * 100.0 * multiplier), (double)bodyAngle, (double)100.0) + wobble - _yd * 60.0), (double)0.0, (double)180.0);
        } else {
            f = 0.0f;
        }
        model.cloak.xRot = (float)(-Math.toRadians(f));
        model.cloak.yRot = (float)Math.toRadians(180.0);
        model.cloak.zRot = 0.0f;
        mc.getPlayerRenderManager().setModelPose(model);
        model.cloak.xRot = 0.0f;
        model.cloak.yRot = 0.0f;
        model.cloak.zRot = 0.0f;
        model.renderCloak(0.0625f);
        GL11.glPopMatrix();
    }

    public static SidedHandler makeProxy() {
        return new CustomPlayerModelsClient();
    }

    @Override
    public void getTracking(Player player, Consumer<Player> f) {
    }

    @Override
    public Set<Player> getTrackingPlayers(Entity entity) {
        return Collections.emptySet();
    }

    @Override
    public List<Player> getPlayersOnline() {
        return Collections.singletonList(this.minecraft.thePlayer);
    }

    @Override
    public ServerNetworkImpl getServer(Player pl) {
        return EmulNetwork.emulServer;
    }

    static {
        netHandler = new NetHandlerExt((a, b) -> a + ":" + b);
    }

    public static class Button
    extends ButtonElement {
        public Button(int x, int y) {
            super(99, x, y, 100, 20, Lang.format("button.cpm.open_editor", new Object[0]));
        }
    }
}

