/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.item.Stack;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpl.util.AWTChooser;
import com.tom.cpm.client.LWJGLKeyCodes;
import com.tom.cpm.client.Lang;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.Panel3dImpl;
import com.tom.cpm.client.RetroGL;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.gui.panel.Panel3d;
import com.tom.cpm.shared.util.Log;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.chat.ScreenChat;
import net.minecraft.client.input.InputType;
import net.minecraft.client.option.enums.DescriptionPromptEnum;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.util.debug.DebugRender;
import net.minecraft.core.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiImpl
extends Screen
implements IGui {
    private static final KeyCodes CODES = new LWJGLKeyCodes();
    private static final NativeGuiComponents nativeComponents = new NativeGuiComponents();
    private Frame gui;
    private Screen parent;
    private IGui.CtxStack stack;
    private UIColors colors;
    private Consumer<Runnable> closeListener;
    private int vanillaScale = -1;
    private TooltipElement tooltipElement;
    private ItemElement itemElement;
    private int eventButton = 0;
    private long dragStart = 0L;

    public GuiImpl(Function<IGui, Frame> creator, Screen parent) {
        Minecraft mc = Minecraft.getMinecraft();
        this.colors = new UIColors();
        this.parent = parent;
        this.tooltipElement = new TooltipElement(mc);
        this.itemElement = new ItemElement(mc);
        try {
            this.gui = creator.apply(this);
        }
        catch (Throwable e) {
            this.onGuiException("Error creating gui", e, true);
        }
    }

    private static <G extends Supplier<IGui>, N> NativeGuiComponents.NativeConstructor<G, N> local(Function<GuiImpl, N> fac) {
        return f -> fac.apply((GuiImpl)f.get());
    }

    public boolean isPauseScreen() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        try {
            GL11.glEnable((int)3089);
            this.stack = new IGui.CtxStack(this.width, this.height);
            this.gui.draw(mouseX, mouseY, partialTicks);
        }
        catch (Throwable e) {
            this.onGuiException("Error drawing gui", e, true);
        }
        finally {
            GL11.glDisable((int)3089);
            String s = "Minecraft " + Minecraft.VERSION + " " + MinecraftCommonAccess.get().getModVersion();
            this.font.drawString(s, this.width - this.font.getStringWidth(s) - 4, 2, -16777216);
            s = this.mc.debugFPS;
            this.font.drawString(s, this.width - this.font.getStringWidth(s) - 4, 11, -16777216);
        }
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.vanillaScale != -1 && this.vanillaScale != (Integer)this.mc.gameSettings.guiScale.value) {
            this.mc.gameSettings.guiScale.set((Object)this.vanillaScale);
        }
        if (this.parent != null) {
            Screen p = this.parent;
            this.parent = null;
            this.mc.displayScreen(p);
        }
    }

    @Override
    public void drawBox(int x, int y, int w, int h, int color) {
        this.drawRect(x += this.getOffset().x, y += this.getOffset().y, x + w, y + h, color);
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        try {
            this.gui.init(this.width, this.height);
        }
        catch (Throwable e) {
            this.onGuiException("Error in init gui", e, true);
        }
    }

    @Override
    public void drawText(int x, int y, String text, int color) {
        this.font.drawString(text, x += this.getOffset().x, y += this.getOffset().y, color);
    }

    public void keyPressed(char typedChar, int keyCode, int mouseX, int mouseY) {
        try {
            KeyboardEvent evt = new KeyboardEvent(keyCode, 0, typedChar, keyCode == -1 ? null : Keyboard.getKeyName((int)keyCode));
            this.gui.keyPressed(evt);
            if (!evt.isConsumed() && this.mc.thePlayer != null && this.mc.gameSettings.keyChat.getKeyCode() == keyCode) {
                this.mc.displayScreen((Screen)new Overlay());
            }
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        try {
            this.gui.mouseClick(new MouseEvent(mouseX, mouseY, mouseButton));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    protected void func_85041_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        try {
            this.gui.mouseDrag(new MouseEvent(mouseX, mouseY, clickedMouseButton));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    protected void mouseMovedOrUp(int mouseX, int mouseY, int state) {
        if (state == -1) {
            return;
        }
        try {
            this.gui.mouseRelease(new MouseEvent(mouseX, mouseY, state));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    public void updateEvents() {
        int mouseX = Mouse.getEventX() * this.width / this.mc.resolution.getWidthScreenCoords();
        int mouseY = this.height - Mouse.getEventY() * this.height / this.mc.resolution.getHeightScreenCoords() - 1;
        while (Mouse.next() && this.mc.inputType != InputType.CONTROLLER) {
            if (Mouse.getEventButtonState()) {
                this.eventButton = Mouse.getEventButton();
                this.dragStart = System.currentTimeMillis();
                this.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
                continue;
            }
            if (Mouse.getEventButton() != -1) {
                this.eventButton = -1;
                this.mouseMovedOrUp(mouseX, mouseY, Mouse.getEventButton());
                continue;
            }
            if (this.eventButton == -1 || this.dragStart <= 0L) continue;
            long var3 = System.currentTimeMillis() - this.dragStart;
            this.func_85041_a(mouseX, mouseY, this.eventButton, var3);
        }
        while (Keyboard.next()) {
            if (Keyboard.getEventKeyState() && ((Boolean)this.mc.gameSettings.showFrameTimes.value).booleanValue() && DebugRender.keyPressed((int)Keyboard.getEventKey())) continue;
            int eventKey = Keyboard.getEventKey();
            char eventChar = Keyboard.getEventCharacter();
            if (eventKey == 0 && Character.isDefined(eventChar)) {
                this.keyPressed(eventChar, eventKey, mouseX, mouseY);
            }
            if (!Keyboard.getEventKeyState()) continue;
            if (eventKey == 87) {
                this.mc.gameWindow.toggleFullscreen();
                return;
            }
            this.keyPressed(eventChar, eventKey, mouseX, mouseY);
        }
        int i = Mouse.getEventDWheel();
        if (i > 0) {
            i = 1;
        }
        if (i < 0) {
            i = -1;
        }
        if (i != 0) {
            try {
                this.gui.mouseWheel(new MouseEvent(mouseX, mouseY, i));
            }
            catch (Throwable e) {
                this.onGuiException("Error processing mouse event", e, false);
            }
        }
    }

    @Override
    public void displayError(final String e) {
        final Screen p = this.parent;
        this.parent = null;
        this.mc.displayScreen(new Screen(){
            private Screen parent;
            private String message1;
            private String message2;
            {
                this.parent = p;
                this.message1 = "Custom Player Models";
                this.message2 = Lang.format("error.cpm.crash", e);
            }

            public void init() {
                super.init();
                this.buttons.add(new ButtonElement(0, this.width / 2 - 100, 140, Lang.format("gui.cancel", new Object[0])));
            }

            public void keyPressed(char c, int key, int mouseX, int mouseY) {
            }

            public void render(int par1, int par2, float par3) {
                this.drawGradientRect(0, 0, this.width, this.height, -12574688, -11530224);
                this.drawStringCentered(this.font, this.message1, this.width / 2, 90, 0xFFFFFF);
                this.drawStringCentered(this.font, this.message2, this.width / 2, 110, 0xFFFFFF);
                super.render(par1, par2, par3);
            }

            public void removed() {
                if (this.parent != null) {
                    Screen p2 = this.parent;
                    this.parent = null;
                    this.mc.displayScreen(p2);
                }
            }

            protected void buttonClicked(ButtonElement button) {
                this.mc.displayScreen((Screen)null);
            }
        });
    }

    @Override
    public void closeGui() {
        if (this.closeListener != null) {
            this.closeListener.accept(() -> this.mc.displayScreen((Screen)null));
        } else {
            this.mc.displayScreen((Screen)null);
        }
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture) {
        this.mc.textureManager.bindTexture(this.mc.textureManager.loadTexture("/assets/cpm/textures/gui/" + texture + ".png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(x += this.getOffset().x, y += this.getOffset().y, u, v, w, h);
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture, int color) {
        this.mc.textureManager.bindTexture(this.mc.textureManager.loadTexture("/assets/cpm/textures/gui/" + texture + ".png"));
        x += this.getOffset().x;
        y += this.getOffset().y;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        this.drawTexturedModalRect(x, y, u, v, w, h);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (MinecraftObject.Texture.bound != null) {
            MinecraftObject.Texture.bound.getMcTex().bind();
        }
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.addVertexWithUV((double)x, (double)(y + height), 0.0, (double)u1, (double)v2);
        t.addVertexWithUV((double)(x + width), (double)(y + height), 0.0, (double)u2, (double)v2);
        t.addVertexWithUV((double)(x + width), (double)y, 0.0, (double)u2, (double)v1);
        t.addVertexWithUV((double)x, (double)y, 0.0, (double)u1, (double)v1);
        t.draw();
    }

    @Override
    public String i18nFormat(String key, Object ... obj) {
        return Lang.format(key, obj);
    }

    @Override
    public void setupCut() {
        float multiplierX = (float)this.mc.resolution.getWidthScreenCoords() / (float)this.width;
        float multiplierY = (float)this.mc.resolution.getHeightScreenCoords() / (float)this.height;
        Box box = this.getContext().cutBox;
        GL11.glScissor((int)((int)((float)box.x * multiplierX)), (int)(this.mc.resolution.getHeightScreenCoords() - (int)((float)(box.y + box.h) * multiplierY)), (int)((int)((float)box.w * multiplierX)), (int)((int)((float)box.h * multiplierY)));
    }

    @Override
    public int textWidth(String text) {
        return this.font.getStringWidth(text);
    }

    private TextField.ITextField createTextField() {
        return new TxtField();
    }

    @Override
    public UIColors getColors() {
        return this.colors;
    }

    @Override
    public void setCloseListener(Consumer<Runnable> listener) {
        this.closeListener = listener;
    }

    @Override
    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    public boolean isCtrlDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    @Override
    public boolean isAltDown() {
        return false;
    }

    @Override
    public KeyCodes getKeyCodes() {
        return CODES;
    }

    @Override
    public void drawGradientBox(int x, int y, int w, int h, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        int left = x;
        int top = y;
        int right = x + w;
        int bottom = y + h;
        float atr = (float)(topRight >> 24 & 0xFF) / 255.0f;
        float rtr = (float)(topRight >> 16 & 0xFF) / 255.0f;
        float gtr = (float)(topRight >> 8 & 0xFF) / 255.0f;
        float btr = (float)(topRight & 0xFF) / 255.0f;
        float atl = (float)(topLeft >> 24 & 0xFF) / 255.0f;
        float rtl = (float)(topLeft >> 16 & 0xFF) / 255.0f;
        float gtl = (float)(topLeft >> 8 & 0xFF) / 255.0f;
        float btl = (float)(topLeft & 0xFF) / 255.0f;
        float abl = (float)(bottomLeft >> 24 & 0xFF) / 255.0f;
        float rbl = (float)(bottomLeft >> 16 & 0xFF) / 255.0f;
        float gbl = (float)(bottomLeft >> 8 & 0xFF) / 255.0f;
        float bbl = (float)(bottomLeft & 0xFF) / 255.0f;
        float abr = (float)(bottomRight >> 24 & 0xFF) / 255.0f;
        float rbr = (float)(bottomRight >> 16 & 0xFF) / 255.0f;
        float gbr = (float)(bottomRight >> 8 & 0xFF) / 255.0f;
        float bbr = (float)(bottomRight & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        RetroGL.glBlendFunc(770, 771, 1, 0);
        GL11.glShadeModel((int)7425);
        RetroGL.RetroTessellator t = RetroGL.tessellator;
        t.begin(7);
        t.pos(right, top, this.zLevel).color(rtr, gtr, btr, atr, false).endVertex();
        t.pos(left, top, this.zLevel).color(rtl, gtl, btl, atl, false).endVertex();
        t.pos(left, bottom, this.zLevel).color(rbl, gbl, bbl, abl, false).endVertex();
        t.pos(right, bottom, this.zLevel).color(rbr, gbr, bbr, abr, false).endVertex();
        t.draw();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    @Override
    public NativeGuiComponents getNative() {
        return nativeComponents;
    }

    @Override
    public void setClipboardText(String text) {
        try {
            StringSelection var1 = new StringSelection(text);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(var1, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Frame getFrame() {
        return this.gui;
    }

    @Override
    public String getClipboardText() {
        try {
            Transferable trans = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (trans != null && trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)trans.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void setScale(int value) {
        if (this.vanillaScale == -999) {
            return;
        }
        if (value != (Integer)this.mc.gameSettings.guiScale.value) {
            if (this.vanillaScale == -1) {
                this.vanillaScale = (Integer)this.mc.gameSettings.guiScale.value;
            }
            if (value == -1) {
                if ((Integer)this.mc.gameSettings.guiScale.value != this.vanillaScale) {
                    this.mc.gameSettings.guiScale.set((Object)this.vanillaScale);
                    this.vanillaScale = -1;
                    this.mc.gameSettings.guiScale.onUpdate();
                }
            } else {
                this.mc.gameSettings.guiScale.set((Object)value);
                this.mc.gameSettings.guiScale.onUpdate();
            }
        }
    }

    @Override
    public int getScale() {
        return (Integer)this.mc.gameSettings.guiScale.value;
    }

    @Override
    public int getMaxScale() {
        return 4;
    }

    @Override
    public IGui.CtxStack getStack() {
        return this.stack;
    }

    public void tick() {
        try {
            this.gui.tick();
        }
        catch (Throwable e) {
            this.onGuiException("Error in tick gui", e, true);
        }
    }

    @Override
    public void drawFormattedText(float x, float y, IText text, int color, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x += (float)this.getOffset().x), (float)(y += (float)this.getOffset().y), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.font.drawString((String)text.remap(), 0, 0, color);
        GL11.glPopMatrix();
    }

    @Override
    public int textWidthFormatted(IText text) {
        return this.font.getStringWidth((String)text.remap());
    }

    @Override
    public void openURL0(String url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(url));
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            Log.error("Couldn't open link: " + (throwable == null ? "<UNKNOWN>" : throwable.getMessage()));
        }
    }

    public void onOpened() {
        this.vanillaScale = -1;
    }

    @Override
    public void drawStack(int x, int y, Stack stack) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        try {
            this.itemElement.render(s, x, y);
        }
        catch (Exception e) {
            Log.error("Error rendering item in GUI: " + s.getItemKey(), e);
        }
    }

    @Override
    public void drawStackTooltip(int mx, int my, Stack stack) {
        boolean showDescription;
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        String str = this.tooltipElement.getTooltipText(s, showDescription = DescriptionPromptEnum.showDescription((Minecraft)this.mc), null);
        if (str.length() > 0) {
            this.tooltipElement.render(str, mx, my, 8, -8);
        }
    }

    static {
        nativeComponents.register(TextField.class, GuiImpl.local(GuiImpl::createTextField));
        nativeComponents.register(FileChooserPopup.class, AWTChooser::new);
        nativeComponents.register(Panel3d.class, Panel3dImpl::new);
    }

    public class Overlay
    extends ScreenChat {
        public void render(int mouseX, int mouseY, float partialTicks) {
            GuiImpl.this.render(Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            super.render(mouseX, mouseY, partialTicks);
        }

        public Screen getGui() {
            return GuiImpl.this;
        }
    }

    private class TxtField
    implements TextField.ITextField {
        private TextFieldElement field;
        private Runnable eventListener;
        private Vec2i currentOff = new Vec2i(0, 0);
        private Box bounds = new Box(0, 0, 0, 0);
        private boolean refreshTextBox;

        public TxtField() {
            this.field = new TextFieldElement((Screen)GuiImpl.this, GuiImpl.this.font, 0, 0, 0, 0, "", "");
            this.field.setMaxStringLength(0x100000);
            this.field.drawBackground = false;
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks, Box bounds) {
            Vec2i off = GuiImpl.this.getOffset();
            this.field.xPosition = bounds.x + off.x + 4;
            this.field.yPosition = bounds.y + off.y + 6;
            this.currentOff.x = off.x;
            this.currentOff.y = off.y;
            this.bounds.x = bounds.x;
            this.bounds.y = bounds.y;
            this.bounds.w = bounds.w;
            this.bounds.h = bounds.h;
            this.field.width = bounds.w - 5;
            this.field.height = bounds.h - 12;
            if (this.refreshTextBox) {
                this.refreshTextBox = false;
            }
            this.field.drawTextBox();
        }

        @Override
        public void keyPressed(KeyboardEvent e) {
            if (e.isConsumed()) {
                return;
            }
            String text = this.field.getText();
            if (this.field.isEnabled && this.field.isFocused) {
                if (e.charTyped == '\t') {
                    return;
                }
                this.field.textboxKeyTyped(e.charTyped, e.keyCode);
                e.consume();
                if (this.eventListener != null && !text.equals(this.field.getText())) {
                    this.eventListener.run();
                }
            }
        }

        @Override
        public void mouseClick(MouseEvent e) {
            if (e.isConsumed()) {
                this.field.mouseClicked(Integer.MIN_VALUE, Integer.MIN_VALUE, e.btn);
                return;
            }
            this.field.xPosition = this.bounds.x + this.currentOff.x;
            this.field.yPosition = this.bounds.y + this.currentOff.y;
            this.field.width = this.bounds.w;
            this.field.height = this.bounds.h;
            this.field.mouseClicked(e.x + this.currentOff.x, e.y + this.currentOff.y, e.btn);
            if (this.bounds.isInBounds(e.x, e.y)) {
                e.consume();
            }
        }

        @Override
        public String getText() {
            return this.field.getText();
        }

        @Override
        public void setText(String txt) {
            this.field.setText(txt);
            this.refreshTextBox = true;
        }

        @Override
        public void setEventListener(Runnable eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.field.isEnabled = enabled;
        }

        @Override
        public boolean isFocused() {
            return this.field.isFocused;
        }

        @Override
        public void setFocused(boolean focused) {
            this.field.setFocused(focused);
        }

        @Override
        public int getCursorPos() {
            return 0;
        }

        @Override
        public void setCursorPos(int pos) {
        }

        @Override
        public void setSelectionPos(int pos) {
        }

        @Override
        public int getSelectionPos() {
            return 0;
        }
    }
}

