/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.gui.KeyboardEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.options.components.KeyBindingComponent;
import net.minecraft.client.gui.options.components.OptionsCategory;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.input.InputDevice;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.KeyBinding;

public class KeyBindings
implements IKeybind {
    public static KeyBinding gestureMenuBinding;
    public static KeyBinding renderToggleBinding;
    public static IKeybind[] quickAccess;
    private static OptionsCategory cpmBinds;
    public static List<IKeybind> kbs;
    private final KeyBinding kb;
    private final String name;

    public static void init() {
        cpmBinds = new OptionsCategory("key.cpm.category");
        gestureMenuBinding = new KeyBinding("key.cpm.gestureMenu").setDefault(InputDevice.keyboard, 34);
        kbs.add(new KeyBindings(gestureMenuBinding, "gestureMenu"));
        renderToggleBinding = new KeyBinding("key.cpm.renderToggle");
        kbs.add(new KeyBindings(renderToggleBinding, "renderToggle"));
        for (int i = 1; i <= 16; ++i) {
            KeyBindings.createQA(i);
        }
        kbs.forEach(e -> GameSettings.keys.add(((KeyBindings)e).kb));
        OptionsPages.CONTROLS.withComponent((OptionsComponent)cpmBinds);
    }

    private static void createQA(int id) {
        KeyBinding kb = new KeyBinding("key.cpm.qa_" + id);
        KeyBindings kbs = new KeyBindings(kb, "qa_" + id);
        KeyBindings.kbs.add(kbs);
        KeyBindings.quickAccess[id - 1] = kbs;
    }

    private KeyBindings(KeyBinding kb, String name) {
        this.kb = kb;
        this.name = name;
        cpmBinds.withComponent((OptionsComponent)new KeyBindingComponent(kb));
    }

    @Override
    public boolean isPressed(KeyboardEvent evt) {
        return this.kb.getKeyCode() == evt.keyCode;
    }

    @Override
    public String getBoundKey() {
        return this.kb.getKeyName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPressed() {
        return this.kb.isPressed();
    }

    static {
        quickAccess = new IKeybind[16];
        kbs = new ArrayList<IKeybind>();
    }
}

