/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.block.BiomeHandler;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.render.RenderTypeBuilder;
import com.tom.cpl.tag.AllTagManagers;
import com.tom.cpl.util.AWTImageIO;
import com.tom.cpl.util.DynamicTexture;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import com.tom.cpm.client.CPMTagLoader;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.EmulNetwork;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.PlayerRenderManager;
import com.tom.cpm.client.RetroGL;
import com.tom.cpm.common.BiomeHandlerImpl;
import com.tom.cpm.retro.GameProfile;
import com.tom.cpm.retro.GameProfileManager;
import com.tom.cpm.retro.MCExecutor;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.retro.RetroGLAccess;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.MojangAPI;
import java.io.File;
import java.lang.reflect.Field;
import java.net.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocalMultiplayer;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenSelectWorld;
import net.minecraft.core.entity.player.Player;

public class MinecraftObject
implements MinecraftClientAccess {
    private final Minecraft mc;
    private final PlayerRenderManager prm;
    private final AllTagManagers tags;
    private final ModelDefinitionLoader<GameProfile> loader;
    private final RenderTypeBuilder<net.minecraft.client.render.texture.Texture, RetroGLAccess.RetroLayer> renderBuilder = RenderTypeBuilder.setupRetro(new RetroGL());

    public MinecraftObject(Minecraft mc) {
        this.mc = mc;
        MinecraftObjectHolder.setClientObject(this);
        this.loader = new ModelDefinitionLoader<GameProfile>(PlayerProfile::new, GameProfile::getId, GameProfile::getName);
        this.prm = new PlayerRenderManager();
        this.tags = new AllTagManagers(null, CPMTagLoader::new);
    }

    @Override
    public PlayerRenderManager getPlayerRenderManager() {
        return this.prm;
    }

    @Override
    public DynamicTexture.ITexture createTexture() {
        return new Texture();
    }

    @Override
    public void executeOnGameThread(Runnable r) {
        MCExecutor.addScheduledTask(r);
    }

    @Override
    public void executeNextFrame(Runnable r) {
        MCExecutor.tell(r);
    }

    @Override
    public ModelDefinitionLoader<GameProfile> getDefinitionLoader() {
        return this.loader;
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.DEFAULT;
    }

    @Override
    public void setEncodedGesture(int value) {
        CustomPlayerModelsClient.netHandler.sendLayer(value);
    }

    @Override
    public boolean isInGame() {
        return this.mc.thePlayer != null;
    }

    @Override
    public Object getPlayerIDObject() {
        return GameProfileManager.getProfile(this.mc.session.username);
    }

    @Override
    public Object getCurrentPlayerIDObject() {
        return this.mc.thePlayer != null ? GameProfileManager.getProfile(this.mc.thePlayer.username) : null;
    }

    @Override
    public List<IKeybind> getKeybinds() {
        return KeyBindings.kbs;
    }

    @Override
    public MinecraftClientAccess.ServerStatus getServerSideStatus() {
        return this.isInGame() ? (this.getNetHandler().hasModClient() ? MinecraftClientAccess.ServerStatus.INSTALLED : MinecraftClientAccess.ServerStatus.UNAVAILABLE) : MinecraftClientAccess.ServerStatus.OFFLINE;
    }

    @Override
    public File getGameDir() {
        return Minecraft.INSTANCE.getMinecraftDir();
    }

    @Override
    public void openGui(Function<IGui, Frame> creator) {
        this.mc.displayScreen((Screen)new GuiImpl(creator, this.mc.currentScreen));
    }

    @Override
    public Runnable openSingleplayer() {
        return () -> this.mc.displayScreen((Screen)new ScreenSelectWorld(this.mc.currentScreen));
    }

    @Override
    public NetHandler<?, ?, ?> getNetHandler() {
        return CustomPlayerModelsClient.netHandler;
    }

    @Override
    public ImageIO.IImageIO getImageIO() {
        return new AWTImageIO();
    }

    @Override
    public MojangAPI getMojangAPI() {
        GameProfile gp = GameProfileManager.getProfile(this.mc.session.username);
        return new MojangAPI(gp.getName(), gp.getId(), this.mc.session.sessionId);
    }

    @Override
    public void clearSkinCache() {
        GameProfileManager.clear();
        try {
            Class<?> earsLegacy = Class.forName("com.unascribed.ears.legacy.LegacyHelper");
            Field f = earsLegacy.getDeclaredField("skinUrls");
            f.setAccessible(true);
            ((Map)f.get(null)).clear();
            f = earsLegacy.getDeclaredField("cache");
            f.setAccessible(true);
            ((Map)f.get(null)).clear();
            Log.info("Cleared Ears Cache");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getConnectedServer() {
        if (this.mc.thePlayer == null) {
            return null;
        }
        return EmulNetwork.getClient((Player)this.mc.thePlayer).cpm$getConnectedServer();
    }

    @Override
    public List<Object> getPlayers() {
        Stream<String> players;
        if (this.mc.thePlayer == null) {
            return Collections.emptyList();
        }
        if (this.mc.thePlayer instanceof PlayerLocalMultiplayer) {
            PlayerLocalMultiplayer mp = (PlayerLocalMultiplayer)this.mc.thePlayer;
            players = mp.sendQueue.players.stream().map(e -> e.playerName);
        } else {
            players = Stream.of(this.mc.thePlayer.username);
        }
        return players.map(e -> GameProfileManager.getProfile(e)).collect(Collectors.toList());
    }

    @Override
    public Proxy getProxy() {
        return Proxy.NO_PROXY;
    }

    @Override
    public RenderTypeBuilder<?, ?> getRenderBuilder() {
        return this.renderBuilder;
    }

    @Override
    public AllTagManagers getBuiltinTags() {
        return this.tags;
    }

    @Override
    public BiomeHandler<?> getBiomeHandler() {
        return BiomeHandlerImpl.impl;
    }

    public static class Texture
    implements DynamicTexture.ITexture {
        public static Texture bound;
        private net.minecraft.client.render.texture.Texture mcTex = new net.minecraft.client.render.texture.Texture(){

            protected void finalize() throws Throwable {
                if (this.isGenerated()) {
                    MCExecutor.addScheduledTask(() -> (this).delete());
                }
            }
        };

        public Texture() {
            this.mcTex.generate();
        }

        @Override
        public void bind() {
            bound = this;
        }

        @Override
        public void load(Image image) {
            this.mcTex.setupTexture(AWTImageIO.toBufferedImage(image));
        }

        @Override
        public void free() {
            this.mcTex.delete();
        }

        public net.minecraft.client.render.texture.Texture getMcTex() {
            return this.mcTex;
        }
    }
}

