/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.util.Hand;
import com.tom.cpm.common.EntityTypeHandlerImpl;
import com.tom.cpm.common.PlayerInventory;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.retro.GameProfile;
import com.tom.cpm.retro.GameProfileManager;
import com.tom.cpm.retro.NetHandlerExt;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.core.entity.Entity;

public class PlayerProfile
extends Player<net.minecraft.core.entity.player.Player>
implements NetHandlerExt.IPlayerProfile {
    public static boolean inGui;
    private final GameProfile profile;
    public int encGesture;

    public PlayerProfile(GameProfile profile) {
        this.profile = new GameProfile(profile.getId(), profile.getName());
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.DEFAULT;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)obj;
        return !(this.profile == null ? other.profile != null : !this.profile.equals(other.profile));
    }

    @Override
    protected PlayerTextureLoader initTextures() {
        return new PlayerTextureLoader(){

            @Override
            protected CompletableFuture<Void> load0() {
                return GameProfileManager.getProfileFuture(PlayerProfile.this.profile.getName()).thenAccept(gp -> this.defineAll(gp.getTextureURLMap(), f -> f));
            }
        };
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    @Override
    public void updateFromPlayer(net.minecraft.core.entity.player.Player player) {
        this.animState.resetPlayer();
        if (player.isPlayerSleeping()) {
            this.animState.sleeping = true;
        }
        if (!player.isAlive()) {
            this.animState.dying = true;
        }
        if (player.vehicle != null) {
            this.animState.riding = true;
        }
        if (player.isSneaking()) {
            this.animState.sneaking = true;
        }
        if (player.isSprinting()) {
            this.animState.sprinting = true;
        }
        if (player.isInWater()) {
            this.animState.retroSwimming = true;
        }
        this.animState.moveAmountX = this.round(player.x - player.xo);
        this.animState.moveAmountY = this.round(player.y - player.yo);
        this.animState.moveAmountZ = this.round(player.z - player.zo);
        this.animState.yaw = player.yRot * 2.0f - player.yBodyRot;
        this.animState.pitch = player.xRot;
        this.animState.bodyYaw = player.yBodyRot;
        this.animState.encodedState = this.encGesture;
        this.animState.wearingHelm = player.inventory.armorInventory[3] != null;
        this.animState.wearingBody = player.inventory.armorInventory[2] != null;
        this.animState.wearingLegs = player.inventory.armorInventory[1] != null;
        this.animState.wearingBoots = player.inventory.armorInventory[0] != null;
        this.animState.activeHand = this.animState.mainHand = Hand.RIGHT;
        this.animState.hurtTime = player.hurtTime;
        this.animState.isOnLadder = player.canClimb();
        this.animState.isBurning = player.isOnFire();
        this.animState.inGui = inGui;
        PlayerInventory.setInv(this.animState, player.inventory);
        WorldImpl.setWorld(this.animState, (Entity)player);
        if (player.vehicle != null) {
            this.animState.vehicle = EntityTypeHandlerImpl.impl.wrap(player.vehicle.getClass());
        }
    }

    private float round(double d) {
        return Math.abs(d) < 0.01 ? 0.0f : (float)d;
    }

    @Override
    public void updateFromModel(Object model) {
        if (model instanceof ModelBiped) {
            ModelBiped m = (ModelBiped)model;
            this.animState.resetModel();
            this.animState.attackTime = m.onGround;
            this.animState.leftArm = PlayerModelSetup.ArmPose.EMPTY;
            if (m.holdingRightHand) {
                this.animState.rightArm = PlayerModelSetup.ArmPose.ITEM;
            }
            if (m.holdingLeftHand) {
                this.animState.leftArm = PlayerModelSetup.ArmPose.ITEM;
            }
        }
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public Object getGameProfile() {
        return this.profile;
    }

    @Override
    public void setEncGesture(int g) {
        this.encGesture = g;
    }
}

