/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.client.RetroGL;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.retro.RedirectHolderRetro;
import java.util.function.Supplier;
import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.model.ModelPlayer;
import org.lwjgl.opengl.GL11;

public class PlayerRenderManager
extends ModelRenderManager<Void, Void, Cube, ModelBase> {
    private static final float scale = 0.0625f;

    public PlayerRenderManager() {
        this.setFactory(new ModelRenderManager.RedirectHolderFactory<Void, Void, Cube>(){

            @Override
            public <M> ModelRenderManager.RedirectHolder<?, Void, Void, Cube> create(M model, String arg) {
                if (model instanceof ModelBiped) {
                    if ("armor1".equals(arg)) {
                        return new RedirectHolderArmor1(PlayerRenderManager.this, (ModelBiped)model);
                    }
                    if ("armor2".equals(arg)) {
                        return new RedirectHolderArmor2(PlayerRenderManager.this, (ModelBiped)model);
                    }
                    return new RedirectHolderPlayer(PlayerRenderManager.this, (ModelBiped)model);
                }
                return null;
            }
        });
        this.setRedirectFactory(new ModelRenderManager.RedirectRendererFactory<ModelBase, Void, Cube>(){

            @Override
            public ModelRenderManager.RedirectRenderer<Cube> create(ModelBase model, ModelRenderManager.RedirectHolder<ModelBase, ?, Void, Cube> access, Supplier<Cube> modelPart, VanillaModelPart part) {
                return new RedirectModelPart((RDH)access, modelPart, part);
            }
        });
        this.setVis(m -> m.visible, (m, v) -> {
            m.visible = v;
        });
        this.setModelPosGetters(m -> m.x, m -> m.y, m -> m.z);
        this.setModelRotGetters(m -> m.xRot, m -> m.yRot, m -> m.zRot);
        this.setModelSetters((m, x, y, z) -> {
            m.x = x;
            m.y = y;
            m.z = z;
        }, (m, x, y, z) -> {
            m.xRot = x;
            m.yRot = y;
            m.zRot = z;
        });
        this.setRenderPart(new Cube(0, 0));
    }

    public static void multiplyStacks(MatrixStack.Entry e) {
        e.getMatrix().multiplyNative(GL11::glMultMatrixf);
    }

    private static class RedirectModelPart
    extends Cube
    implements ModelRenderManager.RedirectRenderer<Cube> {
        private final RDH holder;
        private final VanillaModelPart part;
        private final Supplier<Cube> parentProvider;
        private Cube parent;
        private VBuffers buffers;

        public RedirectModelPart(RDH holder, Supplier<Cube> parent, VanillaModelPart part) {
            super(0, 0);
            this.holder = holder;
            this.parentProvider = parent;
            this.part = part;
        }

        public void render(float scale) {
            this.buffers = new VBuffers(RetroGL::buffer);
            this.render();
            this.buffers.finishAll();
        }

        @Override
        public Cube swapIn() {
            if (this.parent != null) {
                return this;
            }
            this.parent = this.parentProvider.get();
            RedirectModelPart.copyModel(this.parent, this);
            return this;
        }

        @Override
        public Cube swapOut() {
            if (this.parent == null) {
                return this.parentProvider.get();
            }
            Cube p = this.parent;
            this.parent = null;
            return p;
        }

        private static void copyModel(Cube s, Cube d) {
            d.x = s.x;
            d.y = s.y;
            d.z = s.z;
            d.xRot = s.xRot;
            d.yRot = s.yRot;
            d.zRot = s.zRot;
            d.visible = s.visible;
        }

        @Override
        public ModelRenderManager.RedirectHolder<?, ?, ?, Cube> getHolder() {
            return this.holder;
        }

        @Override
        public Cube getParent() {
            return this.parent;
        }

        @Override
        public VanillaModelPart getPart() {
            return this.part;
        }

        @Override
        public void renderParent() {
            this.parent.render(0.0625f);
        }

        @Override
        public VBuffers getVBuffers() {
            return this.buffers;
        }

        @Override
        public Vec4f getColor() {
            return RetroGL.getColor();
        }

        public void translateTo(float scale) {
            MatrixStack.Entry e = this.getPartTransform();
            if (e != null) {
                PlayerRenderManager.multiplyStacks(e);
            } else if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
                GL11.glTranslatef((float)(this.x * scale), (float)(this.y * scale), (float)(this.z * scale));
                if (this.zRot != 0.0f) {
                    GL11.glRotatef((float)(this.zRot * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.yRot != 0.0f) {
                    GL11.glRotatef((float)(this.yRot * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.xRot != 0.0f) {
                    GL11.glRotatef((float)(this.xRot * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            } else if (this.x != 0.0f || this.y != 0.0f || this.z != 0.0f) {
                GL11.glTranslatef((float)(this.x * scale), (float)(this.y * scale), (float)(this.z * scale));
            }
        }
    }

    private static abstract class RDH
    extends RedirectHolderRetro<ModelBase, Cube> {
        public RDH(ModelRenderManager<Void, Void, Cube, ModelBase> mngr, ModelBase model) {
            super(mngr, model);
        }
    }

    private static class RedirectHolderArmor2
    extends RDH {
        public RedirectHolderArmor2(PlayerRenderManager mngr, ModelBiped model) {
            super(mngr, (ModelBase)model);
            this.register(new ModelRenderManager.Field<Cube>(() -> model.body, v -> {
                model.body = v;
            }, RootModelType.ARMOR_LEGGINGS_BODY));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.legRight, v -> {
                model.legRight = v;
            }, RootModelType.ARMOR_RIGHT_LEG));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.legLeft, v -> {
                model.legLeft = v;
            }, RootModelType.ARMOR_LEFT_LEG));
        }
    }

    private static class RedirectHolderArmor1
    extends RDH {
        public RedirectHolderArmor1(PlayerRenderManager mngr, ModelBiped model) {
            super(mngr, (ModelBase)model);
            this.register(new ModelRenderManager.Field<Cube>(() -> model.head, v -> {
                model.head = v;
            }, RootModelType.ARMOR_HELMET));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.body, v -> {
                model.body = v;
            }, RootModelType.ARMOR_BODY));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.armRight, v -> {
                model.armRight = v;
            }, RootModelType.ARMOR_RIGHT_ARM));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.armLeft, v -> {
                model.armLeft = v;
            }, RootModelType.ARMOR_LEFT_ARM));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.legRight, v -> {
                model.legRight = v;
            }, RootModelType.ARMOR_RIGHT_FOOT));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.legLeft, v -> {
                model.legLeft = v;
            }, RootModelType.ARMOR_LEFT_FOOT));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.hair, v -> {
                model.hair = v;
            }, null));
        }
    }

    private static class RedirectHolderPlayer
    extends RDH {
        private ModelRenderManager.RedirectRenderer<Cube> head = this.registerHead(new ModelRenderManager.Field<Cube>(() -> model.head, v -> {
            model.head = v;
        }, PlayerModelParts.HEAD));

        public RedirectHolderPlayer(PlayerRenderManager mngr, ModelBiped model) {
            super(mngr, (ModelBase)model);
            this.register(new ModelRenderManager.Field<Cube>(() -> model.body, v -> {
                model.body = v;
            }, PlayerModelParts.BODY));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.armRight, v -> {
                model.armRight = v;
            }, PlayerModelParts.RIGHT_ARM));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.armLeft, v -> {
                model.armLeft = v;
            }, PlayerModelParts.LEFT_ARM));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.legRight, v -> {
                model.legRight = v;
            }, PlayerModelParts.RIGHT_LEG));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.legLeft, v -> {
                model.legLeft = v;
            }, PlayerModelParts.LEFT_LEG));
            this.register(new ModelRenderManager.Field<Cube>(() -> model.hair, v -> {
                model.hair = v;
            }, null)).setCopyFrom(this.head);
            this.register(new ModelRenderManager.Field<Cube>(() -> model.cloak, v -> {
                model.cloak = v;
            }, RootModelType.CAPE));
            if (model instanceof ModelPlayer) {
                ModelPlayer p = (ModelPlayer)model;
                this.register(new ModelRenderManager.Field<Cube>(() -> p.bipedLeftArmOverlay, v -> {
                    p.bipedLeftArmOverlay = v;
                }, null));
                this.register(new ModelRenderManager.Field<Cube>(() -> p.bipedRightArmOverlay, v -> {
                    p.bipedRightArmOverlay = v;
                }, null));
                this.register(new ModelRenderManager.Field<Cube>(() -> p.bipedLeftLegOverlay, v -> {
                    p.bipedLeftLegOverlay = v;
                }, null));
                this.register(new ModelRenderManager.Field<Cube>(() -> p.bipedRightLegOverlay, v -> {
                    p.bipedRightLegOverlay = v;
                }, null));
                this.register(new ModelRenderManager.Field<Cube>(() -> p.bipedBodyOverlay, v -> {
                    p.bipedBodyOverlay = v;
                }, null));
            }
        }
    }
}

