/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.DirectBuffer;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.shared.retro.RetroGLAccess;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.Texture;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTBlendFuncSeparate;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GLContext;

public class RetroGL
implements RetroGLAccess<Texture> {
    public static RetroTessellator tessellator;
    public static int renderCallLoc;
    public static final int HURT_OVERLAY_LOC = 3;
    private static final RenderStage lines;
    private static final RenderStage color;
    private static float red;
    private static float green;
    private static float blue;
    private static float alpha;
    private static float lred;
    private static float lgreen;
    private static float lblue;
    private static boolean blendExt;
    private static boolean openGL14;

    public RenderStage texture(Texture tex) {
        return new RenderStage(true, true, true, true, () -> {
            RetroGL.bindTex(tex);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }, () -> {}, 7);
    }

    public RenderStage eyes(Texture tex) {
        return new RenderStage(true, true, true, false, () -> {
            if (renderCallLoc == 3) {
                return;
            }
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)1);
            RetroGL.bindTex(tex);
        }, () -> {
            if (renderCallLoc == 3) {
                return;
            }
            RetroGL.glBlendFunc(770, 771, 1, 0);
            GL11.glEnable((int)3008);
        }, 7);
    }

    @Override
    public RenderStage linesNoDepth() {
        return lines;
    }

    @Override
    public RenderStage color() {
        return color;
    }

    private static void bindTex(Texture tex) {
        if (tex != null) {
            tex.bind();
        }
    }

    public static VertexBuffer buffer(VBuffers.NativeRenderType type) {
        RenderStage stage = (RenderStage)type.getNativeType();
        return new RetroBuffer(tessellator, stage);
    }

    public static Vec4f getColor() {
        return new Vec4f(red, green, blue, alpha);
    }

    public static void color4f(float r, float g, float b, float a) {
        red = r;
        green = g;
        blue = b;
        alpha = a;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public static void lightColor4f(float r, float g, float b, float a) {
        lred = r;
        lgreen = g;
        lblue = b;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        RetroGL.resetColor();
    }

    public static void lightColor3f(float r, float g, float b) {
        lred = r;
        lgreen = g;
        lblue = b;
        GL11.glColor3f((float)r, (float)g, (float)b);
        RetroGL.resetColor();
    }

    public static void resetColor() {
        red = 1.0f;
        green = 1.0f;
        blue = 1.0f;
        alpha = 1.0f;
    }

    public static void resetLightColor() {
        lred = 1.0f;
        lgreen = 1.0f;
        lblue = 1.0f;
        RetroGL.resetColor();
    }

    @Override
    public Texture getDynTexture() {
        return MinecraftObject.Texture.bound != null ? MinecraftObject.Texture.bound.getMcTex() : null;
    }

    public static void init() {
        ContextCapabilities contextcapabilities = GLContext.getCapabilities();
        blendExt = contextcapabilities.GL_EXT_blend_func_separate && !contextcapabilities.OpenGL14;
        openGL14 = contextcapabilities.OpenGL14 || contextcapabilities.GL_EXT_blend_func_separate;
        tessellator = new RetroTessellator(Tessellator.instance);
    }

    public static void glBlendFunc(int p_148821_0_, int p_148821_1_, int p_148821_2_, int p_148821_3_) {
        if (openGL14) {
            if (blendExt) {
                EXTBlendFuncSeparate.glBlendFuncSeparateEXT((int)p_148821_0_, (int)p_148821_1_, (int)p_148821_2_, (int)p_148821_3_);
            } else {
                GL14.glBlendFuncSeparate((int)p_148821_0_, (int)p_148821_1_, (int)p_148821_2_, (int)p_148821_3_);
            }
        } else {
            GL11.glBlendFunc((int)p_148821_0_, (int)p_148821_1_);
        }
    }

    static {
        lines = new RenderStage(true, false, false, false, () -> {
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
        }, () -> {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2929);
        }, 1);
        color = new RenderStage(true, false, false, true, () -> GL11.glDisable((int)3553), () -> GL11.glEnable((int)3553), 7);
    }

    private static class RenderStage
    implements RetroGLAccess.RetroLayer {
        private boolean color;
        private boolean texture;
        private boolean normal;
        private boolean lit;
        private Runnable begin;
        private Runnable end;
        private int glMode;

        public RenderStage(boolean color, boolean texture, boolean normal, boolean lit, Runnable begin, Runnable end, int glMode) {
            this.color = color;
            this.texture = texture;
            this.normal = normal;
            this.lit = lit;
            this.begin = begin;
            this.end = end;
            this.glMode = glMode;
        }

        public void begin(RetroTessellator buf) {
            this.begin.run();
            buf.begin(this.glMode);
        }

        public void end() {
            this.end.run();
        }
    }

    private static class RetroBuffer
    extends DirectBuffer<RetroTessellator> {
        private RenderStage stage;

        public RetroBuffer(RetroTessellator tes, RenderStage stage) {
            super(tes);
            this.stage = stage;
            stage.begin((RetroTessellator)this.buffer);
        }

        @Override
        protected void pushVertex(float x, float y, float z, float red, float green, float blue, float alpha, float u, float v, float nx, float ny, float nz) {
            ((RetroTessellator)this.buffer).pos(x, y, z);
            if (this.stage.texture) {
                ((RetroTessellator)this.buffer).tex(u, v);
            }
            if (this.stage.color) {
                ((RetroTessellator)this.buffer).color(red, green, blue, alpha, this.stage.lit);
            }
            if (this.stage.normal) {
                ((RetroTessellator)this.buffer).normal(nx, ny, nz);
            }
            ((RetroTessellator)this.buffer).endVertex();
        }

        @Override
        public void finish() {
            ((RetroTessellator)this.buffer).draw();
            this.stage.end();
        }
    }

    public static class RetroTessellator {
        private Tessellator t;
        private double x;
        private double y;
        private double z;

        public RetroTessellator(Tessellator t) {
            this.t = t;
        }

        public RetroTessellator tex(float i, float j) {
            this.t.setTextureUV((double)i, (double)j);
            return this;
        }

        public void endVertex() {
            this.t.addVertex(this.x, this.y, this.z);
        }

        public void begin(int p_78371_1_) {
            this.t.startDrawing(p_78371_1_);
        }

        public RetroTessellator pos(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public RetroTessellator color(float p_78369_1_, float p_78369_2_, float p_78369_3_, float p_78369_4_, boolean lit) {
            if (lit) {
                this.t.setColorRGBA_F(p_78369_1_ * lred, p_78369_2_ * lgreen, p_78369_3_ * lblue, p_78369_4_);
            } else {
                this.t.setColorRGBA_F(p_78369_1_, p_78369_2_, p_78369_3_, p_78369_4_);
            }
            return this;
        }

        public RetroTessellator normal(float p_78375_1_, float p_78375_2_, float p_78375_3_) {
            this.t.setNormal(p_78375_1_, p_78375_2_, p_78375_3_);
            return this;
        }

        public void draw() {
            this.t.draw();
        }
    }
}

