/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.BlockState;
import com.tom.cpl.block.BlockStateHandler;
import com.tom.cpl.item.Stack;
import com.tom.cpm.common.BlockMeta;
import com.tom.cpm.common.ItemStackHandlerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.ItemStack;

public class BlockStateHandlerImpl
extends BlockStateHandler<BlockMeta> {
    public static final String META = "metadata";
    public static final List<String> STATES = Collections.singletonList("metadata");
    public static final List<String> META_VALUES = new ArrayList<String>();
    public static final BlockStateHandlerImpl impl = new BlockStateHandlerImpl();

    @Override
    public String getBlockId(BlockMeta stack) {
        return "id:" + stack.getBlock().id();
    }

    @Override
    public List<String> getBlockStates(BlockMeta stack) {
        return STATES;
    }

    @Override
    public String getPropertyValue(BlockMeta state, String property) {
        if (property.equals(META)) {
            return String.valueOf(state.getMeta());
        }
        return null;
    }

    @Override
    public int getPropertyValueInt(BlockMeta state, String property) {
        if (property.equals(META)) {
            return state.getMeta();
        }
        return -1;
    }

    @Override
    public List<String> getAllValuesFor(BlockMeta state, String property) {
        if (property.equals(META)) {
            return META_VALUES;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> listTags(BlockMeta stack) {
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("#idmeta:" + stack.getBlock() + "/" + stack.getMeta());
        tags.add("#id:" + stack.getBlock());
        return tags;
    }

    @Override
    public List<BlockState> listNativeEntries(String tag) {
        return Collections.emptyList();
    }

    @Override
    public List<String> listNativeTags() {
        return Collections.emptyList();
    }

    @Override
    public List<BlockState> getAllElements() {
        ArrayList<BlockState> list = new ArrayList<BlockState>();
        for (int i = 0; i < Blocks.blocksList.length; ++i) {
            Block b = Blocks.blocksList[i];
            if (b == null) continue;
            list.add(this.wrap(new BlockMeta(i, 0)));
        }
        return list;
    }

    @Override
    public boolean isInTag(String tag, BlockMeta stack) {
        if (tag.charAt(0) == '#') {
            return ItemStackHandlerImpl.checkIdMetaTags(tag, stack.getBlockId(), stack.getMeta());
        }
        return this.getBlockId(stack).equals(tag);
    }

    @Override
    public boolean equals(BlockMeta a, BlockMeta b) {
        return a.getBlock() == b.getBlock();
    }

    @Override
    public Stack getStackFromState(BlockMeta state) {
        return ItemStackHandlerImpl.impl.wrap(new ItemStack(state.getBlock(), 1, 0));
    }

    @Override
    public boolean equalsFull(BlockMeta a, BlockMeta b) {
        return a.equals(b);
    }

    @Override
    public BlockState emptyObject() {
        return this.wrap(new BlockMeta(0, 0));
    }

    static {
        for (int i = 0; i < 16; ++i) {
            META_VALUES.add(String.valueOf(i));
        }
    }
}

