/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.ArgumentTypeBool;
import com.mojang.brigadier.arguments.ArgumentTypeFloat;
import com.mojang.brigadier.arguments.ArgumentTypeInteger;
import com.mojang.brigadier.arguments.ArgumentTypeString;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.tom.cpl.command.AbstractCommandBuilder;
import com.tom.cpl.command.ArgType;
import com.tom.cpl.command.CommandCtx;
import com.tom.cpl.command.CommandHandler;
import com.tom.cpl.command.LiteralCommandBuilder;
import com.tom.cpl.command.RequiredCommandBuilder;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class BrigadierBTACommandHandler<S>
implements CommandHandler<S> {
    private static final DynamicCommandExceptionType ERROR_FAILED = new DynamicCommandExceptionType(a -> (Message)new FormatText("commands.cpm.genericFail", a).remap());
    private final CommandDispatcher<S> dispatcher;

    public BrigadierBTACommandHandler(CommandDispatcher<S> dispatcher, boolean client) {
        this.dispatcher = dispatcher;
        if (client) {
            this.registerClient();
        } else {
            this.registerCommon();
        }
    }

    protected abstract boolean hasOPPermission(S var1);

    @Override
    public void register(LiteralCommandBuilder builder, boolean isOp) {
        ArgumentBuilderLiteral<S> cmd = this.literal(builder.getName());
        if (isOp) {
            cmd.requires(this::hasOPPermission);
        }
        this.build((ArgumentBuilder<S, ?>)cmd, builder, Collections.emptyList(), cmd.getLiteral().toLowerCase(Locale.ROOT));
        this.dispatcher.register(cmd);
    }

    private void build(ArgumentBuilder<S, ?> a, AbstractCommandBuilder<?> b, List<RequiredCommandBuilder> args, String prefix) {
        for (AbstractCommandBuilder<?> v : b.getNext()) {
            if (v instanceof LiteralCommandBuilder) {
                ArgumentBuilderLiteral<S> n = this.literal(((LiteralCommandBuilder)v).getName());
                this.build((ArgumentBuilder<S, ?>)n, v, args, prefix + "_" + n.getLiteral().toLowerCase(Locale.ROOT));
                a.then(n);
                continue;
            }
            if (!(v instanceof RequiredCommandBuilder)) continue;
            RequiredCommandBuilder rcb = (RequiredCommandBuilder)v;
            ArgumentBuilderRequired n = this.argument(rcb.getId(), this.getType(rcb.getType(), rcb.getSettings()));
            ArrayList<RequiredCommandBuilder> newArgs = new ArrayList<RequiredCommandBuilder>(args);
            newArgs.add(rcb);
            String name = prefix + "_" + rcb.getId().toLowerCase(Locale.ROOT);
            this.build((ArgumentBuilder<S, ?>)n, v, (List<RequiredCommandBuilder>)newArgs, name);
            Function<CommandCtx<?>, List<String>> s = rcb.getPossibleValues();
            if (s != null) {
                n.suggests((c, bu) -> BrigadierBTACommandHandler.suggestMatching((List)s.apply(new WrappedCtx(c, args)), bu));
            }
            a.then(n);
        }
        if (b.getFunc() != null) {
            Consumer<CommandCtx<?>> cmd = b.getFunc();
            a.executes(c -> {
                WrappedCtx ctx = new WrappedCtx(c, args);
                try {
                    cmd.accept(ctx);
                }
                catch (Exception e) {
                    Log.error("Command error, input: /" + c.getInput(), e);
                    throw ERROR_FAILED.create((Object)"Unknown error");
                }
                if (ctx.getFail() != null) {
                    throw ERROR_FAILED.create((Object)ctx.getFail());
                }
                return ctx.getResult();
            });
        }
    }

    private static CompletableFuture<Suggestions> suggestMatching(List<String> list, SuggestionsBuilder builder) {
        String txt = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String elem : list) {
            if (!elem.toLowerCase(Locale.ROOT).startsWith(txt)) continue;
            builder.suggest(elem);
        }
        return builder.buildFuture();
    }

    protected <T> ArgumentType<T> getType(ArgType type, Object settings) {
        switch (type) {
            case BOOLEAN: {
                return ArgumentTypeBool.bool();
            }
            case PLAYER: {
                return this.player();
            }
            case INT: {
                if (settings != null) {
                    Pair p = (Pair)settings;
                    return ArgumentTypeInteger.integer((int)((Integer)p.getKey()), (int)((Integer)p.getValue()));
                }
                return ArgumentTypeInteger.integer();
            }
            case STRING: {
                if (settings == null || !((Boolean)settings).booleanValue()) {
                    return ArgumentTypeString.string();
                }
                return ArgumentTypeString.greedyString();
            }
            case FLOAT: {
                if (settings != null) {
                    Pair p = (Pair)settings;
                    return ArgumentTypeFloat.floatArg((float)((Float)p.getKey()).floatValue(), (float)((Float)p.getValue()).floatValue());
                }
                return ArgumentTypeFloat.floatArg();
            }
        }
        return ArgumentTypeString.word();
    }

    protected <T> T getValue(CommandContext<S> ctx, ArgType type, String id) throws CommandSyntaxException {
        switch (type) {
            case BOOLEAN: {
                return (T)Boolean.valueOf(ArgumentTypeBool.getBool(ctx, (String)id));
            }
            case PLAYER: {
                return (T)this.getPlayer(ctx, id);
            }
            case INT: {
                return (T)Integer.valueOf(ArgumentTypeInteger.getInteger(ctx, (String)id));
            }
            case FLOAT: {
                return (T)Float.valueOf(ArgumentTypeFloat.getFloat(ctx, (String)id));
            }
        }
        return (T)ctx.getArgument(id, String.class);
    }

    public ArgumentBuilderLiteral<S> literal(String text) {
        return ArgumentBuilderLiteral.literal((String)text);
    }

    public <T> ArgumentBuilderRequired<S, T> argument(String id, ArgumentType<T> type) {
        return ArgumentBuilderRequired.argument((String)id, type);
    }

    protected abstract ArgumentType<?> player();

    protected abstract Object getPlayer(CommandContext<S> var1, String var2) throws CommandSyntaxException;

    private class WrappedCtx
    extends CommandCtx<S> {
        public WrappedCtx(CommandContext<S> ctx, List<RequiredCommandBuilder> args) throws CommandSyntaxException {
            super(ctx.getSource(), BrigadierBTACommandHandler.this);
            for (RequiredCommandBuilder arg : args) {
                this.arg(arg.getId(), BrigadierBTACommandHandler.this.getValue(ctx, arg.getType(), arg.getId()));
            }
        }
    }
}

